/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.EcmaLevelRule;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

final class SwitchToEcmaXFix
implements HintFix {
    private final FileObject fo;
    private final JsVersion ecmascriptEdition;

    public SwitchToEcmaXFix(Snapshot snapshot, JsVersion ecmascriptEdition) {
        this.fo = snapshot.getSource().getFileObject();
        this.ecmascriptEdition = ecmascriptEdition;
    }

    public String getDescription() {
        return Bundle.MSG_SwitchToEcmaX(this.ecmascriptEdition.name());
    }

    public void implement() throws Exception {
        if (this.fo == null) {
            return;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (p != null) {
            JsPreferences.putECMAScriptVersion(p, this.ecmascriptEdition);
        }
        EcmaLevelRule.refresh(this.fo);
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

