/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.debugger;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.AbstractObject;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Scope;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Script;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;

public class CallFrame
extends AbstractObject {
    private TransportHelper transport;

    CallFrame(JSONObject frame, WebKitDebugging webkit, TransportHelper transport) {
        super(frame, webkit);
        this.transport = transport;
    }

    public String getFunctionName() {
        return (String)this.getObject().get((Object)"functionName");
    }

    public String getCallFrameID() {
        return (String)this.getObject().get((Object)"callFrameId");
    }

    public Script getScript() {
        return this.getWebkit().getDebugger().getScript((String)this.getLocation().get((Object)"scriptId"));
    }

    private JSONObject getLocation() {
        return (JSONObject)this.getObject().get((Object)"location");
    }

    public int getLineNumber() {
        return ((Number)this.getLocation().get((Object)"lineNumber")).intValue();
    }

    public int getColumnNumber() {
        return ((Number)this.getLocation().get((Object)"columnNumber")).intValue();
    }

    public List<Scope> getScopes() {
        ArrayList<Scope> l = new ArrayList<Scope>();
        JSONArray array = (JSONArray)this.getObject().get((Object)"scopeChain");
        for (Object o : array) {
            l.add(new Scope((JSONObject)o, this.getWebkit()));
        }
        return l;
    }

    public RemoteObject evaluate(String expression) {
        block1: {
            JSONObject result;
            JSONObject params = new JSONObject();
            params.put((Object)"callFrameId", (Object)this.getCallFrameID());
            params.put((Object)"expression", (Object)expression);
            params.put((Object)"returnByValue", (Object)false);
            params.put((Object)"objectGroup", (Object)"netbeans-debugger-objects");
            boolean includeCommandLineAPI = true;
            while (true) {
                JSONObject jresponse;
                params.put((Object)"includeCommandLineAPI", (Object)includeCommandLineAPI);
                Response response = this.transport.sendBlockingCommand(new Command("Debugger.evaluateOnCallFrame", params));
                if (response == null || (jresponse = response.getResponse()) == null || (result = (JSONObject)jresponse.get((Object)"result")) == null || (result = (JSONObject)result.get((Object)"result")) == null) break block1;
                if (!includeCommandLineAPI || !"Error".equals(result.get((Object)"className")) || !(result.get((Object)"description") instanceof String) || !((String)result.get((Object)"description")).startsWith("SyntaxError: 'with' statements are not valid")) break;
                includeCommandLineAPI = false;
            }
            return new RemoteObject(result, this.getWebkit());
        }
        return null;
    }
}

