/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.base.Processes;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.Bundle;
import org.netbeans.modules.maven.execute.CommandLineOutputHandler;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.MavenProxySupport;
import org.netbeans.modules.maven.execute.ProxyNonSelectableInputOutput;
import org.netbeans.modules.maven.execute.cmd.Constructor;
import org.netbeans.modules.maven.execute.cmd.ShellConstructor;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.runjar.MavenExecuteUtils;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.NotificationDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class MavenCommandLineExecutor
extends AbstractMavenExecutor {
    static final String ENV_PREFIX = "Env.";
    static final String INTERNAL_PREFIX = "NbIde.";
    static final String ENV_JAVAHOME = "Env.JAVA_HOME";
    private static final String KEY_UUID = "NB_EXEC_MAVEN_PROCESS_UUID";
    private static final String NETBEANS_MAVEN_COMMAND_LINE = "NETBEANS_MAVEN_COMMAND_LINE";
    private Process process;
    private String processUUID;
    private Process preProcess;
    private String preProcessUUID;
    private static final SpecificationVersion VER18 = new SpecificationVersion("1.8");
    private static final Logger LOGGER = Logger.getLogger(MavenCommandLineExecutor.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(MavenCommandLineExecutor.class.getName(), 1);
    private static final RequestProcessor UPDATE_INDEX_RP = new RequestProcessor(RunUtils.class.getName(), 5);
    private static final String ICON_MAVEN_PROJECT = "org/netbeans/modules/maven/resources/Maven2Icon.gif";

    public static ExecutorTask executeMaven(RunConfig config, InputOutput io, AbstractMavenExecutor.TabContext tc) {
        ExecuteMaven runner = (ExecuteMaven)Lookup.getDefault().lookup(ExecuteMaven.class);
        if (runner == null) {
            runner = new ExecuteMaven();
        }
        return runner.execute(config, io, tc);
    }

    public MavenCommandLineExecutor(RunConfig conf, InputOutput io, AbstractMavenExecutor.TabContext tc) {
        super(conf, tc);
        this.io = io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        MavenProxySupport mps;
        Object object = this.SEMAPHORE;
        synchronized (object) {
            if (this.task == null) {
                try {
                    this.SEMAPHORE.wait();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINE, "interrupted", ex);
                }
            }
        }
        BeanRunConfig clonedConfig = new BeanRunConfig(this.config);
        clonedConfig.reassignMavenProjectFromParent();
        if (clonedConfig.getPreExecution() != null) {
            BeanRunConfig preconf = new BeanRunConfig(clonedConfig.getPreExecution());
            preconf.reassignMavenProjectFromParent();
            clonedConfig.setPreExecution(preconf);
        }
        int executionresult = -10;
        final InputOutput ioput = this.getInputOutput();
        MavenProxySupport mavenProxySupport = mps = clonedConfig.getProject() == null ? null : (MavenProxySupport)clonedConfig.getProject().getLookup().lookup(MavenProxySupport.class);
        if (mps != null) {
            boolean ok = false;
            try {
                MavenProxySupport.ProxyResult res = mps.checkProxySettings().get();
                if (res != null) {
                    res.configure(clonedConfig);
                }
                if (res.getStatus() == MavenProxySupport.Status.ABORT) {
                    IOException ex = res.getException();
                    if (ex != null) throw ex;
                    ioput.getErr().append((CharSequence)Bundle.ERR_BuildCancelled());
                } else {
                    ok = true;
                }
            }
            catch (IOException ex) {
                NotificationDisplayer.getDefault().notify(Bundle.TITLE_ProxyUpdateFailed(), (Icon)ImageUtilities.loadImageIcon((String)ICON_MAVEN_PROJECT, (boolean)false), ex.getLocalizedMessage(), null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.ERROR);
                ioput.getErr().append((CharSequence)Bundle.ERR_CannotOverrideProxy(ex.getLocalizedMessage()));
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.log(Level.WARNING, "could not determine proxy settings", ex);
            }
            finally {
                if (!ok) {
                    ioput.getOut().close();
                    ioput.getErr().close();
                    this.actionStatesAtFinish(null, null);
                    this.markFreeTab();
                }
            }
        }
        ProgressHandle handle = ProgressHandle.createHandle((String)clonedConfig.getTaskDisplayName(), (Cancellable)this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ioput.select();
            }
        });
        this.actionStatesAtStart();
        ExecutionContext exCon = ActionToGoalUtils.ACCESSOR.createContext(ioput, handle);
        if (clonedConfig.getProject() != null) {
            Lookup.Result result = clonedConfig.getProject().getLookup().lookupResult(LateBoundPrerequisitesChecker.class);
            for (LateBoundPrerequisitesChecker elem : result.allInstances()) {
                if (!elem.checkRunConfig(clonedConfig, exCon)) {
                    ioput.getOut().close();
                    ioput.getErr().close();
                    this.actionStatesAtFinish(null, null);
                    this.markFreeTab();
                    return;
                }
                if (clonedConfig.getPreExecution() == null || elem.checkRunConfig(clonedConfig.getPreExecution(), exCon)) continue;
                ioput.getOut().close();
                ioput.getErr().close();
                this.actionStatesAtFinish(null, null);
                this.markFreeTab();
                return;
            }
        }
        handle.start();
        this.processInitialMessage();
        boolean isMaven3 = !this.isMaven2();
        boolean singlethreaded = !this.isMultiThreaded(clonedConfig);
        boolean eventSpyCompatible = this.isEventSpyCompatible(clonedConfig);
        if (isMaven3 && singlethreaded && eventSpyCompatible) {
            this.injectEventSpy(clonedConfig);
            if (clonedConfig.getPreExecution() != null) {
                this.injectEventSpy((BeanRunConfig)clonedConfig.getPreExecution());
            }
        }
        CommandLineOutputHandler out = new CommandLineOutputHandler(ioput, clonedConfig.getProject(), handle, clonedConfig, isMaven3 && singlethreaded);
        try {
            ProcessBuilder builder;
            BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)this.item);
            if (MavenSettings.getDefault().isAlwaysShowOutput()) {
                ioput.select();
            }
            if (clonedConfig.getPreExecution() != null) {
                builder = this.constructBuilder(clonedConfig.getPreExecution(), ioput);
                this.preProcessUUID = UUID.randomUUID().toString();
                builder.environment().put(KEY_UUID, this.preProcessUUID);
                if (this.executeProcess(out, builder, p -> {
                    this.preProcess = p;
                }) != 0) {
                    return;
                }
            }
            builder = this.constructBuilder(clonedConfig, ioput);
            this.printCoSWarning(clonedConfig, ioput);
            this.processUUID = UUID.randomUUID().toString();
            builder.environment().put(KEY_UUID, this.processUUID);
            executionresult = this.executeProcess(out, builder, p -> {
                this.process = p;
            });
            return;
        }
        catch (IOException x) {
            if (Utilities.isWindows()) {
                this.processIssue153101(x, ioput);
                return;
            } else {
                ioput.getErr().println(x.getMessage());
            }
            return;
        }
        catch (InterruptedException x) {
            this.cancel();
            return;
        }
        catch (ThreadDeath death) {
            this.cancel();
            throw death;
        }
        finally {
            BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)this.item);
            try {
                out.buildFinished();
                if (clonedConfig.getProject() != null) {
                    Lookup.Result result = clonedConfig.getProject().getLookup().lookupResult(ExecutionResultChecker.class);
                    for (ExecutionResultChecker elem : result.allInstances()) {
                        elem.executionResult(clonedConfig, exCon, executionresult);
                    }
                }
            }
            finally {
                Object impl;
                handle.finish();
                ioput.getOut().close();
                ioput.getErr().close();
                this.actionStatesAtFinish(out.createResumeFromFinder(), out.getExecutionTree());
                this.markFreeTab();
                Project prj = clonedConfig.getProject();
                if (prj != null && (impl = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
                    RequestProcessor.Task reloadTask = ((NbMavenProjectImpl)impl).fireProjectReload();
                    reloadTask.waitFinished();
                }
            }
        }
    }

    private boolean isEventSpyCompatible(BeanRunConfig clonedConfig) {
        if (clonedConfig.getProject() != null) {
            ActiveJ2SEPlatformProvider javaprov = (ActiveJ2SEPlatformProvider)clonedConfig.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class);
            JavaPlatform platform = javaprov.getJavaPlatform();
            return platform.getSpecification().getVersion().compareTo(VER18) >= 0;
        }
        return true;
    }

    int executeProcess(CommandLineOutputHandler out, ProcessBuilder builder, Consumer<Process> processSetter) throws IOException, InterruptedException {
        Process p = builder.start();
        processSetter.accept(p);
        out.setStdOut(p.getInputStream());
        out.setStdIn(p.getOutputStream());
        int executionresult = p.waitFor();
        out.waitFor();
        return executionresult;
    }

    private void kill(Process prcs, String uuid) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(KEY_UUID, uuid);
        Processes.killTree((Process)prcs, env);
    }

    public boolean cancel() {
        Process pre = this.preProcess;
        this.preProcess = null;
        Process pro = this.process;
        this.process = null;
        RP.post(() -> {
            if (pre != null) {
                this.kill(pre, this.preProcessUUID);
            }
            if (pro != null) {
                this.kill(pro, this.processUUID);
            }
        });
        return true;
    }

    private static List<String> createMavenExecutionCommand(RunConfig config, Constructor base) {
        String opts;
        Object o;
        String enc;
        ArrayList<String> toRet = new ArrayList<String>(base.construct());
        if (Utilities.isUnix()) {
            File basedir = config.getExecutionDirectory();
            try {
                File pom;
                if (basedir != null && !basedir.equals(basedir.getCanonicalFile()) && (pom = new File(basedir, "pom.xml")).isFile()) {
                    toRet.add("-f");
                    toRet.add(pom.getAbsolutePath());
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.FINE, "Could not canonicalize " + basedir, x);
            }
        }
        String quote = "\"";
        for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
            String k = entry.getKey();
            if (k.startsWith(ENV_PREFIX) || k.startsWith(INTERNAL_PREFIX)) continue;
            String value = MavenCommandLineExecutor.quote2apos(entry.getValue());
            String string = "-D" + entry.getKey() + "=" + value;
            String s = Utilities.isWindows() && value.contains(" ") ? quote + string + quote : string;
            toRet.add(s);
        }
        if (config.getMavenProject() != null && (enc = config.getMavenProject().getProperties().getProperty("project.build.sourceEncoding")) != null && !enc.equals(Charset.defaultCharset().name())) {
            toRet.add("-Dfile.encoding=" + enc);
        }
        if (config.isOffline() != null && config.isOffline().booleanValue()) {
            toRet.add("--offline");
        }
        if (!config.isInteractive()) {
            toRet.add("--batch-mode");
        }
        if (!config.isRecursive()) {
            toRet.add("--non-recursive");
        }
        if (config.isShowDebug()) {
            toRet.add("--debug");
        }
        if (config.isShowError()) {
            toRet.add("--errors");
        }
        if (config.isUpdateSnapshots()) {
            toRet.add("--update-snapshots");
        }
        if (config.getReactorStyle() != RunConfig.ReactorStyle.NONE) {
            String rel;
            File basedir = config.getExecutionDirectory();
            MavenProject mp = NbMavenProject.getPartialProject(config.getMavenProject());
            File projdir = mp == null || NbMavenProject.isErrorPlaceholder(mp) ? basedir : mp.getBasedir();
            String string = rel = basedir != null && projdir != null ? FileUtilities.relativizeFile(basedir, projdir) : null;
            if (!".".equals(rel)) {
                toRet.add(config.getReactorStyle() == RunConfig.ReactorStyle.ALSO_MAKE ? "--also-make" : "--also-make-dependents");
                toRet.add("--projects");
                toRet.add((String)(rel != null ? rel : mp.getGroupId() + ":" + mp.getArtifactId()));
            }
        }
        if ((o = config.getInternalProperties().get("NbIde.configOverride")) instanceof String) {
            toRet.add("--settings");
            toRet.add(o.toString());
        }
        if ((opts = MavenSettings.getDefault().getDefaultOptions()) != null) {
            try {
                String[] s = CommandLineUtils.translateCommandline((String)opts);
                for (String string : s) {
                    String string2 = string.trim();
                    if (!string2.startsWith("-D") && (!config.isShowDebug() && (string2.equals("-X") || string2.equals("--debug")) || !config.isShowError() && (string2.equals("-e") || string2.equals("--errors")) || !config.isUpdateSnapshots() && (string2.equals("--update-snapshots") || string2.equals("-U")) || config.isInteractive() && (string2.equals("--batch-mode") || string2.equals("-B")) || config.isOffline() != null && !config.isOffline().booleanValue() && (string2.equals("--offline") || string2.equals("-o")))) continue;
                    toRet.add(string2);
                }
            }
            catch (Exception ex1) {
                Logger.getLogger(MavenSettings.class.getName()).log(Level.FINE, "Error parsing global options:{0}", opts);
            }
        }
        Object profiles = "";
        for (Object e : config.getActivatedProfiles()) {
            profiles = (String)profiles + "," + e;
        }
        if (((String)profiles).length() > 0) {
            profiles = ((String)profiles).substring(1);
            toRet.add("-P" + (String)profiles);
        }
        for (String string : config.getGoals()) {
            toRet.add(string);
        }
        return toRet;
    }

    private static String quote2apos(String s) {
        boolean inQuote = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (++i < s.length()) {
                    char c2 = s.charAt(i);
                    if (inQuote) {
                        if (c2 == '\'') {
                            sb.append("'\"'\"'");
                            continue;
                        }
                        if (c2 == '\"') {
                            sb.append(c2);
                            continue;
                        }
                    }
                    sb.append(c);
                    sb.append(c2);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\'') {
                if (inQuote) {
                    sb.append("'\"'\"'");
                    continue;
                }
                inQuote = !inQuote;
                sb.append('\'');
                continue;
            }
            if (c == '\"') {
                inQuote = !inQuote;
                sb.append('\'');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    ProcessBuilder constructBuilder(RunConfig clonedConfig, InputOutput ioput) {
        Constructor constructeur;
        File javaHome = null;
        LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>();
        for (Map.Entry<? extends String, ? extends String> entry : clonedConfig.getProperties().entrySet()) {
            if (!entry.getKey().startsWith(ENV_PREFIX)) continue;
            String env = entry.getKey().substring(ENV_PREFIX.length());
            envMap.put(env, entry.getValue());
            if (!entry.getKey().equals(ENV_JAVAHOME)) continue;
            javaHome = new File(entry.getValue());
        }
        if (javaHome == null) {
            ActiveJ2SEPlatformProvider javaprov;
            FileObject java;
            if (clonedConfig.getProject() != null && (java = (javaprov = (ActiveJ2SEPlatformProvider)clonedConfig.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform().findTool("java")) != null) {
                Collection objs = javaprov.getJavaPlatform().getInstallFolders();
                for (FileObject fo : objs) {
                    if (!FileUtil.isParentOf((FileObject)fo, (FileObject)java)) continue;
                    File path = FileUtil.toFile((FileObject)fo);
                    if (path == null) break;
                    javaHome = path;
                    envMap.put(ENV_JAVAHOME.substring(ENV_PREFIX.length()), path.getAbsolutePath());
                    break;
                }
            }
            if (javaHome == null) {
                File f;
                String envJH = System.getenv("JAVA_HOME");
                if (!(envJH == null || (f = new File(envJH)).exists() && new File(f, "bin" + File.separator + "java" + (Utilities.isWindows() ? ".exe" : "")).exists())) {
                    envJH = null;
                }
                if (envJH == null) {
                    javaHome = new File(System.getProperty("java.home"));
                    envMap.put("JAVA_HOME", javaHome.getAbsolutePath());
                } else {
                    javaHome = new File(envJH);
                    envMap.put("JAVA_HOME", javaHome.getAbsolutePath());
                }
            }
        }
        File mavenHome = null;
        File wrapper = null;
        if (MavenSettings.getDefault().isPreferMavenWrapper()) {
            wrapper = this.searchMavenWrapper(clonedConfig);
        }
        if (wrapper != null) {
            constructeur = new WrapperShellConstructor(wrapper);
        } else {
            mavenHome = EmbedderFactory.getEffectiveMavenHome();
            constructeur = new ShellConstructor(mavenHome);
        }
        List<String> cmdLine = MavenCommandLineExecutor.createMavenExecutionCommand(clonedConfig, constructeur);
        if (cmdLine.get(0).equals("cmd")) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = cmdLine.iterator();
            it.next();
            it.next();
            String m = it.next();
            sb.append(m);
            while (it.hasNext()) {
                sb.append(" ").append(it.next());
            }
            envMap.put(NETBEANS_MAVEN_COMMAND_LINE, sb.toString());
            cmdLine = Arrays.asList("cmd", "/c", "%NETBEANS_MAVEN_COMMAND_LINE%");
        }
        ProcessBuilder builder = new ProcessBuilder(cmdLine);
        builder.redirectErrorStream(true);
        builder.directory(clonedConfig.getExecutionDirectory());
        StringBuilder display = new StringBuilder("cd ").append(clonedConfig.getExecutionDirectory()).append("; ");
        for (Map.Entry entry : envMap.entrySet()) {
            String env = (String)entry.getKey();
            String val = (String)entry.getValue();
            if ("M2_HOME".equals(env.toUpperCase(Locale.ENGLISH))) continue;
            if (MavenExecuteUtils.isEnvRemovedValue(val)) {
                builder.environment().remove(env);
            } else {
                builder.environment().put(env, val);
            }
            if (env.equals("netbeansProjectMappings") || env.equals(NETBEANS_MAVEN_COMMAND_LINE)) continue;
            display.append(Utilities.escapeParameters((String[])new String[]{env + "=" + val})).append(' ');
        }
        if (mavenHome != null) {
            builder.environment().put("M2_HOME", mavenHome.getAbsolutePath());
            if (!mavenHome.equals(EmbedderFactory.getDefaultMavenHome())) {
                display.append(Utilities.escapeParameters((String[])new String[]{"M2_HOME=" + mavenHome.getAbsolutePath()})).append(' ');
            }
        }
        if (envMap.containsKey(NETBEANS_MAVEN_COMMAND_LINE)) {
            display.append(Utilities.escapeParameters((String[])new String[]{"cmd", "/c", (String)envMap.get(NETBEANS_MAVEN_COMMAND_LINE)}));
        } else {
            ArrayList<String> command = new ArrayList<String>(builder.command());
            command.removeIf(s -> s.startsWith("-Dmaven.ext.class.path="));
            display.append(Utilities.escapeParameters((String[])command.toArray(new String[0])));
        }
        MavenCommandLineExecutor.printGray(ioput, display.toString());
        return builder;
    }

    private static void printColor(InputOutput io, String text, IOColors.OutputType style) {
        if (IOColorLines.isSupported((InputOutput)io)) {
            try {
                IOColorLines.println((InputOutput)io, (CharSequence)text, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)style));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            io.getOut().println(text);
        }
    }

    private static void printGray(InputOutput io, String text) {
        MavenCommandLineExecutor.printColor(io, text, IOColors.OutputType.LOG_DEBUG);
    }

    private void processIssue153101(IOException x, InputOutput ioput) {
        if (x.getMessage() != null && x.getMessage().contains("CreateProcess error=5")) {
            System.setProperty("maven.run.cmd", "true");
            LOGGER.log(Level.INFO, "Cannot create Process, next time we will run the build with 'cmd /c'", x);
            ioput.getErr().println("Cannot execute the mvn.bat executable directly due to wrong access rights, switching to execution via 'cmd.exe /c mvn.bat'.");
            try {
                ioput.getErr().println("  See issue http://www.netbeans.org/issues/show_bug.cgi?id=153101 for details.", new OutputListener(){

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineCleared(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        try {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.netbeans.org/issues/show_bug.cgi?id=153101"));
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ioput.getErr().println("  This message will show on the next start of the IDE again, to skip it, add -J-Dmaven.run.cmd=true to your etc/netbeans.conf file in your NetBeans installation.");
            ioput.getErr().println("The detailed exception output is printed to the IDE's log file.");
            RP.post(() -> {
                BeanRunConfig newConfig = new BeanRunConfig(this.config);
                RunUtils.executeMaven(newConfig);
            });
        } else {
            ioput.getErr().println(x.getMessage());
        }
    }

    private void printCoSWarning(BeanRunConfig clonedConfig, InputOutput ioput) {
        if (clonedConfig.getProperties().containsKey("Env.netbeansProjectMappings")) {
            MavenCommandLineExecutor.printGray(ioput, "Running NetBeans Compile On Save execution. Phase execution is skipped and output directories of dependency projects (with Compile on Save turned on) will be used instead of their jar artifacts.");
            if (this.isMaven2()) {
                MavenCommandLineExecutor.printGray(ioput, "WARNING: Using Maven 2.x for execution, NetBeans cannot establish links between current project and output directories of dependency projects with Compile on Save turned on. Only works with Maven 3.0+.");
            }
        }
        if (clonedConfig.getProperties().containsKey("exec.args.merged")) {
            MavenCommandLineExecutor.printGray(ioput, "\nDefault '" + clonedConfig.getActionName() + "' action exec.args merged with maven-exec-plugin arguments declared in pom.xml.");
        }
    }

    boolean isMaven2() {
        File mvnHome = EmbedderFactory.getEffectiveMavenHome();
        String version = MavenSettings.getCommandLineMavenVersion(mvnHome);
        return version != null && version.startsWith("2");
    }

    private boolean isMavenDaemon() {
        File mvnHome = EmbedderFactory.getEffectiveMavenHome();
        return MavenSettings.isMavenDaemon(Paths.get(mvnHome.getPath(), new String[0]));
    }

    private void injectEventSpy(BeanRunConfig clonedConfig) {
        Object mavenPath = clonedConfig.getProperties().get("maven.ext.class.path");
        File jar = InstalledFileLocator.getDefault().locate("maven-nblib/netbeans-eventspy.jar", "org.netbeans.modules.maven", false);
        if (jar == null) {
            return;
        }
        if (mavenPath == null) {
            mavenPath = "";
        } else {
            String delimiter;
            String string = delimiter = Utilities.isWindows() ? ";" : ":";
            if (((String)mavenPath).contains(jar + delimiter)) {
                return;
            }
            mavenPath = delimiter + (String)mavenPath;
        }
        mavenPath = jar.getAbsolutePath() + (String)mavenPath;
        clonedConfig.setProperty("maven.ext.class.path", (String)mavenPath);
    }

    private boolean isMultiThreaded(BeanRunConfig clonedConfig) {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(Arrays.asList(MavenSettings.getDefault().getDefaultOptions().split(" ")));
        params.addAll(clonedConfig.getGoals());
        if (clonedConfig.getPreExecution() != null) {
            params.addAll(clonedConfig.getPreExecution().getGoals());
        }
        return this.isMavenDaemon() ? MavenCommandLineExecutor.isMultiThreadedMvnd(params) : MavenCommandLineExecutor.isMultiThreadedMaven(params);
    }

    static boolean isMultiThreadedMvnd(List<String> params) {
        for (int i = 0; i < params.size(); ++i) {
            String p = params.get(i);
            if (p.equals("-1") || p.equals("--serial") || p.equals("-Dmvnd.serial")) {
                return false;
            }
            if (i + 1 < params.size() && (p.equals("-T") || p.equals("--threads")) && params.get(i + 1).equals("1")) {
                return false;
            }
            try {
                if (!p.startsWith("-Dmvnd.threads=") || Integer.parseInt(p.substring(15)) != 1) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    static boolean isMultiThreadedMaven(List<String> params) {
        for (int i = 0; i < params.size() - 1; ++i) {
            String p = params.get(i);
            if (!p.equals("-T") && !p.equals("--threads") || params.get(i + 1).equals("1")) continue;
            return true;
        }
        return false;
    }

    private File resolveWrapperPath(File wrapper, RunConfig config) {
        Path relative;
        Path absDir;
        File absWrapper = wrapper.getAbsoluteFile();
        File executionDir = config.getExecutionDirectory();
        Path absWrapperDir = absWrapper.toPath().getParent();
        if ((absWrapperDir.startsWith(absDir = executionDir.getAbsoluteFile().toPath()) || absDir.startsWith(absWrapperDir)) && !(relative = absDir.relativize(wrapper.getAbsoluteFile().toPath())).toString().contains(" ")) {
            if (relative.getNameCount() == 1) {
                return Paths.get(".", new String[0]).resolve(relative).toFile();
            }
            return relative.toFile();
        }
        if (absWrapper.toString().contains(" ")) {
            MavenCommandLineExecutor.printColor(this.io, Bundle.WARN_SpaceInPath(), IOColors.OutputType.LOG_WARNING);
        }
        return absWrapper;
    }

    private File searchMavenWrapper(RunConfig config) {
        String fileName = Utilities.isWindows() ? "mvnw.cmd" : "mvnw";
        for (MavenProject project = NbMavenProject.getPartialProject(config.getMavenProject()); project != null; project = project.getParent()) {
            File mvnw;
            File baseDir = project.getBasedir();
            if (baseDir == null || !(mvnw = new File(baseDir, fileName)).exists()) continue;
            return this.resolveWrapperPath(mvnw, config);
        }
        return null;
    }

    public static class ExecuteMaven {
        MavenExecutor createCommandLineExecutor(RunConfig config, InputOutput io, AbstractMavenExecutor.TabContext tc) {
            return new MavenCommandLineExecutor(config, io, tc);
        }

        public ExecutorTask execute(RunConfig config, InputOutput io, AbstractMavenExecutor.TabContext tc) {
            LifecycleManager.getDefault().saveAll();
            MavenExecutor exec = this.createCommandLineExecutor(config, io, tc);
            ExecutorTask task = ExecutionEngine.getDefault().execute(config.getTaskDisplayName(), (Runnable)exec, (InputOutput)new ProxyNonSelectableInputOutput(exec.getInputOutput()));
            exec.setTask(task);
            task.addTaskListener(t -> {
                MavenProject mp = config.getMavenProject();
                if (mp == null) {
                    return;
                }
                ArrayList<Artifact> arts = new ArrayList<Artifact>();
                Artifact main = mp.getArtifact();
                if (main != null) {
                    arts.add(main);
                }
                arts.addAll(mp.getArtifacts());
                UPDATE_INDEX_RP.post(() -> RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)RepositoryPreferences.getInstance().getLocalRepository(), (Collection)arts));
            });
            return task;
        }
    }

    private static class WrapperShellConstructor
    implements Constructor {
        @NonNull
        private final File wrapper;

        WrapperShellConstructor(@NonNull File wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public List<String> construct() {
            String quote = "\"";
            ArrayList<String> toRet = new ArrayList<String>();
            toRet.add(WrapperShellConstructor.quoteSpaces(this.wrapper.getPath(), quote));
            if (Utilities.isWindows()) {
                toRet.add(0, "/c");
                toRet.add(0, "cmd");
            }
            return toRet;
        }

        private static String quoteSpaces(String val, String quote) {
            if (Utilities.isWindows()) {
                return quote + val + quote;
            }
            return val;
        }
    }
}

