/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.websvc.saas.codegen.java.support.Xsd2Java;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;

public class WadlSaasEx {
    private WadlSaas wadlSaas;
    private ArrayList<FileObject> jaxbJars;
    private ArrayList<FileObject> jaxbSourceJars;

    public WadlSaasEx(WadlSaas wadlSaas) {
        this.wadlSaas = wadlSaas;
    }

    private boolean compileSchemas() throws IOException {
        assert (this.wadlSaas != null);
        assert (this.wadlSaas.getWadlModel() != null);
        this.jaxbJars = new ArrayList();
        this.jaxbSourceJars = new ArrayList();
        for (FileObject xsdFile : this.wadlSaas.getLocalSchemaFiles()) {
            Xsd2Java xjCompiler = new Xsd2Java(xsdFile, this.wadlSaas.getPackageName() + "." + SaasUtil.toValidJavaName((String)xsdFile.getName()).toLowerCase());
            if (!xjCompiler.compile()) {
                return false;
            }
            this.jaxbJars.add(xjCompiler.getJaxbJarFile());
            this.jaxbSourceJars.add(xjCompiler.getJaxbSourceJarFile());
        }
        return true;
    }

    public List<FileObject> getLibraryJars() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        if (this.jaxbJars == null) {
            try {
                this.compileSchemas();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        result.addAll(this.jaxbJars);
        return result;
    }

    public List<FileObject> getJaxbSourceJars() {
        if (this.jaxbSourceJars == null) {
            try {
                this.compileSchemas();
                return Collections.unmodifiableList(this.jaxbSourceJars);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return Collections.emptyList();
    }
}

