/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SubProjectsNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(SubProjectsNode.class.getName());
    private static final String SP_BADGE = "org/netbeans/modules/gradle/resources/gradle-large-badge.png";

    public SubProjectsNode(NbGradleProjectImpl proj, String path) {
        super(Children.create((ChildFactory)new SubProjectsChildFactory(proj), (boolean)true));
        if (":".equals(path)) {
            this.setName("SubProjects");
            this.setDisplayName(Bundle.LBL_SubProjects());
        } else {
            int colon = path.lastIndexOf(58, path.length() - 2);
            String partName = path.substring(colon + 1, path.length() - 1);
            this.setDisplayName(Utils.capitalize(partName));
            this.setName(path);
        }
    }

    public SubProjectsNode(NbGradleProjectImpl proj) {
        this(proj, ":");
    }

    public Action[] getActions(boolean bool) {
        return new Action[0];
    }

    private static Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)SP_BADGE, (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)4, (int)4);
    }

    public Image getIcon(int type) {
        return SubProjectsNode.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return SubProjectsNode.getIcon(true);
    }

    public static Node createSubProjectNode(Project prj) {
        return SubProjectsNode.createSubProjectNode(prj, null, Children.LEAF);
    }

    public static Node createSubProjectNode(Project prj, String path, Children children) {
        ProjectFilterNode ret = null;
        if (prj.getLookup().lookup(NbGradleProjectImpl.class) != null) {
            assert (prj.getLookup().lookup(LogicalViewProvider.class) != null);
            Node original = ((LogicalViewProvider)prj.getLookup().lookup(LogicalViewProvider.class)).createLogicalView();
            ret = new ProjectFilterNode(path, original, children);
        }
        return ret;
    }

    private static class SubProjectsChildFactory
    extends ChildFactory<Project> {
        private final Project project;
        private final PropertyChangeListener propListener;
        private final PreferenceChangeListener prefListener;

        SubProjectsChildFactory(Project proj) {
            this.project = proj;
            this.propListener = evt -> {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    ProjectManager.getDefault().clearNonProjectCache();
                    this.refresh(false);
                }
            };
            NbGradleProject.addPropertyChangeListener(this.project, WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)NbGradleProject.get(this.project)));
            this.prefListener = evt -> {
                if ("displayDescription".equals(evt.getKey())) {
                    this.refresh(false);
                }
            };
            Preferences prefs = GradleSettings.getDefault().getPreferences();
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)prefs));
        }

        protected boolean createKeys(List<Project> projects) {
            Set containedProjects = ProjectUtils.getContainedProjects((Project)this.project, (boolean)false);
            if (containedProjects != null) {
                ArrayList<Project> ret = new ArrayList<Project>(containedProjects);
                if (GradleSettings.getDefault().isDisplayDesctiption()) {
                    ret.sort(Comparator.comparing(p -> ProjectUtils.getInformation((Project)p).getDisplayName()));
                } else {
                    ret.sort(Comparator.comparing(p -> ProjectUtils.getInformation((Project)p).getName()));
                }
                projects.addAll(ret);
            } else {
                LOG.log(Level.FINE, "No ProjectContainerProvider in the lookup of: {0}", this.project);
            }
            return true;
        }

        protected Node createNodeForKey(Project key) {
            GradleBaseProject gbp;
            Set containedProjects = ProjectUtils.getContainedProjects((Project)key, (boolean)false);
            if (containedProjects == null) {
                containedProjects = Collections.emptySet();
                LOG.log(Level.FINE, "No ProjectContainerProvider in the lookup of: {0}", this.project);
            }
            String prefix = ((gbp = GradleBaseProject.get(this.project)) != null && !gbp.isRoot() ? gbp.getPath() : "") + ":";
            Children ch = containedProjects.isEmpty() ? Children.LEAF : Children.create((ChildFactory)new SubProjectsChildFactory(key), (boolean)true);
            return SubProjectsNode.createSubProjectNode(key, prefix, ch);
        }
    }

    public static class ProjectFilterNode
    extends FilterNode {
        private final String prefix;

        ProjectFilterNode(String prefix, Node original, Children children) {
            super(original, children);
            this.prefix = prefix;
        }

        ProjectFilterNode(Node original) {
            this(null, original, FilterNode.Children.LEAF);
        }

        public String getDisplayName() {
            GradleBaseProject gbp;
            boolean usePath = super.getName().equals(super.getDisplayName());
            if (usePath && this.prefix != null && (gbp = GradleBaseProject.get((Project)this.getLookup().lookup(Project.class))) != null) {
                String path = gbp.getPath();
                return path.startsWith(this.prefix) && path.length() > this.prefix.length() ? path.substring(this.prefix.length()) : path;
            }
            return super.getDisplayName();
        }

        public Action[] getActions(boolean b) {
            return new Action[]{OpenProjectAction.SINGLETON};
        }

        public Action getPreferredAction() {
            return OpenProjectAction.SINGLETON;
        }
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(Bundle.BTN_Open_Project()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection projects = context.lookupAll(NbGradleProjectImpl.class);
                    Project[] projectsArray = projects.toArray(new NbGradleProjectImpl[0]);
                    OpenProjects.getDefault().open(projectsArray, false, true);
                    if (projectsArray.length > 0) {
                        RequestProcessor.getDefault().post(() -> 1.lambda$actionPerformed$0((NbGradleProjectImpl[])projectsArray), 500);
                    }
                }

                private static /* synthetic */ void lambda$actionPerformed$0(NbGradleProjectImpl[] projectsArray) {
                    OpenProjects.getDefault().open((Project[])projectsArray, false, true);
                }
            };
        }
    }
}

