/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vault.Vaults;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VaultsWaiters {
    private final ExecutorService executorService;
    private final Vaults client;

    public VaultsWaiters(ExecutorService executorService, Vaults client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, Secret.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecret(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, Secret.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecret(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Secret.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecret(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecretRequest, GetSecretResponse> forSecret(BmcGenericWaiter waiter, GetSecretRequest request, Secret.LifecycleState ... targetStates) {
        final HashSet<Secret.LifecycleState> targetStatesSet = new HashSet<Secret.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecretRequest, GetSecretResponse>(){

            @Override
            public GetSecretResponse apply(GetSecretRequest request) {
                return VaultsWaiters.this.client.getSecret(request);
            }
        }, (Predicate)new Predicate<GetSecretResponse>(){

            @Override
            public boolean test(GetSecretResponse response) {
                return targetStatesSet.contains((Object)response.getSecret().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Secret.LifecycleState.Deleted)), (Object)request);
    }
}

