/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import nu.validator.datatype.ContentSecurityPolicy;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.ObservableInputStream;
import nu.validator.io.StreamBoundException;
import nu.validator.io.StreamObserver;
import nu.validator.io.SystemIdIOException;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.TypedInputSource;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrudentHttpEntityResolver
implements EntityResolver {
    private static final Logger log4j = Logger.getLogger(PrudentHttpEntityResolver.class.getName());
    private static HttpClient client;
    private static int maxRequests;
    private long sizeLimit;
    private final ErrorHandler errorHandler;
    private int requestsLeft;
    private boolean allowRnc = false;
    private boolean allowCss = false;
    private boolean allowHtml = false;
    private boolean allowXhtml = false;
    private boolean acceptAllKnownXmlTypes = false;
    private boolean allowGenericXml = true;
    private final ContentTypeParser contentTypeParser;
    private String userAgent;
    private HttpServletRequest request;

    public static void setParams(int connectionTimeout, int socketTimeout, int maxRequests) {
        PrudentHttpEntityResolver.maxRequests = maxRequests;
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        builder.setMaxConnPerRoute(maxRequests);
        builder.setMaxConnTotal(Integer.parseInt(System.getProperty("nu.validator.servlet.max-total-connections", "200")));
        if ("true".equals(System.getProperty("nu.validator.xml.promiscuous-ssl", "true"))) {
            try {
                SSLContext promiscuousSSLContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                builder.setSslcontext(promiscuousSSLContext);
                X509HostnameVerifier verifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLConnectionSocketFactory promiscuousSSLConnSocketFactory = new SSLConnectionSocketFactory(promiscuousSSLContext, (HostnameVerifier)verifier);
                registry = RegistryBuilder.create().register("https", (Object)promiscuousSSLConnSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
            }
            catch (NumberFormatException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        PoolingHttpClientConnectionManager phcConnMgr = new PoolingHttpClientConnectionManager(registry);
        phcConnMgr.setDefaultMaxPerRoute(maxRequests);
        phcConnMgr.setMaxTotal(200);
        builder.setConnectionManager((HttpClientConnectionManager)phcConnMgr);
        RequestConfig.Builder config = RequestConfig.custom();
        config.setCircularRedirectsAllowed(true);
        config.setMaxRedirects(Integer.parseInt(System.getProperty("nu.validator.servlet.max-redirects", "20")));
        config.setConnectTimeout(connectionTimeout);
        config.setCookieSpec("best-match");
        config.setSocketTimeout(socketTimeout);
        config.setCookieSpec("ignoreCookies");
        client = builder.setDefaultRequestConfig(config.build()).build();
    }

    public void setUserAgent(String ua) {
        this.userAgent = ua;
    }

    public PrudentHttpEntityResolver(long sizeLimit, boolean laxContentType, ErrorHandler errorHandler, HttpServletRequest request) {
        this.request = request;
        this.sizeLimit = sizeLimit;
        this.requestsLeft = maxRequests;
        this.errorHandler = errorHandler;
        this.contentTypeParser = new ContentTypeParser(errorHandler, laxContentType, this.allowRnc, this.allowHtml, this.allowXhtml, this.acceptAllKnownXmlTypes, this.allowGenericXml);
    }

    public PrudentHttpEntityResolver(long sizeLimit, boolean laxContentType, ErrorHandler errorHandler) {
        this(sizeLimit, laxContentType, errorHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.requestsLeft > -1) {
            if (this.requestsLeft == 0) {
                throw new IOException("Number of permitted HTTP requests exceeded.");
            }
            --this.requestsLeft;
        }
        HttpGet m = null;
        try {
            String val;
            Header ce;
            Header csp;
            String val2;
            Header xuac;
            int statusCode;
            URL url = null;
            try {
                url = URL.parse((String)systemId);
            }
            catch (GalimatiasParseException e) {
                IOException ioe = (IOException)new IOException(e.getMessage()).initCause(e);
                SAXParseException spe = new SAXParseException(e.getMessage(), publicId, systemId, -1, -1, ioe);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw ioe;
            }
            String scheme = url.scheme();
            if (!"http".equals(scheme) && !"https".equals(scheme)) {
                String msg = "Unsupported URI scheme: \u201c" + scheme + "\u201d.";
                SAXParseException spe = new SAXParseException(msg, publicId, systemId, -1, -1, new IOException(msg));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            systemId = url.toString();
            try {
                m = new HttpGet(systemId);
            }
            catch (IllegalArgumentException e) {
                SAXParseException spe = new SAXParseException(e.getMessage(), publicId, systemId, -1, -1, (IOException)new IOException(e.getMessage()).initCause(e));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            m.setHeader("User-Agent", this.userAgent);
            m.setHeader("Accept", this.buildAccept());
            m.setHeader("Accept-Encoding", "gzip");
            if (this.request != null && this.request.getAttribute("http://validator.nu/properties/accept-language") != null) {
                m.setHeader("Accept-Language", (String)this.request.getAttribute("http://validator.nu/properties/accept-language"));
            }
            log4j.info(systemId);
            try {
                if (url.port() > 65535) {
                    throw new IOException("Port number must be less than 65536.");
                }
            }
            catch (NumberFormatException e) {
                throw new IOException("Port number must be less than 65536.");
            }
            HttpResponse response = client.execute((HttpUriRequest)m);
            boolean ignoreResponseStatus = false;
            if (this.request != null && this.request.getAttribute("http://validator.nu/properties/ignore-response-status") != null) {
                ignoreResponseStatus = (Boolean)this.request.getAttribute("http://validator.nu/properties/ignore-response-status");
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) != 200 && !ignoreResponseStatus) {
                String msg = "HTTP resource not retrievable. The HTTP status from the remote server was: " + statusCode + ".";
                SAXParseException spe = new SAXParseException(msg, publicId, m.getURI().toString(), -1, -1, new SystemIdIOException(m.getURI().toString(), msg));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw new ResourceNotRetrievableException(String.format("%s: %s", m.getURI().toString(), msg));
            }
            HttpEntity entity = response.getEntity();
            long len = entity.getContentLength();
            if (this.sizeLimit > -1L && len > this.sizeLimit) {
                SAXParseException spe = new SAXParseException("Resource size exceeds limit.", publicId, m.getURI().toString(), -1, -1, new StreamBoundException("Resource size exceeds limit."));
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            Header ct = response.getFirstHeader("Content-Type");
            String contentType = null;
            final String baseUri = m.getURI().toString();
            if (ct != null) {
                contentType = ct.getValue();
            }
            TypedInputSource is = this.contentTypeParser.buildTypedInputSource(baseUri, publicId, contentType);
            Header cl = response.getFirstHeader("Content-Language");
            if (cl != null) {
                is.setLanguage(cl.getValue().trim());
            }
            if ((xuac = response.getFirstHeader("X-UA-Compatible")) != null && !"ie=edge".equalsIgnoreCase(val2 = xuac.getValue().trim())) {
                SAXParseException spe = new SAXParseException("X-UA-Compatible HTTP header must have the value \u201cIE=edge\u201d, was \u201c" + val2 + "\u201d.", publicId, systemId, -1, -1);
                this.errorHandler.error(spe);
            }
            if ((csp = response.getFirstHeader("Content-Security-Policy")) != null) {
                try {
                    ContentSecurityPolicy.THE_INSTANCE.checkValid(csp.getValue().trim());
                }
                catch (DatatypeException e) {
                    SAXParseException spe = new SAXParseException("Content-Security-Policy HTTP header: " + e.getMessage(), publicId, systemId, -1, -1);
                    Html5DatatypeException ex5 = (Html5DatatypeException)e;
                    if (ex5.isWarning()) {
                        this.errorHandler.warning(spe);
                    }
                    this.errorHandler.error(spe);
                }
            }
            final HttpGet meth = m;
            InputStream stream = entity.getContent();
            if (this.sizeLimit > -1L) {
                stream = new BoundedInputStream(stream, this.sizeLimit, baseUri);
            }
            if ((ce = response.getFirstHeader("Content-Encoding")) != null && ("gzip".equalsIgnoreCase(val = ce.getValue().trim()) || "x-gzip".equalsIgnoreCase(val))) {
                stream = new GZIPInputStream(stream);
                if (this.sizeLimit > -1L) {
                    stream = new BoundedInputStream(stream, this.sizeLimit, baseUri);
                }
            }
            is.setByteStream(new ObservableInputStream(stream, new StreamObserver(){
                private final Logger log4j = Logger.getLogger("nu.validator.xml.PrudentEntityResolver.StreamObserver");
                private boolean released = false;

                @Override
                public void closeCalled() {
                    this.log4j.fine("closeCalled");
                    if (!this.released) {
                        this.log4j.fine("closeCalled, not yet released");
                        this.released = true;
                        try {
                            meth.releaseConnection();
                        }
                        catch (Exception e) {
                            this.log4j.log(Level.FINE, "closeCalled, releaseConnection", e);
                        }
                    }
                }

                @Override
                public void exceptionOccurred(Exception ex) throws IOException {
                    if (!this.released) {
                        this.released = true;
                        try {
                            meth.abort();
                        }
                        catch (Exception e) {
                            this.log4j.log(Level.FINE, "exceptionOccurred, abort", e);
                        }
                        finally {
                            try {
                                meth.releaseConnection();
                            }
                            catch (Exception e) {
                                this.log4j.log(Level.FINE, "exceptionOccurred, releaseConnection", e);
                            }
                        }
                    }
                    if (ex instanceof SystemIdIOException) {
                        throw (SystemIdIOException)ex;
                    }
                    if (ex instanceof IOException) {
                        IOException ioe = (IOException)ex;
                        throw new SystemIdIOException(baseUri, ioe.getMessage(), ioe);
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException("API contract violation. Wrong exception type.", ex);
                }

                @Override
                public void finalizerCalled() {
                    if (!this.released) {
                        this.released = true;
                        try {
                            meth.abort();
                        }
                        catch (Exception e) {
                            this.log4j.log(Level.FINE, "finalizerCalled, abort", e);
                        }
                        finally {
                            try {
                                meth.releaseConnection();
                            }
                            catch (Exception e) {
                                this.log4j.log(Level.FINE, "finalizerCalled, releaseConnection", e);
                            }
                        }
                    }
                }
            }));
            return is;
        }
        catch (IOException | RuntimeException | SAXException e) {
            if (m != null) {
                try {
                    m.abort();
                }
                catch (Exception ex) {
                    log4j.log(Level.FINE, "abort", ex);
                }
                finally {
                    try {
                        m.releaseConnection();
                    }
                    catch (Exception ex) {
                        log4j.log(Level.FINE, "releaseConnection", ex);
                    }
                }
            }
            throw e;
        }
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
        this.contentTypeParser.setAllowRnc(allowRnc);
    }

    public boolean isAllowCss() {
        return this.allowCss;
    }

    public void setAllowCss(boolean allowCss) {
        this.allowCss = allowCss;
        this.contentTypeParser.setAllowCss(allowCss);
    }

    public void setAllowHtml(boolean allowHtml) {
        this.allowHtml = allowHtml;
        this.contentTypeParser.setAllowHtml(allowHtml);
    }

    public boolean isAcceptAllKnownXmlTypes() {
        return this.acceptAllKnownXmlTypes;
    }

    public void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.acceptAllKnownXmlTypes = acceptAllKnownXmlTypes;
        this.contentTypeParser.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
    }

    public boolean isAllowGenericXml() {
        return this.allowGenericXml;
    }

    public void setAllowGenericXml(boolean allowGenericXml) {
        this.allowGenericXml = allowGenericXml;
        this.contentTypeParser.setAllowGenericXml(allowGenericXml);
    }

    public boolean isAllowXhtml() {
        return this.allowXhtml;
    }

    public void setAllowXhtml(boolean allowXhtml) {
        this.allowXhtml = allowXhtml;
        this.contentTypeParser.setAllowXhtml(allowXhtml);
    }

    private String buildAccept() {
        return "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    }

    public boolean isAllowHtml() {
        return this.allowHtml;
    }

    public boolean isOnlyHtmlAllowed() {
        return !this.isAllowGenericXml() && !this.isAllowRnc() && !this.isAllowCss() && !this.isAllowXhtml();
    }

    public class ResourceNotRetrievableException
    extends SAXException {
        public ResourceNotRetrievableException(String message) {
            super(message);
        }
    }
}

