/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.impl.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.jakarta.web.beans.impl.model.FieldInjectionPointLogic;

abstract class AbstractObjectProvider<T extends Refreshable>
implements ObjectProvider<T> {
    private AnnotationModelHelper myHelper;
    private String myAnnotationName;

    AbstractObjectProvider(String annotation, AnnotationModelHelper helper) {
        this.myHelper = helper;
        this.myAnnotationName = annotation;
    }

    public List<T> createInitialObjects() throws InterruptedException {
        final LinkedList result = new LinkedList();
        this.getHelper().getAnnotationScanner().findAnnotations(this.getAnnotation(), EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE), new AnnotationHandler(){

            public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                result.add(AbstractObjectProvider.this.createTypeElement(type));
            }
        });
        return result;
    }

    public List<T> createObjects(TypeElement type) {
        if ((type.getKind() == ElementKind.CLASS || type.getKind() == ElementKind.INTERFACE) && this.getHelper().hasAnnotation(type.getAnnotationMirrors(), this.getAnnotation())) {
            return Collections.singletonList(this.createTypeElement(type));
        }
        return Collections.emptyList();
    }

    public boolean modifyObjects(TypeElement type, List<T> objects) {
        assert (objects.size() == 1);
        Refreshable object = (Refreshable)objects.get(0);
        assert (object != null);
        if (!object.refresh(type)) {
            objects.remove(0);
            return true;
        }
        return false;
    }

    protected abstract T createTypeElement(TypeElement var1);

    public static List<Element> getAnnotatedMembers(String annotationName, AnnotationModelHelper helper) {
        final LinkedList<Element> result = new LinkedList<Element>();
        try {
            helper.getAnnotationScanner().findAnnotations(annotationName, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    result.add(element);
                }
            });
        }
        catch (InterruptedException e) {
            FieldInjectionPointLogic.LOGGER.warning("Finding annotation " + annotationName + " was interrupted");
        }
        return result;
    }

    protected AnnotationModelHelper getHelper() {
        return this.myHelper;
    }

    protected String getAnnotation() {
        return this.myAnnotationName;
    }

    public static List<Element> getNamedMembers(AnnotationModelHelper helper) {
        List<Element> namedMembers = AbstractObjectProvider.getAnnotatedMembers("jakarta.inject.Named", helper);
        return namedMembers;
    }

    static interface Refreshable {
        public boolean refresh(TypeElement var1);
    }
}

