/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.adm.KnowledgeBaseItem;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class KnowledgeBaseNode
extends OCINode {
    private static final String ICON = "org/netbeans/modules/cloud/oracle/resources/knowledge_base.svg";

    public KnowledgeBaseNode(OCIItem item) {
        super(item, Children.LEAF);
        this.setIconBaseWithExtension(ICON);
    }

    public static NodeProvider<KnowledgeBaseItem> createNode() {
        return KnowledgeBaseNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, KnowledgeBaseItem> listKnowledgeBases() {
        return (compartment, session) -> {
            try (ApplicationDependencyManagementClient client = session.newClient(ApplicationDependencyManagementClient.class);){
                ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.builder().compartmentId(compartment.getKey().getValue()).lifecycleState(KnowledgeBase.LifecycleState.Active).build();
                ListKnowledgeBasesResponse response = client.listKnowledgeBases(request);
                List projects = response.getKnowledgeBaseCollection().getItems();
                List list = projects.stream().map(p -> new KnowledgeBaseItem(OCID.of(p.getId(), "KnowledgeBase"), p.getCompartmentId(), p.getDisplayName(), p.getTimeUpdated())).collect(Collectors.toList());
                return list;
            }
        };
    }
}

