/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.actions.AddADBAction;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.DependencyUtils;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.DatabaseConnectionStep;
import org.netbeans.modules.cloud.oracle.steps.ItemTypeStep;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.cloud.oracle.steps.SuggestedStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.util.lookup.Lookups;

public class AddNewAssetCommand
implements CommandProvider {
    private static final String COMMAND_ADD_NEW_ASSET = "nbls.cloud.assets.add.new";
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.add.new"));
    private static final Map<String, String[]> DEP_MAP = new HashMap(){
        {
            this.put("Databases", new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-atp"});
            this.put("Bucket", new String[]{"io.micronaut.objectstorage", "micronaut-object-storage-oracle-cloud"});
            this.put("Vault", new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-vault"});
        }
    };

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Steps.NextStepProvider nsProvider = Steps.NextStepProvider.builder().stepForClass(ItemTypeStep.class, s -> {
            if ("Databases".equals(s.getValue())) {
                return new DatabaseConnectionStep();
            }
            return new TenancyStep();
        }).stepForClass(TenancyStep.class, s -> new CompartmentStep()).stepForClass(CompartmentStep.class, s -> new SuggestedStep(null)).stepForClass(SuggestedStep.class, s -> new ProjectStep()).build();
        Steps.getDefault().executeMultistep(new ItemTypeStep(), Lookups.fixed((Object[])new Object[]{nsProvider})).thenAccept(values -> {
            CompletableFuture<OCIItem> item;
            Project project = (Project)values.getValueForStep(ProjectStep.class);
            if ("Databases".equals(values.getValueForStep(ItemTypeStep.class))) {
                DatabaseItem i2 = (DatabaseItem)values.getValueForStep(DatabaseConnectionStep.class);
                item = i2 == null ? new AddADBAction().addADB() : CompletableFuture.completedFuture(i2);
            } else {
                OCIItem i3 = (OCIItem)values.getValueForStep(SuggestedStep.class);
                if (i3 == null) {
                    future.cancel(true);
                    return;
                }
                item = CompletableFuture.completedFuture(i3);
            }
            item.thenAccept(i -> {
                CloudAssets.getDefault().addItem((OCIItem)i);
                String[] art = DEP_MAP.get(i.getKey().getPath());
                try {
                    DependencyUtils.addDependency(project, art[0], art[1]);
                    future.complete(null);
                }
                catch (IllegalStateException e) {
                    future.completeExceptionally(e);
                }
            });
        });
        return future;
    }
}

