/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import com.oracle.bmc.model.BmcException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.bucket.BucketNode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.compute.ClusterNode;
import org.netbeans.modules.cloud.oracle.compute.ComputeInstanceNode;
import org.netbeans.modules.cloud.oracle.database.DatabaseNode;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryNode;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.ItemTypeStep;
import org.netbeans.modules.cloud.oracle.vault.VaultNode;
import org.openide.NotifyDescriptor;

public class SuggestedStep
extends AbstractStep<OCIItem> {
    private static final Logger LOG = Logger.getLogger(SuggestedStep.class.getName());
    private final Map<String, OCIItem> items = new HashMap<String, OCIItem>();
    private OCIItem selected;
    private String suggestedType;

    public SuggestedStep(String suggestedType) {
        this.suggestedType = suggestedType;
    }

    @Override
    public void prepare(ProgressHandle h, Steps.Values values) {
        h.progress(Bundle.CollectingItems_Text());
        if (this.suggestedType == null) {
            this.suggestedType = (String)values.getValueForStep(ItemTypeStep.class);
        }
        CompartmentItem compartment = (CompartmentItem)values.getValueForStep(CompartmentStep.class);
        SuggestedStep.getItemsByPath(compartment, this.suggestedType).forEach(db -> this.items.put(db.getName(), (OCIItem)db));
    }

    private String getSuggestedItemName() {
        switch (this.suggestedType) {
            case "Databases": {
                return Bundle.Databases();
            }
            case "Vault": {
                return Bundle.Vault();
            }
            case "Bucket": {
                return Bundle.Bucket();
            }
            case "Cluster": {
                return Bundle.Cluster();
            }
            case "ComputeInstance": {
                return Bundle.Compute();
            }
            case "ContainerRepository": {
                return Bundle.ContainerRepository();
            }
        }
        throw new MissingResourceException("Missing OCI type", null, this.suggestedType);
    }

    @Override
    public NotifyDescriptor createInput() {
        return Steps.createQuickPick(this.items, Bundle.SelectItem(this.getSuggestedItemName()));
    }

    @Override
    public void setValue(String selected) {
        this.selected = this.items.get(selected);
    }

    @Override
    public OCIItem getValue() {
        if (this.onlyOneChoice()) {
            this.selected = this.items.values().iterator().next();
        }
        return this.selected;
    }

    @Override
    public boolean onlyOneChoice() {
        return false;
    }

    protected static List<? extends OCIItem> getItemsByPath(CompartmentItem parent, String path) {
        HashMap items = new HashMap();
        try {
            switch (path) {
                case "Databases": {
                    return DatabaseNode.getDatabases().apply(parent);
                }
                case "Vault": {
                    return VaultNode.getVaults().apply(parent);
                }
                case "Bucket": {
                    return BucketNode.getBuckets().apply(parent);
                }
                case "Cluster": {
                    return ClusterNode.getClusters().apply(parent);
                }
                case "ComputeInstance": {
                    return ComputeInstanceNode.getComputeInstances().apply(parent);
                }
                case "ContainerRepository": {
                    return ContainerRepositoryNode.getContainerRepositories().apply(parent);
                }
            }
            return Collections.emptyList();
        }
        catch (BmcException e) {
            LOG.log(Level.SEVERE, "Unable to load vault list", e);
            return Collections.emptyList();
        }
    }
}

