/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.HeaderComponent;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableActions;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableHovers;
import org.netbeans.lib.profiler.ui.swing.renderer.Movable;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public class ProfilerTable
extends JTable {
    public static final String PROP_NO_HOVER = "ProfilerTableHover_NoHover";
    private ScrollableRenderer _renderer;
    private boolean isCustomRendering;
    private int mainColumn = 0;
    private boolean shadeUnfocusedSelection = false;
    private boolean selectionOnMiddlePress = false;
    boolean internal;
    private Object selection;
    private int fixedSelectionColumn = -1;
    private ListSelectionListener selectionListener;
    private boolean columnWidthsValid;
    private Set<Integer> scrollableColumns;
    private final boolean hideableColums;
    private boolean scrolling;
    private Action defaultAction;
    private long pressedWhen;
    private Point pressedPoint;
    private boolean providesPopupMenu;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    }

    public ProfilerTable(TableModel model, boolean sortable, boolean hideableColums, int[] scrollableColumns) {
        super(model);
        this.hideableColums = hideableColums;
        this.setupModels(sortable);
        this.setupAppearance();
        if (scrollableColumns != null && scrollableColumns.length > 0) {
            this.initScrollableColumns(scrollableColumns);
        }
        this.tweak();
    }

    protected void setupModels(boolean sortable) {
        this.setAutoCreateRowSorter(false);
        if (sortable) {
            this.setRowSorter(this.createRowSorter());
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            ProfilerColumnModel cm = this._getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                this.addColumn(cm.createTableColumn(i));
            }
        }
    }

    private void tweak() {
        for (Tweaker tweaker : Lookup.getDefault().lookupAll(Tweaker.class)) {
            tweaker.tweak(this);
        }
    }

    protected void setupAppearance() {
        this.setAutoResizeMode(1);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
        this.setRowMargin(0);
        this.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        if (UIUtils.isNimbusLookAndFeel() && Boolean.TRUE.equals(UIManager.getBoolean("nb.dark.theme"))) {
            this.setForeground(UIManager.getColor("text"));
        }
        ProfilerTableActions.install(this);
        ProfilerTableHovers.install(this);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerTable.this.performDefaultAction(e);
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ProfilerTable.this.focusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ProfilerTable.this.focusLost();
            }
        });
    }

    @Override
    public Color getBackground() {
        return this.isEnabled() ? super.getBackground() : UIManager.getColor("TextField.inactiveBackground");
    }

    private void focusGained() {
        this.repaint();
    }

    private void focusLost() {
        this.repaint();
    }

    public void setDefaultRenderer(Class<?> columnClass, ProfilerRenderer renderer) {
        super.setDefaultRenderer(columnClass, ProfilerTable.createTableCellRenderer(renderer));
    }

    public void setColumnRenderer(int column, ProfilerRenderer renderer) {
        int _column = this.convertColumnIndexToModel(column);
        TableColumn tColumn = this.getColumnModel().getColumn(_column);
        tColumn.setCellRenderer(ProfilerTable.createTableCellRenderer(renderer));
    }

    public static TableCellRenderer createTableCellRenderer(ProfilerRenderer renderer) {
        return new ProfilerRendererWrapper(renderer);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean isSelected;
        Component c = super.prepareRenderer(renderer, row, column);
        boolean cEnabled = c.isEnabled();
        if (!cEnabled) {
            c.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        }
        if ((isSelected = this.isCellSelected(row, column)) && this.isEnabled()) {
            boolean focusOwner;
            boolean bl = focusOwner = !this.shadeUnfocusedSelection || super.isFocusOwner();
            if (cEnabled) {
                c.setForeground(focusOwner ? this.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            }
            c.setBackground(focusOwner ? this.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if (!this.isEnabled()) {
            if (cEnabled) {
                c.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            }
            c.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else {
            if (cEnabled) {
                c.setForeground(this.getForeground());
            }
            c.setBackground(this.background(row, column));
        }
        c.move(0, 0);
        int col = this.convertColumnIndexToModel(column);
        if (!this.isCustomRendering() && this.isScrollableColumn(col)) {
            int prefWidth = this.getColumnPreferredWidth(col);
            return this.getScrollableRenderer(c, col, prefWidth);
        }
        return c;
    }

    private Color background(int row, int column) {
        Color background;
        Color color = background = (row & 1) == 0 ? this.getBackground() : UIUtils.getDarker(this.getBackground());
        if (this.convertColumnIndexToModel(column) == this.getSortColumn() && SortOrder.UNSORTED != this._getRowSorter().getSortOrder()) {
            int r = background.getRed() - 4;
            int g = background.getGreen() - 4;
            int b = background.getBlue() + 6;
            background = UIUtils.getSafeColor(r, g, b);
        }
        return background;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component c = super.prepareEditor(editor, row, column);
        c.setForeground(this.getSelectionForeground());
        c.setBackground(this.getSelectionBackground());
        return c;
    }

    private ScrollableRenderer getScrollableRenderer(Component renderer, int column, int width) {
        if (this._renderer == null) {
            this._renderer = new ScrollableRenderer();
        }
        this._renderer.setRenderer(renderer, this.getColumnOffset(column), width);
        return this._renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getRenderer(TableCellRenderer renderer, int row, int column, boolean sized) {
        this.isCustomRendering = true;
        try {
            Component comp = this.prepareRenderer(renderer, row, column);
            if (sized) {
                comp.setSize(comp.getPreferredSize().width, this.getRowHeight());
                if (!ProfilerTable.isLeadingAlign(comp)) {
                    TableColumnModel m = this.getColumnModel();
                    int x = -comp.getWidth();
                    int c = m.getColumn(column).getWidth();
                    int _column = this.convertColumnIndexToModel(column);
                    x = this.isScrollableColumn(_column) ? (x += Math.max(c, this.getColumnPreferredWidth(_column))) : (x += c);
                    comp.move(x - m.getColumnMargin(), 0);
                }
            }
            Component component = comp;
            return component;
        }
        finally {
            this.isCustomRendering = false;
        }
    }

    @Override
    public boolean isFocusOwner() {
        return !this.isCustomRendering() && super.isFocusOwner();
    }

    public void setVisibleRows(int rows) {
        Dimension size = super.getPreferredScrollableViewportSize();
        size.height = rows * this.getRowHeight();
        this.setPreferredScrollableViewportSize(size);
    }

    final boolean isCustomRendering() {
        return this.isCustomRendering;
    }

    public String getStringValue(int row, int column) {
        Object value = this.getValueAt(row, column);
        TableCellRenderer renderer = this.getCellRenderer(row, column);
        if (renderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)renderer)).setValue(value, this.convertRowIndexToModel(row));
        } else {
            renderer.getTableCellRendererComponent(this, value, false, false, row, column);
        }
        return renderer.toString();
    }

    public String getModelStringValue(int row, int column) {
        int c = this.convertColumnIndexToView(column);
        Object value = this.getModel().getValueAt(row, column);
        TableCellRenderer renderer = this.getCellRenderer(row, c);
        if (renderer instanceof ProfilerRenderer) {
            ((ProfilerRenderer)((Object)renderer)).setValue(value, row);
        } else {
            renderer.getTableCellRendererComponent(this, value, false, false, this.convertRowIndexToView(row), c);
        }
        return renderer.toString();
    }

    public final void setMainColumn(int column) {
        this.mainColumn = column;
    }

    public final int getMainColumn() {
        return this.mainColumn;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        ListSelectionModel oldModel = this.getSelectionModel();
        if (oldModel != null && this.selectionListener != null) {
            oldModel.removeListSelectionListener(this.selectionListener);
        }
        super.setSelectionModel(newModel);
        if (newModel != null) {
            if (this.selectionListener == null) {
                this.selectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!ProfilerTable.this.internal) {
                            ProfilerTable.this.saveSelection();
                        }
                    }
                };
            }
            newModel.addListSelectionListener(this.selectionListener);
        }
    }

    protected void saveSelection() {
        int sel = this.getSelectionModel().getSelectionMode();
        this.selection = sel == 0 ? this.getSelectedValue(this.mainColumn) : this.getSelectedValues(this.mainColumn).toArray();
    }

    protected void restoreSelection() {
        try {
            this.selection = !(this.selection instanceof Object[]) ? this.selectValue(this.selection, this.mainColumn, false) : this.selectValues((Object[])this.selection, this.mainColumn, false);
        }
        catch (Exception e) {
            System.err.println(">>> Exception in ProfilerTable.restoreSelection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectRow(int row, boolean scrollToVisible) {
        this.internal = true;
        try {
            this.setRowSelectionInterval(row, row);
            this.saveSelection();
        }
        catch (Exception e) {
            System.err.println(">>> Exception in ProfilerTable.selectRow: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.internal = false;
        }
        if (scrollToVisible) {
            this.scrollRectToVisible(this.getCellRect(row, this.getSelectedColumn(), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectColumn(int column, boolean scrollToVisible) {
        this.internal = true;
        try {
            this.setColumnSelectionInterval(column, column);
        }
        catch (Exception e) {
            System.err.println(">>> Exception in ProfilerTable.selectColumn: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.internal = false;
        }
        if (scrollToVisible) {
            this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), column, true));
        }
    }

    public void setFixedColumnSelection(final int column) {
        if (this.fixedSelectionColumn == column) {
            return;
        }
        if (column == -1) {
            this.getColumnModel().setSelectionModel(new DefaultListSelectionModel());
        } else {
            this.getColumnModel().setSelectionModel(new DefaultListSelectionModel(){

                @Override
                public void setSelectionInterval(int index0, int index1) {
                    int index = ProfilerTable.this.convertColumnIndexToView(column);
                    super.setSelectionInterval(index, index);
                }
            });
        }
        this.fixedSelectionColumn = column;
    }

    public Object selectValue(Object value, int column, boolean scrollToVisible) {
        if (value == null) {
            return null;
        }
        int _column = this.convertColumnIndexToView(column);
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object _value = this.getValueAt(row, _column);
            if (!value.equals(_value)) continue;
            this.selectRow(row, scrollToVisible);
            return _value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] selectValues(Object[] values, int column, boolean scrollToVisible) {
        if (values == null || values.length == 0) {
            return null;
        }
        HashSet<Object> toSelect = new HashSet<Object>(Arrays.asList(values));
        ArrayList<Object> selected = new ArrayList<Object>(toSelect.size());
        this.internal = true;
        try {
            int _column = this.convertColumnIndexToView(column);
            for (int row = 0; row < this.getRowCount(); ++row) {
                Object _value = this.getValueAt(row, _column);
                if (!toSelect.remove(_value)) continue;
                if (selected.isEmpty()) {
                    this.setRowSelectionInterval(row, row);
                    if (scrollToVisible) {
                        this.scrollRectToVisible(this.getCellRect(row, _column, true));
                    }
                } else {
                    this.addRowSelectionInterval(row, row);
                }
                selected.add(_value);
                if (!toSelect.isEmpty()) continue;
                break;
            }
        }
        finally {
            this.internal = false;
        }
        return selected.isEmpty() ? null : selected.toArray();
    }

    public Object getSelectedValue(int column) {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        if (row >= this.getModel().getRowCount()) {
            return null;
        }
        return this.getValueAt(row, this.convertColumnIndexToView(column));
    }

    public List getSelectedValues(int column) {
        ArrayList<Object> values = new ArrayList<Object>();
        int col = this.convertColumnIndexToView(column);
        int rowCount = this.getModel().getRowCount();
        for (int row : this.getSelectedRows()) {
            if (row >= rowCount) continue;
            values.add(this.getValueAt(row, col));
        }
        return values;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.internal = true;
        try {
            super.tableChanged(e);
        }
        finally {
            this.internal = false;
        }
        this.restoreSelection();
    }

    public final void setShadeUnfocusedSelection(boolean shade) {
        this.shadeUnfocusedSelection = shade;
    }

    public final boolean shadesUnfocusedSelection() {
        return this.shadeUnfocusedSelection;
    }

    public final void setSelectionOnMiddlePress(boolean select) {
        this.selectionOnMiddlePress = select;
    }

    public final boolean isSelectionOnMiddlePress() {
        return this.selectionOnMiddlePress;
    }

    int getNextRow(int row) {
        return ++row == this.getRowCount() ? 0 : row;
    }

    int getPreviousRow(int row) {
        return --row == -1 ? this.getRowCount() - 1 : row;
    }

    ProfilerColumnModel _getColumnModel() {
        return (ProfilerColumnModel)this.getColumnModel();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ProfilerColumnModel();
    }

    public void setFitWidthColumn(int column) {
        this._getColumnModel().setFitWidthColumn(column);
    }

    public void setDefaultColumnWidth(int width) {
        this._getColumnModel().setDefaultColumnWidth(width);
    }

    public void setDefaultColumnWidth(int column, int width) {
        this._getColumnModel().setDefaultColumnWidth(column, width);
    }

    public void setColumnToolTips(String[] toolTips) {
        this._getColumnModel().setColumnToolTips(toolTips);
    }

    public void setColumnVisibility(int column, boolean visible) {
        ProfilerColumnModel cModel = this._getColumnModel();
        TableColumn col = cModel.getColumn(this.convertColumnIndexToView(column));
        cModel.setColumnVisibility(col, visible, this);
    }

    public boolean isColumnVisible(int column) {
        int _column = this.convertColumnIndexToView(column);
        return this._getColumnModel().isColumnVisible(_column);
    }

    public void setColumnOffset(int column, int offset) {
        if (this._getColumnModel().setColumnOffset(column, offset)) {
            column = this.convertColumnIndexToView(column);
            Rectangle rect = this.getCellRect(0, column, true);
            this.repaint(rect.x, 0, rect.width, this.getHeight());
        }
    }

    public Set<Integer> getScrollableColumns() {
        return this.scrollableColumns;
    }

    public boolean isScrollableColumn(int column) {
        return this.scrollableColumns != null && this.scrollableColumns.contains(column);
    }

    public int getColumnOffset(int column) {
        return this._getColumnModel().getColumnOffset(column);
    }

    protected void updateColumnsPreferredWidth() {
        if (this.scrolling || this.scrollableColumns == null) {
            return;
        }
        ProfilerColumnModel cModel = this._getColumnModel();
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            for (int column : this.scrollableColumns) {
                cModel.setColumnPreferredWidth(column, 0);
            }
            return;
        }
        Rectangle visible = this.getVisibleRect();
        if (visible.isEmpty()) {
            return;
        }
        Point visibleP = visible.getLocation();
        int first = this.rowAtPoint(visibleP);
        visibleP.translate(0, visible.height - 1);
        int last = this.rowAtPoint(visibleP);
        if (last == -1) {
            last = rowCount - 1;
        }
        for (int column : this.scrollableColumns) {
            int _column = this.convertColumnIndexToView(column);
            int width = this.computeColumnPreferredWidth(column, _column, first, last);
            cModel.setColumnPreferredWidth(column, width);
        }
        this.columnWidthsValid = true;
    }

    public void updateColumnPreferredWidth(int column) {
        Rectangle visible = this.getVisibleRect();
        if (visible.isEmpty()) {
            return;
        }
        Point visibleP = visible.getLocation();
        int first = this.rowAtPoint(visible.getLocation());
        visibleP.translate(0, visible.height - 1);
        int last = this.rowAtPoint(visibleP);
        int _column = this.convertColumnIndexToView(column);
        int width = this.computeColumnPreferredWidth(column, _column, first, last);
        this._getColumnModel().setColumnPreferredWidth(column, width);
    }

    protected int computeColumnPreferredWidth(int modelIndex, int viewIndex, int firstRow, int lastRow) {
        int width = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            TableCellRenderer renderer = this.getCellRenderer(row, viewIndex);
            Component component = this.getRenderer(renderer, row, viewIndex, false);
            width = Math.max(component.getPreferredSize().width, width);
        }
        return width;
    }

    public int getColumnPreferredWidth(int column) {
        if (!this.columnWidthsValid) {
            this.updateColumnsPreferredWidth();
        }
        return this._getColumnModel().getColumnPreferredWidth(column);
    }

    private void initScrollableColumns(int[] columns) {
        this.scrollableColumns = new HashSet<Integer>(columns.length);
        for (int column : columns) {
            this.scrollableColumns.add(column);
        }
        this.columnWidthsValid = false;
        if (this.isSortable()) {
            this.getRowSorter().addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    if (RowSorterEvent.Type.SORTED == e.getType()) {
                        ProfilerTable.this.updateColumnsPreferredWidth();
                    }
                }
            });
        } else {
            this.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ProfilerTable.this.updateColumnsPreferredWidth();
                }
            });
        }
    }

    boolean isLeadingAlign(int column) {
        if (this.getRowCount() == 0) {
            return true;
        }
        int _column = this.convertColumnIndexToView(column);
        TableCellRenderer r = this.getCellRenderer(0, _column);
        return ProfilerTable.isLeadingAlign(this.getRenderer(r, 0, _column, false));
    }

    static boolean isLeadingAlign(Component component) {
        int alignment = component instanceof ProfilerRenderer ? ((ProfilerRenderer)((Object)component)).getHorizontalAlignment() : (component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 10);
        return alignment == 10 || alignment == 2 || alignment == 0;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane != null) {
            HeaderComponent corner;
            boolean hideable = this.hideableColums && !UIUtils.isAquaLookAndFeel();
            ActionListener chooser = !hideable ? null : new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilerTable.this.chooseColumns((Component)e.getSource(), null);
                }
            };
            HeaderComponent headerComponent = corner = !hideable ? new HeaderComponent(chooser) : new HeaderComponent(chooser){
                private final int offsetX;
                private final Icon icon;
                {
                    this.offsetX = UIUtils.isWindowsClassicLookAndFeel() ? 0 : -1;
                    this.icon = Icons.getIcon((String)"GeneralIcons.PopupArrow");
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    int x = (this.getWidth() - this.icon.getIconWidth()) / 2 + this.offsetX;
                    int y = (this.getHeight() - this.icon.getIconHeight()) / 2;
                    this.icon.paintIcon(this, g, x, y);
                }
            };
            if (hideable) {
                corner.setToolTipText(ProfilerTable.BUNDLE().getString("ProfilerTable_ShowHideColumns"));
            }
            scrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
            if (this.scrollableColumns != null && !this.scrollableColumns.isEmpty()) {
                scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent e) {
                        ProfilerTable.this.scrolling = e.getValueIsAdjusting();
                        ProfilerTable.this.updateColumnsPreferredWidth();
                    }
                });
            }
        }
    }

    private JScrollPane getEnclosingScrollPane() {
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (!(parent instanceof JViewport)) {
            return null;
        }
        Container scroll = ((JViewport)parent).getParent();
        return scroll instanceof JScrollPane ? (JScrollPane)scroll : null;
    }

    private void chooseColumns(Component source, Point p) {
        final ProfilerColumnModel cModel = this._getColumnModel();
        ArrayList<TableColumn> columns = Collections.list(cModel.getColumns());
        JPopupMenu popup = new JPopupMenu();
        for (final TableColumn c : columns) {
            popup.add(new JCheckBoxMenuItem(c.getHeaderValue().toString(), c.getWidth() > 0){
                {
                    super(arg0, arg1);
                    this.setEnabled(c.getModelIndex() != ProfilerTable.this.mainColumn);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    cModel.setColumnVisibility(c, this.isSelected(), ProfilerTable.this);
                }
            });
        }
        if (p == null) {
            p = new Point(source.getSize().width - popup.getPreferredSize().width - 1, source.getHeight() - 1);
        }
        popup.show(source, p.x, p.y);
    }

    @Override
    public void doLayout() {
        TableColumn res;
        ProfilerColumnModel cModel = this._getColumnModel();
        JTableHeader header = this.getTableHeader();
        TableColumn tableColumn = res = header == null ? null : header.getResizingColumn();
        if (res != null) {
            int delta = this.getWidth() - cModel.getTotalColumnWidth();
            TableColumn next = cModel.getNextVisibleColumn(res);
            if (res == next) {
                res.setWidth(res.getWidth() + delta);
            } else {
                next.setWidth(next.getWidth() + delta);
            }
        } else {
            int toResizeIndex = cModel.getFitWidthColumn();
            if (toResizeIndex == -1) {
                super.doLayout();
            } else {
                Enumeration<TableColumn> columns = cModel.getColumns();
                TableColumn toResizeColumn = null;
                int columnsWidth = 0;
                while (columns.hasMoreElements()) {
                    TableColumn column = columns.nextElement();
                    if (column.getModelIndex() == toResizeIndex) {
                        if (!cModel.isColumnVisible(column)) {
                            super.doLayout();
                            return;
                        }
                        toResizeColumn = column;
                        continue;
                    }
                    columnsWidth += column.getWidth();
                }
                if (toResizeColumn != null) {
                    toResizeColumn.setWidth(this.getWidth() - columnsWidth);
                }
                this.layout();
            }
        }
    }

    boolean isSortable() {
        return this.getRowSorter() != null;
    }

    ProfilerRowSorter _getRowSorter() {
        return (ProfilerRowSorter)this.getRowSorter();
    }

    protected TableRowSorter createRowSorter() {
        ProfilerRowSorter s = new ProfilerRowSorter(this.getModel());
        s.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                return ProfilerTable.this.getModelStringValue(row, column);
            }
        });
        s.setDefaultSortOrder(SortOrder.DESCENDING);
        s.setSortColumn(0);
        return s;
    }

    public void disableColumnSorting(int column) {
        ProfilerRowSorter sorter = this._getRowSorter();
        if (sorter == null) {
            return;
        }
        int _column = this.convertColumnIndexToView(column);
        sorter.setSortable(_column, false);
    }

    public void setSortColumn(int column) {
        if (this.isSortable()) {
            this._getRowSorter().setSortColumn(column);
        }
    }

    public int getSortColumn() {
        return this.isSortable() ? this._getRowSorter().getSortColumn() : -1;
    }

    public void setSecondarySortColumn(int column) {
        if (this.isSortable()) {
            this._getRowSorter().setSecondarySortColumn(column);
        }
    }

    public void setDefaultSortOrder(SortOrder sortOrder) {
        if (this.isSortable()) {
            this._getRowSorter().setDefaultSortOrder(sortOrder);
        }
    }

    public void setDefaultSortOrder(int column, SortOrder sortOrder) {
        if (this.isSortable()) {
            this._getRowSorter().setDefaultSortOrder(column, sortOrder);
        }
    }

    public void setAllowsThreeStateColumns(boolean threeStateColumns) {
        this._getRowSorter().setAllowsThreeStateColumns(threeStateColumns);
    }

    public boolean allowsThreeStateColumns() {
        return this._getRowSorter().allowsThreeStateColumns();
    }

    public void setFiltersMode(boolean mode) {
        this._getRowSorter().setFiltersMode(mode);
    }

    public boolean getFiltersMode() {
        return this._getRowSorter().getFiltersMode();
    }

    public void addRowFilter(RowFilter filter) {
        this._getRowSorter().addRowFilter(filter);
    }

    public void removeRowFilter(RowFilter filter) {
        this._getRowSorter().removeRowFilter(filter);
    }

    public void setRowFilter(RowFilter filter) {
        this._getRowSorter().setRowFilter(filter);
    }

    public RowFilter getRowFilter() {
        return this._getRowSorter().getRowFilter();
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
    }

    public void performDefaultAction(ActionEvent e) {
        if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(null);
        }
    }

    public final void providePopupMenu(boolean provide) {
        this.providesPopupMenu = provide;
    }

    public final boolean providesPopupMenu() {
        return this.providesPopupMenu;
    }

    protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
    }

    public final JMenuItem createCopyMenuItem() {
        final int row = this.getSelectedRow();
        JMenu copyItem = new JMenu(ProfilerTable.BUNDLE().getString("ProfilerTable_CopyMenu"));
        JMenuItem copyRowItem = new JMenuItem(ProfilerTable.BUNDLE().getString("ProfilerTable_CopyRowItem")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                StringBuilder val = new StringBuilder();
                ArrayList<TableColumn> columns = Collections.list(ProfilerTable.this._getColumnModel().getColumns());
                for (int col = 0; col < columns.size(); ++col) {
                    if (((TableColumn)columns.get(col)).getWidth() <= 0) continue;
                    val.append("\t").append(ProfilerTable.this.getStringValue(row, col));
                }
                StringSelection s = new StringSelection(val.toString().trim());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            }
        };
        copyItem.add(copyRowItem);
        copyItem.addSeparator();
        String genericItemName = ProfilerTable.BUNDLE().getString("ProfilerTable_CopyColumnItem");
        ArrayList<TableColumn> columns = Collections.list(this._getColumnModel().getColumns());
        for (int col = 0; col < columns.size(); ++col) {
            final int _col = col;
            TableColumn column = (TableColumn)columns.get(col);
            if (column.getWidth() <= 0) continue;
            String columnName = column.getHeaderValue().toString();
            if (columnName.toLowerCase().startsWith("<html>")) {
                columnName = columnName.replaceAll("<[^>]*>", "");
            }
            copyItem.add(new JMenuItem(MessageFormat.format(genericItemName, columnName)){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    StringSelection s = new StringSelection(ProfilerTable.this.getStringValue(row, _col));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
                }
            });
        }
        return copyItem;
    }

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    public Object getValueForRow(int row) {
        if (row == -1) {
            return null;
        }
        if (row >= this.getModel().getRowCount()) {
            return null;
        }
        return this.getValueAt(row, this.convertColumnIndexToView(this.mainColumn));
    }

    public Object getUserValueForRow(int row) {
        return this.getValueForRow(row);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        ListSelectionModel sel;
        MouseEvent generatedClick = null;
        if (e.getID() == 501) {
            this.pressedWhen = e.getWhen();
            this.pressedPoint = null;
        } else if (e.getID() == 502) {
            if (e.getWhen() - this.pressedWhen == 1L) {
                this.pressedPoint = e.getPoint();
                super.processMouseEvent(e);
                return;
            }
            if (e.getPoint().equals(this.pressedPoint)) {
                this.pressedPoint = null;
                generatedClick = new MouseEvent(e.getComponent(), 500, e.getWhen() + 1L, e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            }
            this.pressedWhen = 0L;
        }
        boolean popupEvent = this.providesPopupMenu && SwingUtilities.isRightMouseButton(e);
        boolean clickEvent = e.getID() == 500 && SwingUtilities.isLeftMouseButton(e);
        int row = this.rowAtPoint(e.getPoint());
        if (clickEvent && row != -1 && e.getClickCount() > 1 && this.isCellEditable(row, this.columnAtPoint(e.getPoint()))) {
            e = ProfilerTable.clearClicks(e);
        }
        if (e.getID() == 501 && row != -1 && (popupEvent || this.selectionOnMiddlePress && SwingUtilities.isMiddleMouseButton(e)) && ((sel = this.getSelectionModel()).getSelectionMode() == 0 || !sel.isSelectedIndex(row))) {
            this.selectRow(row, true);
            this.requestFocusInWindow();
        }
        super.processMouseEvent(e);
        if (popupEvent && e.getID() == 500 && row != -1) {
            sel = this.getSelectionModel();
            if (sel.getSelectionMode() == 0 || !sel.isSelectedIndex(row)) {
                this.selectRow(row, true);
            }
            final MouseEvent me = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerTable.this.showPopupMenu(me);
                }
            });
        }
        if (!e.isConsumed() && clickEvent && e.getClickCount() == 2) {
            this.performDefaultAction(new ActionEvent(e.getSource(), e.getID(), "default action", e.getWhen(), e.getModifiers()));
        }
        if (generatedClick != null) {
            this.processMouseEvent(generatedClick);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 525 || code == 121 && e.getModifiers() == 1) {
            e.consume();
            this.showPopupMenu(null);
        }
        super.processKeyEvent(e);
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean visible) {
                if (visible) {
                    ProfilerTable.this.popupShowing();
                }
                super.setVisible(visible);
                if (!visible) {
                    ProfilerTable.this.popupHidden();
                }
            }
        };
        int row = this.getSelectedRow();
        Object value = this.getValueForRow(row);
        Object userValue = this.getUserValueForRow(row);
        this.populatePopup(popup, value, userValue);
        if (popup.getComponentCount() > 0) {
            if (e == null) {
                boolean b = row == -1;
                int c = b ? -1 : this.convertColumnIndexToView(this.mainColumn);
                Rectangle t = b ? this.getVisibleRect() : this.getCellRect(row, c, false);
                Dimension s = popup.getPreferredSize();
                int x = t.x + (t.width - s.width) / 2;
                int y = t.y + (b ? (t.height - s.height) / 2 : this.getRowHeight() - 4);
                popup.show(this, Math.max(x, 0), Math.max(y, 0));
            } else {
                popup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void loadColumns(Properties properties) {
        this._getColumnModel().loadFromStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().loadFromStorage(properties, this);
        }
    }

    public void saveColumns(Properties properties) {
        this._getColumnModel().saveToStorage(properties, this);
        if (this.isSortable()) {
            this._getRowSorter().saveToStorage(properties, this);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.columnAtPoint(e.getPoint());
                if (index == -1) {
                    return null;
                }
                ProfilerColumnModel cModel = ProfilerTable.this._getColumnModel();
                TableColumn column = cModel.getColumn(index);
                String toolTip = cModel.getColumnToolTip(column.getModelIndex());
                return toolTip;
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (ProfilerTable.this.hideableColums && UIUtils.isAquaLookAndFeel() && e.isPopupTrigger()) {
                    ProfilerTable.this.chooseColumns((Component)e.getSource(), e.getPoint());
                }
                super.processMouseEvent(e.getClickCount() > 1 ? ProfilerTable.clearClicks(e) : e);
            }

            @Override
            public void setResizingColumn(TableColumn aColumn) {
                ProfilerTable.this._getColumnModel().setResizingColumn(aColumn);
                super.setResizingColumn(aColumn);
            }
        };
    }

    protected static MouseEvent clearClicks(MouseEvent e) {
        return new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), 1, e.isPopupTrigger(), e.getButton());
    }

    public static interface Tweaker {
        public void tweak(ProfilerTable var1);
    }

    private static class ProfilerRendererWrapper
    implements TableCellRenderer,
    ProfilerRenderer {
        private final ProfilerRenderer renderer;

        ProfilerRendererWrapper(ProfilerRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setValue(value, row != -1 ? table.convertRowIndexToModel(row) : -1);
            return this.getComponent();
        }

        @Override
        public void setValue(Object value, int row) {
            this.renderer.setValue(value, row);
        }

        @Override
        public int getHorizontalAlignment() {
            return this.renderer.getHorizontalAlignment();
        }

        @Override
        public JComponent getComponent() {
            return this.renderer.getComponent();
        }

        @Override
        public void move(int x, int y) {
            this.renderer.move(x, y);
        }

        public String toString() {
            return this.renderer.toString();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.renderer.getAccessibleContext();
        }
    }

    private class ScrollableRenderer
    extends Component {
        private Component impl;
        private Movable implM;
        private int offset;
        private int prefWidth;
        private int marginOffset;

        private ScrollableRenderer() {
        }

        void setRenderer(Component c, int o, int w) {
            this.impl = c;
            this.offset = o;
            this.prefWidth = w;
            this.marginOffset = ProfilerTable.isLeadingAlign(this.impl) ? 0 : ProfilerTable.this.getColumnModel().getColumnMargin();
            this.implM = c instanceof Movable ? (Movable)((Object)c) : null;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            if (this.prefWidth > w) {
                this.offset += this.marginOffset;
            }
            this.impl.setSize(Math.max(w, this.prefWidth), h);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.impl.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            if (this.implM != null) {
                this.implM.move(-this.offset, 0);
                this.impl.paint(g);
            } else {
                g.translate(-this.offset, 0);
                this.impl.paint(g);
            }
        }
    }
}

