/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.jstestdriver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.libs.jstestdriver.JsTestDriverImplementation;
import org.netbeans.libs.jstestdriver.api.BrowserInfo;
import org.netbeans.libs.jstestdriver.api.ServerListener;
import org.netbeans.libs.jstestdriver.api.TestListener;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;

public class JsTestDriverImpl
implements JsTestDriverImplementation {
    private boolean running = false;
    private Future task;
    private boolean externallyStarted;
    private static final Logger LOGGER = Logger.getLogger(JsTestDriverImpl.class.getName());
    private static RequestProcessor RP = new RequestProcessor("re-fire js-test-driver events");

    public JsTestDriverImpl() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (JsTestDriverImpl.this.task != null) {
                    JsTestDriverImpl.this.task.cancel(true);
                }
            }
        }));
    }

    private boolean wasStartedExternally(int port) {
        try {
            URL u = new URL("http://localhost:" + port);
            URLConnection conn = u.openConnection();
            conn.connect();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static String getJavaBinary() {
        String javaHome = System.getProperty("java.home");
        String javaBinary = Utilities.isWindows() ? "java.exe" : "java";
        return javaHome + File.separator + "bin" + File.separator + javaBinary;
    }

    @Override
    public void startServer(File jsTestDriverJar, int port, boolean strictMode, ServerListener listener) {
        if (this.wasStartedExternally(port)) {
            this.externallyStarted = true;
            IOProvider.getDefault().getIO("js-test-driver Server", false).getOut().println("Port " + port + " is busy. Server was started outside of the IDE.");
            return;
        }
        ExecutionDescriptor descriptor = new ExecutionDescriptor().controllable(false).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ServerInputProcessorFactory(listener)).frontWindowOnError(true);
        File extjar = InstalledFileLocator.getDefault().locate("modules/ext/libs.jstestdriver-ext.jar", "org.netbeans.libs.jstestdriver", false);
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder(JsTestDriverImpl.getJavaBinary()).addArgument("-cp").addArgument(jsTestDriverJar.getAbsolutePath() + File.pathSeparatorChar + extjar.getAbsolutePath()).addArgument("org.netbeans.libs.jstestdriver.ext.StartServer").addArgument("" + port).addArgument("" + strictMode);
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)descriptor, (String)"js-test-driver Server");
        this.task = service.run();
        this.running = true;
    }

    @Override
    public void stopServer() {
        assert (this.running) : "server is not running";
        this.task.cancel(true);
        this.task = null;
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running || this.externallyStarted;
    }

    @Override
    public boolean wasStartedExternally() {
        return this.externallyStarted;
    }

    @Override
    public void runTests(File jsTestDriverJar, String serverURL, boolean strictMode, File baseFolder, File configFile, String testsToRun, final TestListener listener, final LineConvertor lineConvertor) {
        ExecutionDescriptor descriptor = new ExecutionDescriptor().controllable(false).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunInputProcessorFactory(listener)).outConvertorFactory(new ExecutionDescriptor.LineConvertorFactory(){

            public LineConvertor newLineConvertor() {
                return lineConvertor;
            }
        }).frontWindowOnError(true);
        File extjar = InstalledFileLocator.getDefault().locate("modules/ext/libs.jstestdriver-ext.jar", "org.netbeans.libs.jstestdriver", false);
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder(JsTestDriverImpl.getJavaBinary()).addArgument("-cp").addArgument(jsTestDriverJar.getAbsolutePath() + File.pathSeparatorChar + extjar.getAbsolutePath()).addArgument("org.netbeans.libs.jstestdriver.ext.RunTests").addArgument(serverURL).addArgument(baseFolder.getAbsolutePath()).addArgument(configFile.getAbsolutePath()).addArgument(testsToRun).addArgument("" + strictMode);
        ExecutionService service = ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)descriptor, (String)"Running JS unit tests");
        try {
            service.run().get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                listener.onTestingFinished();
            }
        });
    }

    private static class ServerInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private ServerListener listener;

        public ServerInputProcessorFactory(ServerListener listener) {
            this.listener = listener;
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return new ServerInputProcessor(defaultProcessor, this.listener);
        }
    }

    private static class TestRunInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private TestListener listener;

        public TestRunInputProcessorFactory(TestListener listener) {
            this.listener = listener;
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return new TestRunInputProcessor(defaultProcessor, this.listener);
        }
    }

    private static class TestRunInputProcessor
    implements InputProcessor {
        private InputProcessor delegate;
        private TestListener listener;

        public TestRunInputProcessor(InputProcessor delegate, TestListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void processInput(char[] chars) throws IOException {
            String s = new String(chars);
            this.processPossibleBlockOfLines(s);
        }

        private void processPossibleBlockOfLines(String s) throws IOException {
            try {
                StringTokenizer st = new StringTokenizer(s, "\n");
                while (st.hasMoreTokens()) {
                    String ss = this.processSingleLine(st.nextToken()) + "\n";
                    this.delegate.processInput(ss.toCharArray());
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "something went wrong: " + s, t);
            }
        }

        private String processSingleLine(String s) throws IOException {
            int start = s.indexOf("nb-easel-json:{");
            if (start != -1) {
                int end = s.lastIndexOf("}");
                String command = s.substring(start + 14, end + 1);
                Object o = JSONValue.parse((String)command);
                if (o == null) {
                    LOGGER.log(Level.SEVERE, "cannot parse following JSON: " + command + " original message: " + s, new IOException("cannot parse"));
                } else {
                    assert (o instanceof JSONObject) : "must be JSONObject: " + o + " " + o.getClass();
                    JSONObject json = (JSONObject)o;
                    final TestListener.TestResult tr = new TestListener.TestResult(new BrowserInfo((String)json.get((Object)"browserName"), (String)json.get((Object)"browserVersion"), (String)json.get((Object)"browserOS")), (String)json.get((Object)"result"), (String)json.get((Object)"message"), (String)json.get((Object)"log"), (String)json.get((Object)"testCase"), (String)json.get((Object)"testName"), ((Number)json.get((Object)"duration")).longValue(), (String)json.get((Object)"stack"));
                    StringBuilder test = new StringBuilder();
                    test.append(tr.getTestCaseName() + " - " + tr.getTestName() + " " + tr.getResult().toString().toUpperCase() + " in " + tr.getDuration() + "ms (" + tr.getBrowserInfo().getName() + "," + tr.getBrowserInfo().getOs() + "," + tr.getBrowserInfo().getVersion() + ")");
                    if (tr.getStack().length() > 0) {
                        test.append("\n" + tr.getStack());
                    }
                    if (tr.getLog().length() > 0) {
                        test.append("\n" + tr.getLog());
                    }
                    if (tr.getMessage().length() > 0) {
                        test.append("\n" + tr.getMessage());
                    }
                    s = s.substring(0, start) + test.toString() + s.substring(end + 1);
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onTestComplete(tr);
                        }
                    });
                    return s;
                }
            }
            return s;
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class ServerInputProcessor
    implements InputProcessor {
        private InputProcessor delegate;
        private ServerListener listener;

        public ServerInputProcessor(InputProcessor delegate, ServerListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void processInput(char[] chars) throws IOException {
            String s = new String(chars);
            if (s.indexOf("msg.server.started") != -1) {
                s = s.replace("msg.server.started", "Server has started");
                this.delegate.processInput(s.toCharArray());
                this.listener.serverStarted();
            } else {
                this.delegate.processInput(chars);
            }
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

