/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public final class FXConsole
implements ChangeListener<String> {
    static final Logger LOG = Logger.getLogger(FXConsole.class.getName());
    private String title;
    final WebView view;
    final Stage stage;
    private static final List<FXConsole> all = new ArrayList<FXConsole>();

    FXConsole(WebView view, Stage stage) {
        all.add(this);
        this.view = view;
        this.stage = stage;
    }

    void register(WebEngine eng) {
        JSObject fn = (JSObject)eng.executeScript("(function(attr, l, FXConsole) {\n  window.console[attr] = function(msg) {\n    FXConsole.log(l, msg);\n  };})");
        this.registerImpl(fn, "log", Level.INFO);
        this.registerImpl(fn, "info", Level.INFO);
        this.registerImpl(fn, "warn", Level.WARNING);
        this.registerImpl(fn, "error", Level.SEVERE);
    }

    private void registerImpl(JSObject eng, String attr, Level l) {
        eng.call("call", null, attr, l, this);
    }

    void observeWebViewTitle() {
        this.view.getEngine().titleProperty().addListener((ChangeListener)this);
        this.changed(null, null, null);
    }

    public void changed(ObservableValue<? extends String> ov, String t, String t1) {
        this.title = this.view.getEngine().getTitle();
        if (this.title != null) {
            this.stage.setTitle(this.title);
        }
    }

    public void log(Level l, String msg) {
        LOG.log(l, msg);
    }
}

