/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.NodeSourceDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class NodeSourceViaImageDetails
extends NodeSourceDetails {
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="bootVolumeSizeInGBs")
    private final Long bootVolumeSizeInGBs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NodeSourceViaImageDetails(String imageId, Long bootVolumeSizeInGBs) {
        this.imageId = imageId;
        this.bootVolumeSizeInGBs = bootVolumeSizeInGBs;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Long getBootVolumeSizeInGBs() {
        return this.bootVolumeSizeInGBs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeSourceViaImageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(", bootVolumeSizeInGBs=").append(String.valueOf(this.bootVolumeSizeInGBs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeSourceViaImageDetails)) {
            return false;
        }
        NodeSourceViaImageDetails other = (NodeSourceViaImageDetails)((Object)o);
        return Objects.equals(this.imageId, other.imageId) && Objects.equals(this.bootVolumeSizeInGBs, other.bootVolumeSizeInGBs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.bootVolumeSizeInGBs == null ? 43 : this.bootVolumeSizeInGBs.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="bootVolumeSizeInGBs")
        private Long bootVolumeSizeInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder bootVolumeSizeInGBs(Long bootVolumeSizeInGBs) {
            this.bootVolumeSizeInGBs = bootVolumeSizeInGBs;
            this.__explicitlySet__.add("bootVolumeSizeInGBs");
            return this;
        }

        public NodeSourceViaImageDetails build() {
            NodeSourceViaImageDetails model = new NodeSourceViaImageDetails(this.imageId, this.bootVolumeSizeInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NodeSourceViaImageDetails model) {
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("bootVolumeSizeInGBs")) {
                this.bootVolumeSizeInGBs(model.getBootVolumeSizeInGBs());
            }
            return this;
        }
    }
}

