/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.configurations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.configurations.Bundle;
import org.netbeans.modules.gradle.configurations.ConfigurationSnapshot;
import org.netbeans.modules.gradle.configurations.NewConfigurationPanel;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationUpdater;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConfigurationsPanel
extends JPanel
implements HelpCtx.Provider {
    private final Project project;
    private final ProjectConfigurationUpdater updater;
    private GradleExecConfiguration activeConfig;
    private ConfigurationSnapshot handle;
    private JButton btnActivate;
    private JButton btnAdd;
    private JButton btnClone;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnRevert;
    private JScrollPane jScrollPane1;
    private JLabel lblConfigurations;
    private JList lstConfigurations;

    public void setActiveConfig(GradleExecConfiguration activeConfig) {
        this.activeConfig = activeConfig;
        this.handle.setActiveConfiguration(activeConfig);
    }

    ConfigurationsPanel(ProjectConfigurationUpdater updater, ConfigurationSnapshot handle, Project project) {
        this.initComponents();
        this.handle = handle;
        this.project = project;
        this.updater = updater;
        this.activeConfig = handle.getActiveConfiguration();
        this.initListUI();
        this.checkButtonEnablement();
        this.lstConfigurations.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component supers = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                GradleExecConfiguration conf = (GradleExecConfiguration)value;
                if (supers instanceof JLabel) {
                    JLabel jl = (JLabel)supers;
                    String dn = conf.getName();
                    if (!conf.isDefault()) {
                        dn = dn == null || dn.equals(conf.getId()) ? Bundle.CONF_DisplayNameOnly(conf.getId()) : Bundle.CONF_DisplayNameAndId(dn, conf.getId());
                    }
                    jl.setText(dn);
                }
                if (conf == ConfigurationsPanel.this.activeConfig) {
                    supers.setFont(supers.getFont().deriveFont(1));
                }
                return supers;
            }
        });
        this.lstConfigurations.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigurationsPanel.this.checkButtonEnablement();
            }
        });
        this.createListModel();
    }

    private void checkButtonEnablement() {
        GradleExecConfiguration conf = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        this.btnEdit.setEnabled(conf != null);
        boolean canRemove = conf != null && !this.handle.isFixed(conf);
        this.btnRemove.setEnabled(canRemove);
        this.btnRevert.setEnabled(!canRemove && this.handle.isOverriden(conf));
        this.btnActivate.setEnabled(conf != this.handle.getActiveConfiguration());
        this.btnClone.setEnabled(conf != null);
    }

    private void createListModel() {
        DefaultListModel<GradleExecConfiguration> model = new DefaultListModel<GradleExecConfiguration>();
        for (GradleExecConfiguration c : this.handle.getConfigurations()) {
            model.addElement(c);
        }
        this.lstConfigurations.setModel(model);
        this.lstConfigurations.setSelectedValue(this.activeConfig, true);
    }

    private void initComponents() {
        this.lblConfigurations = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstConfigurations = new JList();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnActivate = new JButton();
        this.btnClone = new JButton();
        this.btnRevert = new JButton();
        this.lblConfigurations.setLabelFor(this.lstConfigurations);
        Mnemonics.setLocalizedText((JLabel)this.lblConfigurations, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lblConfigurations.text"));
        this.lstConfigurations.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstConfigurations);
        this.lstConfigurations.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lstConfigurations.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.text"));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnActivate, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.text"));
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnActivateActionPerformed(evt);
            }
        });
        this.btnClone.setText(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnClone.text"));
        this.btnClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnCloneActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRevert, (String)NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRevert.text"));
        this.btnRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationsPanel.this.btnRevertActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConfigurations).addComponent(this.jScrollPane1, -1, 552, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnAdd, -1, -1, Short.MAX_VALUE).addComponent(this.btnActivate, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemove, -1, -1, Short.MAX_VALUE)).addComponent(this.btnEdit, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnClone, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnRevert, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.btnActivate, this.btnAdd, this.btnClone, this.btnEdit, this.btnRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblConfigurations).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.btnActivate).addGap(18, 18, 18).addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRevert).addGap(0, 13, Short.MAX_VALUE)))));
        this.lblConfigurations.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.lblConfigurations.AccessibleContext.accessibleDescription"));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnAdd.AccessibleContext.accessibleDescription"));
        this.btnEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnEdit.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnRemove.AccessibleContext.accessibleDescription"));
        this.btnActivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ConfigurationsPanel.btnActivate.AccessibleContext.accessibleDescription"));
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        GradleExecConfiguration cfg = this.handle.createNew(null);
        this.makeNewConfiguration(cfg, Bundle.TIT_Add_Config(), Bundle.ACSD_Add_Config());
    }

    private void makeNewConfiguration(GradleExecConfiguration cfg, String title, String accDescr) {
        final NewConfigurationPanel pnl = new NewConfigurationPanel(this.project, () -> this.handle.getConfigurations(), true);
        pnl.setShared(false);
        pnl.setConfigurationId(cfg.getId());
        pnl.setDisplayName(cfg.getName());
        pnl.setProperties(cfg.getProjectProperties());
        pnl.setParameters(cfg.getCommandLineArgs());
        pnl.getAccessibleContext().setAccessibleDescription(accDescr);
        final DialogDescriptor dd = new DialogDescriptor((Object)pnl, title);
        NotificationLineSupport supp = dd.createNotificationLineSupport();
        pnl.setNotifications(supp);
        pnl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("panelValid".equals(evt.getPropertyName())) {
                    dd.setValid(pnl.isPanelValid());
                }
            }
        });
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret != DialogDescriptor.OK_OPTION) {
            return;
        }
        cfg = this.handle.createNew(pnl.getConfigurationId());
        this.handle.updateConfiguration(cfg, pnl.getLabel(), pnl.getProperties(), pnl.getParameters());
        this.handle.add(cfg);
        this.handle.setShared(cfg, pnl.isShared());
        this.createListModel();
        this.lstConfigurations.setSelectedValue(cfg, true);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        GradleExecConfiguration cfg = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        if (cfg == null) {
            return;
        }
        final NewConfigurationPanel pnl = new NewConfigurationPanel(this.project, () -> this.handle.getConfigurations(), false);
        pnl.setShared(this.handle.isShared(cfg));
        pnl.setConfigurationId(cfg.getId());
        pnl.setDisplayName(cfg.getName());
        pnl.setProperties(cfg.getProjectProperties());
        pnl.setParameters(cfg.getCommandLineArgs());
        pnl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsPanel.class, (String)"ACSD_Add_Config"));
        final DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(ConfigurationsPanel.class, (String)"TIT_Add_Config"));
        NotificationLineSupport supp = dd.createNotificationLineSupport();
        pnl.setNotifications(supp);
        pnl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("panelValid".equals(evt.getPropertyName())) {
                    dd.setValid(pnl.isPanelValid());
                }
            }
        });
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret != DialogDescriptor.OK_OPTION) {
            return;
        }
        this.handle.updateConfiguration(cfg, pnl.getLabel(), pnl.getProperties(), pnl.getParameters());
        this.handle.setShared(cfg, pnl.isShared());
        this.createListModel();
        this.lstConfigurations.setSelectedValue(cfg, true);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        GradleExecConfiguration sel = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        if (sel == null) {
            return;
        }
        this.handle.removeConfiguration(sel);
        if (sel == this.activeConfig) {
            this.activeConfig = this.handle.getConfigurations().stream().filter(GradleExecConfiguration::isDefault).findAny().orElse(null);
            this.handle.setActiveConfiguration(this.activeConfig);
        }
        this.createListModel();
        this.checkButtonEnablement();
        this.lstConfigurations.repaint();
    }

    private void btnActivateActionPerformed(ActionEvent evt) {
        GradleExecConfiguration sel = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        if (sel == null) {
            return;
        }
        this.activeConfig = sel;
        this.handle.setActiveConfiguration(this.activeConfig);
        this.checkButtonEnablement();
        this.lstConfigurations.repaint();
    }

    private void btnCloneActionPerformed(ActionEvent evt) {
        GradleExecConfiguration sel = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        if (sel == null) {
            return;
        }
        String id = sel.isDefault() ? Bundle.CONF_CloneOfDefault() : Bundle.FMT_ConfigurationCloneId(sel.getId());
        GradleExecConfiguration cfg = GradleExecAccessor.instance().copy(sel, id);
        this.makeNewConfiguration(cfg, Bundle.TIT_Clone_Config(), Bundle.ACSD_Clone_Config());
    }

    private void btnRevertActionPerformed(ActionEvent evt) {
        GradleExecConfiguration sel = (GradleExecConfiguration)this.lstConfigurations.getSelectedValue();
        if (sel == null) {
            return;
        }
        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)Bundle.CONFIRM_RevertConfigurationToDefault(sel.getDisplayName()));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        this.handle.revert(sel);
        this.createListModel();
        this.lstConfigurations.setSelectedValue(sel, true);
    }

    private void initListUI() {
        this.lstConfigurations.setEnabled(true);
        this.btnActivate.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnClone.setEnabled(true);
        this.btnRemove.setEnabled(true);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

