/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.LabelView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class FlatHTML {
    private static final Set<String> absoluteSizeKeywordsSet = new HashSet<String>(Arrays.asList("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"));

    private FlatHTML() {
    }

    public static void updateRendererCSSFontBaseSize(JComponent c) {
        int insertIndex;
        String text;
        View view = (View)c.getClientProperty("html");
        if (view == null) {
            return;
        }
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
        int fontBaseSize = c.getFont().getSize();
        if (styleSheet.getPointSize(7) != 36.0f || styleSheet.getPointSize(4) == (float)fontBaseSize) {
            return;
        }
        if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view)) {
            return;
        }
        if (c instanceof JLabel) {
            text = ((JLabel)c).getText();
        } else if (c instanceof AbstractButton) {
            text = ((AbstractButton)c).getText();
        } else if (c instanceof JToolTip) {
            text = ((JToolTip)c).getTipText();
        } else {
            return;
        }
        if (text == null) {
            return;
        }
        String style = "<style>BASE_SIZE " + c.getFont().getSize() + "</style>";
        String openTag = "";
        String closeTag = "";
        String lowerText = text.toLowerCase(Locale.ENGLISH);
        int headIndex = lowerText.indexOf("<head>");
        if (headIndex >= 0) {
            insertIndex = headIndex + "<head>".length();
        } else {
            int styleIndex = lowerText.indexOf("<style>");
            if (styleIndex >= 0) {
                insertIndex = styleIndex;
            } else {
                insertIndex = "<html>".length();
                openTag = "<head>";
                closeTag = "</head>";
            }
        }
        String newText = text.substring(0, insertIndex) + openTag + style + closeTag + text.substring(insertIndex);
        BasicHTML.updateRenderer(c, newText);
    }

    private static boolean usesAbsoluteSizeKeywordForFontSize(View view) {
        Object fontSize;
        AttributeSet attributes = view.getAttributes();
        if (attributes != null && (fontSize = attributes.getAttribute(CSS.Attribute.FONT_SIZE)) != null && absoluteSizeKeywordsSet.contains(fontSize.toString())) {
            return true;
        }
        int viewCount = view.getViewCount();
        for (int i = 0; i < viewCount; ++i) {
            if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view.getView(i))) continue;
            return true;
        }
        return false;
    }

    public static void updateRendererCSSForeground(View view, Color foreground) {
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument) || foreground == null) {
            return;
        }
        Style bodyStyle = ((HTMLDocument)doc).getStyle("body");
        if (bodyStyle == null) {
            StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
            styleSheet.addRule(String.format("body { color: #%06x; }", foreground.getRGB() & 0xFFFFFF));
            FlatHTML.clearViewCaches(view);
        } else if (!foreground.equals(bodyStyle.getAttribute(StyleConstants.Foreground))) {
            bodyStyle.addAttribute(StyleConstants.Foreground, foreground);
            FlatHTML.clearViewCaches(view);
        }
    }

    private static void clearViewCaches(View view) {
        if (view instanceof LabelView) {
            ((LabelView)view).changedUpdate(null, null, null);
        }
        int viewCount = view.getViewCount();
        for (int i = 0; i < viewCount; ++i) {
            FlatHTML.clearViewCaches(view.getView(i));
        }
    }

    public static PropertyChangeListener createPropertyChangeListener(PropertyChangeListener superListener) {
        return e -> {
            if (superListener != null) {
                superListener.propertyChange(e);
            }
            FlatHTML.propertyChange(e);
        };
    }

    public static void propertyChange(PropertyChangeEvent e) {
        if ("html".equals(e.getPropertyName()) && e.getNewValue() instanceof View) {
            FlatHTML.updateRendererCSSFontBaseSize((JComponent)e.getSource());
        }
    }
}

