/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.stackanalyzer;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class StackLineAnalyser {
    private static final RequestProcessor RP = new RequestProcessor(StackLineAnalyser.class);
    private static final String IDENTIFIER = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern LINE_PATTERN = Pattern.compile("at\\s+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\S*/)?((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)\\.)?(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\.(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*|\\<init\\>|\\<clinit\\>)\\s*\\((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*/)?\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.(?:\\p{javaJavaIdentifierPart}+))?\\:([0-9]*)\\)");

    StackLineAnalyser() {
    }

    static boolean matches(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        return matcher.find();
    }

    static Link analyse(String line) {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            int lineNumber;
            try {
                lineNumber = Integer.parseInt(matcher.group(8));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            int moduleStart = -1;
            if (matcher.group(1) != null) {
                moduleStart = matcher.start(1);
            }
            String ext = matcher.group(7);
            if (matcher.group(2) == null) {
                return new Link(matcher.group(5), lineNumber, moduleStart != -1 ? moduleStart : matcher.start(5), matcher.end(8) + 1, ext);
            }
            return new Link(matcher.group(2) + matcher.group(5), lineNumber, moduleStart != -1 ? moduleStart : matcher.start(2), matcher.end(8) + 1, ext);
        }
        return null;
    }

    @CheckForNull
    private static DataObject findDataObject(@NullAllowed FileObject file) {
        try {
            return file == null ? null : DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException donf) {
            return null;
        }
    }

    static final class Link {
        private final String className;
        private final int lineNumber;
        private final int startOffset;
        private final int endOffset;
        private final String extension;

        private Link(String className, int lineNumber, int startOffset, int endOffset, String extension) {
            this.className = className;
            this.lineNumber = lineNumber;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.extension = extension;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        String getExtension() {
            return this.extension;
        }

        void show() {
            String name = this.className.replace('.', '/');
            ArrayList<CallSite> resources = new ArrayList<CallSite>();
            resources.add((CallSite)((Object)(name + this.getExtension())));
            resources.add((CallSite)((Object)(name + ".java")));
            int idx = name.lastIndexOf(36);
            while (idx >= 0) {
                name = name.substring(0, idx);
                resources.add((CallSite)((Object)(name + this.getExtension())));
                resources.add((CallSite)((Object)(name + ".java")));
                idx = name.lastIndexOf(36);
            }
            ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(StackLineAnalyser.class, (String)"TXT_OpeningSource", resources.get(0)));
            handle.start();
            RP.execute(() -> {
                DataObject dobj = null;
                try {
                    ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
                    for (String resource : resources) {
                        dobj = StackLineAnalyser.findDataObject(classPath.findResource(resource));
                        if (dobj == null) continue;
                        break;
                    }
                }
                finally {
                    DataObject dataObject = dobj;
                    Mutex.EVENT.readAccess(() -> this.lambda$show$0(dataObject, resources, handle));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$show$0(DataObject dataObject, List resources, ProgressHandle handle) {
            block12: {
                block11: {
                    block13: {
                        block10: {
                            block9: {
                                if (dataObject != null) break block9;
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StackLineAnalyser.class, (String)"AnalyzeStackTopComponent.sourceNotFound", (Object[])new Object[]{resources.get(0)}));
                                handle.finish();
                                return;
                            }
                            editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                            lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
                            if (editorCookie == null || lineCookie == null || this.lineNumber == -1 || (doc = editorCookie.openDocument()) == null || this.lineNumber == -1) ** GOTO lbl24
                            l = lineCookie.getLineSet().getCurrent(this.lineNumber - 1);
                            if (l == null) break block10;
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
                            handle.finish();
                            return;
                        }
                        break block13;
                        {
                            catch (IndexOutOfBoundsException oob) {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StackLineAnalyser.class, (String)"AnalyzeStackTopComponent.lineNotFound", (Object[])new Object[]{this.lineNumber}));
                            }
                        }
                    }
                    if ((openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class)) == null) break block11;
                    openCookie.open();
                    handle.finish();
                    return;
                }
                try {
                    break block12;
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                finally {
                    handle.finish();
                }
            }
        }
    }
}

