/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.TypeConversionUtils;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.mapping.InsertMappingConsumer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public abstract class DatastoreFieldManager
extends AbstractFieldManager {
    private static final TypeConversionUtils TYPE_CONVERSION_UTILS = new TypeConversionUtils();
    protected final LinkedList<FieldManagerState> fieldManagerStateStack = new LinkedList();
    protected ObjectProvider op;
    protected Entity datastoreEntity;

    protected DatastoreFieldManager(ObjectProvider op, Entity datastoreEntity, int[] fieldNumbers) {
        AbstractMemberMetaDataProvider ammdProvider = new AbstractMemberMetaDataProvider(){

            @Override
            public AbstractMemberMetaData get(int fieldNumber) {
                return DatastoreFieldManager.this.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            }
        };
        this.op = op;
        this.datastoreEntity = datastoreEntity;
        InsertMappingConsumer mappingConsumer = this.buildMappingConsumer(op.getClassMetaData(), op.getExecutionContext().getClassLoaderResolver(), fieldNumbers, null);
        this.fieldManagerStateStack.addFirst(new FieldManagerState(op, ammdProvider, mappingConsumer, false));
        String expectedKind = EntityUtils.determineKind(this.getClassMetaData(), op.getExecutionContext());
        if (!expectedKind.equals(datastoreEntity.getKind())) {
            throw new NucleusException("ObjectProvider is for <" + expectedKind + "> but key is for <" + datastoreEntity.getKind() + ">.  One way this can happen is if you attempt to fetch an object of one type using" + " a Key of a different type.").setFatal();
        }
    }

    Entity getEntity() {
        return this.datastoreEntity;
    }

    ObjectProvider getObjectProvider() {
        return this.fieldManagerStateStack.getFirst().op;
    }

    AbstractMemberMetaData getMetaData(int fieldNumber) {
        return this.fieldManagerStateStack.getFirst().abstractMemberMetaDataProvider.get(fieldNumber);
    }

    ExecutionContext getExecutionContext() {
        return this.getObjectProvider().getExecutionContext();
    }

    AbstractClassMetaData getClassMetaData() {
        return this.getObjectProvider().getClassMetaData();
    }

    ClassLoaderResolver getClassLoaderResolver() {
        return this.getExecutionContext().getClassLoaderResolver();
    }

    DatastoreManager getStoreManager() {
        return (DatastoreManager)this.op.getExecutionContext().getStoreManager();
    }

    DatastoreTable getDatastoreTable() {
        return this.getStoreManager().getDatastoreClass(this.getClassMetaData().getFullClassName(), this.getClassLoaderResolver());
    }

    protected boolean isPK(int fieldNumber) {
        if (this.fieldManagerStateStack.getFirst().isEmbedded) {
            return false;
        }
        int[] pkPositions = this.getClassMetaData().getPKMemberPositions();
        return pkPositions != null && pkPositions[0] == fieldNumber;
    }

    protected InsertMappingConsumer buildMappingConsumer(AbstractClassMetaData acmd, ClassLoaderResolver clr, int[] fieldNumbers, EmbeddedMetaData emd) {
        DatastoreTable table = this.getStoreManager().getDatastoreClass(acmd.getFullClassName(), clr);
        if (table == null) {
            throw new NoPersistenceInformationException(acmd.getFullClassName());
        }
        InsertMappingConsumer consumer = new InsertMappingConsumer(acmd);
        if (emd == null) {
            table.provideDatastoreIdMappings(consumer);
            table.providePrimaryKeyMappings(consumer);
        }
        if (fieldNumbers == null || emd != null) {
            table.provideNonPrimaryKeyMappings(consumer, emd != null);
        } else {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[fieldNumbers.length];
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    fmds[i] = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                }
            }
            table.provideMappingsForMembers(consumer, fmds, false);
        }
        if (emd != null) {
            DatastoreTable parentTable = this.getStoreManager().getDatastoreClass(this.getClassMetaData().getFullClassName(), clr);
            AbstractMemberMetaData parentField = (AbstractMemberMetaData)emd.getParent();
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)parentTable.getMappingForFullFieldName(parentField.getFullFieldName());
            HashMap<String, AbstractMemberMetaData> embeddedMetaDataByFullFieldName = Utils.newHashMap();
            int numMappings = embeddedMapping.getNumberOfJavaTypeMappings();
            for (int i = 0; i < numMappings; ++i) {
                JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
                AbstractMemberMetaData ammd = fieldMapping.getMemberMetaData();
                embeddedMetaDataByFullFieldName.put(ammd.getFullFieldName(), ammd);
            }
            HashMap<Integer, AbstractMemberMetaData> map = new HashMap<Integer, AbstractMemberMetaData>(consumer.getFieldIndexToMemberMetaData());
            for (Map.Entry entry : map.entrySet()) {
                AbstractMemberMetaData replacement = (AbstractMemberMetaData)embeddedMetaDataByFullFieldName.get(((AbstractMemberMetaData)entry.getValue()).getFullFieldName());
                if (replacement == null) {
                    throw new RuntimeException("Unable to locate " + ((AbstractMemberMetaData)entry.getValue()).getFullFieldName() + " in embedded meta-data " + "map.  This is most likely an App Engine bug.");
                }
                consumer.getFieldIndexToMemberMetaData().put((Integer)entry.getKey(), replacement);
            }
        }
        return consumer;
    }

    protected RuntimeException exceptionForUnexpectedKeyType(String fieldType, int fieldNumber) {
        return new IllegalStateException(fieldType + " for type " + this.getClassMetaData().getName() + " is of unexpected type " + this.getMetaData(fieldNumber).getType().getName() + " (must be String, Long, or " + Key.class.getName() + ")");
    }

    protected AbstractMemberMetaDataProvider getEmbeddedAbstractMemberMetaDataProvider(final InsertMappingConsumer consumer) {
        return new AbstractMemberMetaDataProvider(){

            @Override
            public AbstractMemberMetaData get(int fieldNumber) {
                return consumer.getMemberMetaDataForIndex(fieldNumber);
            }
        };
    }

    protected ObjectProvider getEmbeddedObjectProvider(AbstractMemberMetaData ammd, int fieldNumber, Object value) {
        ObjectProvider embeddedOP;
        if (value == null) {
            value = JDOImplHelper.getInstance().newInstance(ammd.getType(), (StateManager)this.getObjectProvider());
        }
        if ((embeddedOP = this.getExecutionContext().findObjectProvider(value)) == null) {
            embeddedOP = ObjectProviderFactory.newForEmbedded((ExecutionContext)this.getExecutionContext(), (Object)value, (boolean)false, (ObjectProvider)this.getObjectProvider(), (int)fieldNumber);
            embeddedOP.setPcObjectType((short)1);
        }
        return embeddedOP;
    }

    TypeConversionUtils getConversionUtils() {
        return TYPE_CONVERSION_UTILS;
    }

    protected static final class FieldManagerState {
        protected final ObjectProvider op;
        protected final AbstractMemberMetaDataProvider abstractMemberMetaDataProvider;
        protected final InsertMappingConsumer mappingConsumer;
        protected final boolean isEmbedded;

        protected FieldManagerState(ObjectProvider op, AbstractMemberMetaDataProvider abstractMemberMetaDataProvider, InsertMappingConsumer mappingConsumer, boolean isEmbedded) {
            this.op = op;
            this.abstractMemberMetaDataProvider = abstractMemberMetaDataProvider;
            this.mappingConsumer = mappingConsumer;
            this.isEmbedded = isEmbedded;
        }
    }

    protected static interface AbstractMemberMetaDataProvider {
        public AbstractMemberMetaData get(int var1);
    }
}

