/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandName;
import java.util.Locale;
import java.util.Map;

public class Commands {
    private final Map<String, Command> fullNameToCommandMap = Maps.newHashMap();
    private final Map<String, Command> shortNameToCommandMap = Maps.newHashMap();

    public void registerCommand(Command c) {
        for (CommandName name : c.getNames()) {
            Preconditions.checkState(!this.fullNameToCommandMap.containsKey(name.getName().toUpperCase(Locale.ENGLISH)));
            Preconditions.checkState(!this.shortNameToCommandMap.containsKey(name.getShortName()));
        }
        for (CommandName name : c.getNames()) {
            this.fullNameToCommandMap.put(name.getName().toUpperCase(Locale.ENGLISH), c);
            this.shortNameToCommandMap.put(name.getShortName(), c);
        }
    }

    public ImmutableSet<Command> getCommands() {
        return ImmutableSet.copyOf(this.fullNameToCommandMap.values());
    }

    public Command getCommand(String name) {
        Command command = this.fullNameToCommandMap.get(name.toUpperCase(Locale.ENGLISH));
        return command != null ? command : this.shortNameToCommandMap.get(name);
    }
}

