/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import org.datanucleus.FetchPlanForClass;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;

public abstract class AbstractFetchFieldManager
extends AbstractFieldManager {
    protected final ObjectProvider sm;
    protected final boolean[] secondClassMutableFields;
    protected FetchPlanForClass fpClass;
    protected final FetchPlanState state;

    public AbstractFetchFieldManager(ObjectProvider sm, boolean[] secondClassMutableFields, FetchPlanForClass fpClass, FetchPlanState state) {
        this.sm = sm;
        this.secondClassMutableFields = secondClassMutableFields;
        this.fpClass = fpClass;
        this.state = state;
    }

    public Object fetchObjectField(int fieldNumber) throws EndOfFetchPlanGraphException {
        AbstractMemberMetaData fmd = this.fpClass.getAbstractClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        boolean requiresFCOFetching = MetaDataUtils.getInstance().storesFCO(fmd, this.sm.getExecutionContext());
        int maxFetchDepth = this.fpClass.getFetchPlan().getMaxFetchDepth();
        int currentFetchDepth = this.state.getCurrentFetchDepth();
        if (requiresFCOFetching) {
            if (currentFetchDepth > 0 && maxFetchDepth > 0 && currentFetchDepth == maxFetchDepth) {
                return this.endOfGraphOperation(fieldNumber);
            }
            int maxRecursiveDepth = this.fpClass.getMaxRecursionDepthForMember(fieldNumber);
            if (maxRecursiveDepth > 0 && this.state.getObjectDepthForType(fmd.getFullFieldName()) >= maxRecursiveDepth) {
                return this.endOfGraphOperation(fieldNumber);
            }
            this.state.addMemberName(fmd.getFullFieldName());
            Object result = this.internalFetchObjectField(fieldNumber);
            this.state.removeLatestMemberName();
            return result;
        }
        return this.internalFetchObjectField(fieldNumber);
    }

    protected abstract Object internalFetchObjectField(int var1);

    protected abstract Object endOfGraphOperation(int var1);

    public boolean fetchBooleanField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchBooleanField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchByteField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchCharField(fieldNumber);
    }

    public double fetchDoubleField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchDoubleField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchFloatField(fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchIntField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchLongField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchShortField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchStringField(fieldNumber);
    }

    public static class EndOfFetchPlanGraphException
    extends RuntimeException {
    }
}

