/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.awt.AlphaComposite;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import mediautil.gen.Log;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.LLJTranException;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalImagesService
extends AbstractLocalRpcService {
    private static final Logger log = Logger.getLogger(LocalImagesService.class.getCanonicalName());
    private String hostPrefix;
    public static final String PACKAGE = "images";
    private BlobStorage blobStorage;

    public String getPackage() {
        return PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(LocalServiceContext context, Map<String, String> properties) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader appLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(appLoader);
            ImageIO.scanForPlugins();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        String[] inputFormats = new String[]{"png", "jpg", "gif", "bmp", "ico", "tif", "webp"};
        String[] outputFormats = new String[]{"png", "jpg", "webp"};
        for (String format : inputFormats) {
            if (ImageIO.getImageReadersByFormatName(format).hasNext()) continue;
            log.warning("No image reader found for format \"" + format + "\"." + " An ImageIO plugin must be installed to use this format" + " with the DevAppServer.");
        }
        for (String format : outputFormats) {
            if (ImageIO.getImageWritersByFormatName(format).hasNext()) continue;
            log.warning("No image writer found for format \"" + format + "\"." + " An ImageIO plugin must be installed to use this format" + " with the DevAppServer.");
        }
        context.getLocalService("blobstore");
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        LocalServerEnvironment env = context.getLocalServerEnvironment();
        this.hostPrefix = "http://" + env.getAddress() + ":" + env.getPort();
        Log.debugLevel = 0;
    }

    public void start() {
    }

    public void stop() {
    }

    public ImagesServicePb.ImagesTransformResponse transform(final LocalRpcService.Status status, final ImagesServicePb.ImagesTransformRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesTransformResponse>(){

            @Override
            public ImagesServicePb.ImagesTransformResponse run() {
                Entry entry;
                Exif exif;
                BufferedImage img = LocalImagesService.this.openImage(request.getImage(), status);
                if (request.getTransformCount() > 10) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), String.format("%d transforms were supplied; the maximum allowed is %d.", request.getTransformCount(), 10));
                }
                int orientation = 1;
                if (request.getInput().getCorrectExifOrientation() == ImagesServicePb.InputSettings.ORIENTATION_CORRECTION_TYPE.CORRECT_ORIENTATION && (exif = LocalImagesService.this.getExifMetadata(request.getImage())) != null && (entry = exif.getTagValue(274, true)) != null) {
                    orientation = (Integer)entry.getValue(0);
                    if (img.getHeight() > img.getWidth()) {
                        orientation = 1;
                    }
                }
                for (ImagesServicePb.Transform transform : request.getTransformList()) {
                    if (!(orientation == 1 || transform.hasCropRightX() || transform.hasCropTopY() || transform.hasCropBottomY() || transform.hasCropLeftX() || transform.hasHorizontalFlip() || transform.hasVerticalFlip())) {
                        img = LocalImagesService.this.correctOrientation(img, status, orientation);
                        orientation = 1;
                    }
                    if (transform.getAllowStretch() && transform.getCropToFit()) {
                        ImagesServicePb.Transform.Builder stretch = ImagesServicePb.Transform.newBuilder();
                        stretch.setWidth(transform.getWidth()).setHeight(transform.getHeight()).setAllowStretch(true);
                        img = LocalImagesService.this.processTransform(img, stretch.build(), status);
                        ImagesServicePb.Transform.Builder crop = ImagesServicePb.Transform.newBuilder();
                        crop.setWidth(transform.getWidth()).setHeight(transform.getHeight()).setCropToFit(transform.getCropToFit()).setCropOffsetX(transform.getCropOffsetX()).setCropOffsetY(transform.getCropOffsetY()).setAllowStretch(false);
                        img = LocalImagesService.this.processTransform(img, crop.build(), status);
                    } else {
                        img = LocalImagesService.this.processTransform(img, transform, status);
                    }
                    if (orientation == 1) continue;
                    img = LocalImagesService.this.correctOrientation(img, status, orientation);
                    orientation = 1;
                }
                status.setSuccessful(true);
                ImagesServicePb.ImageData imageData = ImagesServicePb.ImageData.newBuilder().setContent(ByteString.copyFrom((byte[])LocalImagesService.this.saveImage(img, request.getOutput().getMimeType(), status))).setWidth(img.getWidth()).setHeight(img.getHeight()).build();
                return ImagesServicePb.ImagesTransformResponse.newBuilder().setImage(imageData).build();
            }
        });
    }

    public ImagesServicePb.ImagesCompositeResponse composite(final LocalRpcService.Status status, final ImagesServicePb.ImagesCompositeRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesCompositeResponse>(){

            @Override
            public ImagesServicePb.ImagesCompositeResponse run() {
                int i;
                ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(request.getImageCount());
                for (int i2 = 0; i2 < request.getImageCount(); ++i2) {
                    images.add(LocalImagesService.this.openImage(request.getImage(i2), status));
                }
                if (request.getOptionsCount() > 16) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), String.format("%d composites were supplied; the maximum allowed is %d.", request.getOptionsCount(), 16));
                }
                int width = request.getCanvas().getWidth();
                int height = request.getCanvas().getHeight();
                int color = request.getCanvas().getColor();
                BufferedImage canvas = new BufferedImage(width, height, 2);
                for (i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        canvas.setRGB(j, i, color);
                    }
                }
                for (i = 0; i < request.getOptionsCount(); ++i) {
                    ImagesServicePb.CompositeImageOptions options = request.getOptions(i);
                    if (options.getSourceIndex() < 0 || options.getSourceIndex() >= request.getImageCount()) {
                        throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), String.format("Invalid source image index %d", options.getSourceIndex()));
                    }
                    LocalImagesService.this.processComposite(canvas, options, (BufferedImage)images.get(options.getSourceIndex()), status);
                }
                status.setSuccessful(true);
                return ImagesServicePb.ImagesCompositeResponse.newBuilder().setImage(ImagesServicePb.ImageData.newBuilder().setContent(ByteString.copyFrom((byte[])LocalImagesService.this.saveImage(canvas, request.getCanvas().getOutput().getMimeType(), status)))).build();
            }
        });
    }

    String getMimeType(ImagesServicePb.ImageData imageData) {
        try {
            ImageInputStream in = ImageIO.createImageInputStream(this.extractImageData(imageData));
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (!readers.hasNext()) {
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber(), "Failed to read image");
            }
            ImageReader reader = readers.next();
            return reader.getFormatName();
        }
        catch (IOException ex) {
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getNumber(), "Could not read blob.");
        }
    }

    Exif getExifMetadata(ImagesServicePb.ImageData imageData) {
        if (this.getMimeType(imageData).equals("JPEG")) {
            try {
                LLJTran transform = new LLJTran(this.extractImageData(imageData));
                try {
                    transform.read(true);
                }
                catch (LLJTranException e) {
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber(), "Failed to read image EXIF metadata");
                }
                AbstractImageInfo info = transform.getImageInfo();
                if (info instanceof Exif) {
                    return (Exif)info;
                }
            }
            catch (IOException ex) {
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getNumber(), "Could not read blob.");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage openImage(ImagesServicePb.ImageData imageData, LocalRpcService.Status status) {
        InputStream in = null;
        try {
            BufferedImage img;
            try {
                in = this.extractImageData(imageData);
            }
            catch (IOException ex) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getNumber(), "Could not read blob.");
            }
            try {
                img = ImageIO.read(in);
            }
            catch (IOException ex) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber(), "Failed to read image");
            }
            if (img == null) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getNumber(), "Failed to read image");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    byte[] saveImage(BufferedImage image, ImagesServicePb.OutputSettings.MIME_TYPE mimeType, LocalRpcService.Status status) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            if (mimeType == ImagesServicePb.OutputSettings.MIME_TYPE.JPEG) {
                ImageIO.write((RenderedImage)image, "jpg", out);
            } else if (mimeType == ImagesServicePb.OutputSettings.MIME_TYPE.WEBP) {
                ImageIO.write((RenderedImage)image, "webp", out);
            } else {
                ImageIO.write((RenderedImage)image, "png", out);
            }
        }
        catch (IOException ex) {
            status.setSuccessful(false);
            status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR.getNumber());
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR.getNumber(), "Failed to encode image");
        }
        return out.toByteArray();
    }

    public ImagesServicePb.ImagesHistogramResponse histogram(final LocalRpcService.Status status, final ImagesServicePb.ImagesHistogramRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesHistogramResponse>(){

            @Override
            public ImagesServicePb.ImagesHistogramResponse run() {
                BufferedImage img = LocalImagesService.this.openImage(request.getImage(), status);
                int[] red = new int[256];
                int[] green = new int[256];
                int[] blue = new int[256];
                for (int i = 0; i < img.getHeight(); ++i) {
                    for (int j = 0; j < img.getWidth(); ++j) {
                        int pixel = img.getRGB(j, i);
                        int n = (pixel >> 16 & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        red[n] = red[n] + 1;
                        int n2 = (pixel >> 8 & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        green[n2] = green[n2] + 1;
                        int n3 = (pixel & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        blue[n3] = blue[n3] + 1;
                    }
                }
                ImagesServicePb.ImagesHistogram.Builder imageHistogram = ImagesServicePb.ImagesHistogram.newBuilder();
                for (int i = 0; i < 256; ++i) {
                    imageHistogram.addRed(red[i]);
                    imageHistogram.addGreen(green[i]);
                    imageHistogram.addBlue(blue[i]);
                }
                return ImagesServicePb.ImagesHistogramResponse.newBuilder().setHistogram(imageHistogram).build();
            }
        });
    }

    public ImagesServicePb.ImagesGetUrlBaseResponse getUrlBase(LocalRpcService.Status status, final ImagesServicePb.ImagesGetUrlBaseRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesGetUrlBaseResponse>(){

            @Override
            public ImagesServicePb.ImagesGetUrlBaseResponse run() {
                if (request.getCreateSecureUrl()) {
                    log.info("Secure URLs will not be created using the development application server.");
                }
                ImagesServicePb.ImageData imageData = ImagesServicePb.ImageData.newBuilder().setBlobKey(request.getBlobKey()).setContent(ByteString.EMPTY).build();
                LocalImagesService.this.getMimeType(imageData);
                return ImagesServicePb.ImagesGetUrlBaseResponse.newBuilder().setUrl(LocalImagesService.this.hostPrefix + "/_ah/img/" + request.getBlobKey()).build();
            }
        });
    }

    public Integer getMaxApiRequestSize() {
        return 0x2000000;
    }

    BufferedImage correctOrientation(BufferedImage image, LocalRpcService.Status status, int orientation) {
        ImagesServicePb.Transform.Builder transform = ImagesServicePb.Transform.newBuilder();
        ImagesServicePb.Transform.Builder secondTransform = ImagesServicePb.Transform.newBuilder();
        switch (orientation) {
            case 2: {
                return this.processTransform(image, transform.setHorizontalFlip(true).build(), status);
            }
            case 3: {
                return this.processTransform(image, transform.setRotate(180).build(), status);
            }
            case 4: {
                return this.processTransform(image, transform.setVerticalFlip(true).build(), status);
            }
            case 5: {
                image = this.processTransform(image, transform.setVerticalFlip(true).build(), status);
                return this.processTransform(image, secondTransform.setRotate(90).build(), status);
            }
            case 6: {
                return this.processTransform(image, transform.setRotate(90).build(), status);
            }
            case 7: {
                image = this.processTransform(image, transform.setHorizontalFlip(true).build(), status);
                return this.processTransform(image, secondTransform.setRotate(90).build(), status);
            }
            case 8: {
                return this.processTransform(image, transform.setRotate(270).build(), status);
            }
        }
        return image;
    }

    BufferedImage processTransform(BufferedImage image, ImagesServicePb.Transform transform, LocalRpcService.Status status) {
        AffineTransform affine = null;
        BufferedImage constraintImage = null;
        if (transform.hasWidth() || transform.hasHeight()) {
            if (transform.getWidth() < 0 || transform.getHeight() < 0 || transform.getWidth() > 4000 || transform.getHeight() > 4000) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), String.format("Invalid resize: width and height must be in range [0,%d]", 4000));
            }
            if (transform.getWidth() == 0 && transform.getHeight() == 0) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid resize: width and height cannot both be 0.");
            }
            if (transform.getCropToFit() && (transform.getWidth() == 0 || transform.getHeight() == 0)) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid resize: neither width nor height can be 0 with crop to fit.");
            }
            if (transform.getAllowStretch() && (transform.getWidth() == 0 || transform.getHeight() == 0)) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid resize: neither width nor height can be 0 with allow stretch.");
            }
            if (!(!transform.getCropToFit() || this.validCropArgument(transform.getCropOffsetX()) && this.validCropArgument(transform.getCropOffsetY()))) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid resize: crop offsets must be in the range 0.0 to 1.0.");
            }
            double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
            double xFactor = (double)transform.getWidth() / (double)image.getWidth();
            double yFactor = (double)transform.getHeight() / (double)image.getHeight();
            ImageTypeSpecifier imageSpecifier = ImageTypeSpecifier.createFromRenderedImage(image);
            if (transform.getAllowStretch()) {
                constraintImage = imageSpecifier.createBufferedImage(transform.getWidth(), transform.getHeight());
                affine = AffineTransform.getScaleInstance(xFactor, yFactor);
            } else if (transform.getCropToFit()) {
                double transformFactor = Math.max(xFactor, yFactor);
                constraintImage = imageSpecifier.createBufferedImage(transform.getWidth(), transform.getHeight());
                double uncroppedWidth = (double)image.getWidth() * transformFactor;
                double uncroppedHeight = (double)image.getHeight() * transformFactor;
                affine = new AffineTransform(transformFactor, 0.0, 0.0, transformFactor, ((double)transform.getWidth() - uncroppedWidth) * (double)transform.getCropOffsetX(), ((double)transform.getHeight() - uncroppedHeight) * (double)transform.getCropOffsetY());
            } else {
                double transformFactor;
                if (xFactor < yFactor && xFactor != 0.0) {
                    transformFactor = xFactor;
                    constraintImage = imageSpecifier.createBufferedImage(transform.getWidth(), (int)Math.round((double)transform.getWidth() / aspectRatio));
                } else {
                    transformFactor = yFactor;
                    constraintImage = imageSpecifier.createBufferedImage((int)Math.round((double)transform.getHeight() * aspectRatio), transform.getHeight());
                }
                affine = AffineTransform.getScaleInstance(transformFactor, transformFactor);
            }
        } else if (transform.hasRotate()) {
            if (transform.getRotate() % 90 != 0 || transform.getRotate() >= 360 || transform.getRotate() < 0) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid rotate.");
            }
            affine = AffineTransform.getRotateInstance((double)transform.getRotate() * Math.PI / 180.0);
            if (transform.getRotate() == 90) {
                affine.translate(0.0, -image.getHeight());
            } else if (transform.getRotate() == 180) {
                affine.translate(-image.getWidth(), -image.getHeight());
            } else if (transform.getRotate() == 270) {
                affine.translate(-image.getWidth(), 0.0);
            }
        } else if (transform.hasHorizontalFlip()) {
            affine = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(image.getWidth() - 1), 0.0);
        } else if (transform.hasVerticalFlip()) {
            affine = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(image.getHeight() - 1));
        } else {
            if (transform.hasCropLeftX() || transform.hasCropTopY() || transform.hasCropRightX() || transform.hasCropBottomY()) {
                if (!this.validCropArgs(transform)) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Invalid crop.");
                }
                return image.getSubimage((int)(transform.getCropLeftX() * (float)image.getWidth()), (int)(transform.getCropTopY() * (float)image.getHeight()), (int)((transform.getCropRightX() - transform.getCropLeftX()) * (float)image.getWidth()), (int)((transform.getCropBottomY() - transform.getCropTopY()) * (float)image.getHeight()));
            }
            if (transform.hasAutolevels()) {
                log.warning("I'm Feeling Lucky is not available in the SDK.");
            } else {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
            }
        }
        if (affine != null) {
            AffineTransformOp op = new AffineTransformOp(affine, 1);
            return op.filter(image, constraintImage);
        }
        return image;
    }

    private BufferedImage processComposite(BufferedImage canvas, ImagesServicePb.CompositeImageOptions options, BufferedImage image, LocalRpcService.Status status) {
        float opacity = options.getOpacity();
        if (opacity < 0.0f || opacity > 1.0f) {
            status.setSuccessful(false);
            status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber());
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getNumber(), "Opacity must be in range [0.0, 1.0]");
        }
        if (opacity == 0.0f) {
            return canvas;
        }
        float xAnchor = (float)(options.getAnchor().ordinal() % 3) * 0.5f;
        float yAnchor = (float)(options.getAnchor().ordinal() / 3) * 0.5f;
        int xOffset = (int)((float)options.getXOffset() + xAnchor * (float)(canvas.getWidth() - image.getWidth()));
        int yOffset = (int)((float)options.getYOffset() + yAnchor * (float)(canvas.getHeight() - image.getHeight()));
        int yStart = Math.max(0, -yOffset);
        int xStart = Math.max(0, -xOffset);
        int yEnd = Math.min(image.getHeight(), canvas.getHeight() - yOffset);
        int xEnd = Math.min(image.getWidth(), canvas.getWidth() - xOffset);
        if (xStart >= xEnd || yStart >= yEnd) {
            return canvas;
        }
        BufferedImage positionedImage = new BufferedImage(xEnd + xOffset, yEnd + yOffset, 2);
        for (int i = yStart; i < yEnd; ++i) {
            for (int j = xStart; j < xEnd; ++j) {
                positionedImage.setRGB(j + xOffset, i + yOffset, image.getRGB(j, i) | 0xFF000000);
            }
        }
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        composite.createContext(positionedImage.getColorModel(), canvas.getColorModel(), null).compose(positionedImage.getRaster(), canvas.getRaster(), canvas.getRaster());
        return canvas;
    }

    private boolean validCropArgs(ImagesServicePb.Transform transform) {
        return this.validCropArgument(transform.getCropLeftX()) && this.validCropArgument(transform.getCropTopY()) && this.validCropArgument(transform.getCropRightX()) && this.validCropArgument(transform.getCropBottomY()) && transform.getCropLeftX() < transform.getCropRightX() && transform.getCropTopY() < transform.getCropBottomY();
    }

    private boolean validCropArgument(float arg) {
        return arg >= 0.0f && arg <= 1.0f;
    }

    BlobStorage getBlobStorage() {
        return this.blobStorage;
    }

    private InputStream extractImageData(ImagesServicePb.ImageData imageData) throws IOException {
        if (imageData.hasBlobKey()) {
            return this.getBlobStorage().fetchBlob(new BlobKey(imageData.getBlobKey()));
        }
        return new ByteArrayInputStream(imageData.getContent().toByteArray());
    }
}

