/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.auth;

import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.BasicScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.DigestScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.NTLMScheme;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AuthPolicy {
    private static final HashMap SCHEMES = new HashMap();
    private static final ArrayList SCHEME_LIST = new ArrayList();
    public static final String AUTH_SCHEME_PRIORITY = "http.auth.scheme-priority";
    public static final String NTLM = "NTLM";
    public static final String DIGEST = "Digest";
    public static final String BASIC = "Basic";
    protected static final Log LOG;

    public static synchronized void registerAuthScheme(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Authentication scheme class may not be null");
        }
        SCHEMES.put(string.toLowerCase(), clazz);
        SCHEME_LIST.add(string.toLowerCase());
    }

    public static synchronized void unregisterAuthScheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SCHEMES.remove(string.toLowerCase());
        SCHEME_LIST.remove(string.toLowerCase());
    }

    public static synchronized AuthScheme getAuthScheme(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SCHEMES.get(string.toLowerCase());
        if (clazz != null) {
            try {
                return (AuthScheme)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.error("Error initializing authentication scheme: " + string, exception);
                throw new IllegalStateException(string + " authentication scheme implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported authentication scheme " + string);
    }

    public static synchronized List getDefaultAuthPrefs() {
        return (List)SCHEME_LIST.clone();
    }

    static {
        AuthPolicy.registerAuthScheme(NTLM, NTLMScheme.class);
        AuthPolicy.registerAuthScheme(DIGEST, DigestScheme.class);
        AuthPolicy.registerAuthScheme(BASIC, BasicScheme.class);
        LOG = LogFactory.getLog(AuthPolicy.class);
    }
}

