/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.AbstractIterator;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.appengine.query.QueryData;
import org.datanucleus.store.appengine.query.SlicingIterable;
import org.datanucleus.store.appengine.query.StreamingMergeJoinResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JoinHelper {
    private final Set<Key> materializedChildKeys = Utils.newHashSet(new Object[0]);

    JoinHelper() {
    }

    Iterable<Entity> executeJoinQuery(QueryData qd, DatastoreQuery query, DatastoreService ds, FetchOptions opts) {
        Iterator joinResult;
        Iterable primaryResult;
        this.materializedChildKeys.clear();
        String joinSortProp = query.getSortProperty(qd, (Expression)qd.joinOrderExpression);
        this.validateJoinQuery(qd, query, joinSortProp);
        if (!JoinHelper.sortAlreadyExists(joinSortProp, Query.SortDirection.ASCENDING, qd.primaryDatastoreQuery)) {
            qd.primaryDatastoreQuery.addSort(joinSortProp);
        }
        Integer chunkSize = null;
        Integer prefetchSize = null;
        Integer offset = null;
        Integer limit = null;
        if (opts != null) {
            chunkSize = opts.getChunkSize();
            prefetchSize = opts.getPrefetchSize();
            offset = opts.getOffset();
            limit = opts.getLimit();
        }
        FetchOptions optsWithoutOffsetAndLimit = this.getFetchOptionsWithoutOffsetAndLimit(opts, chunkSize, prefetchSize);
        String keyProperty = ((Query.SortPredicate)qd.primaryDatastoreQuery.getSortPredicates().get(0)).getPropertyName();
        if (optsWithoutOffsetAndLimit == null) {
            primaryResult = ds.prepare(qd.primaryDatastoreQuery).asIterable();
            joinResult = ds.prepare(qd.joinQuery).asIterator();
        } else {
            primaryResult = ds.prepare(qd.primaryDatastoreQuery).asIterable(optsWithoutOffsetAndLimit);
            joinResult = ds.prepare(qd.joinQuery).asIterator(optsWithoutOffsetAndLimit);
        }
        Iterable<Entity> result = this.mergeJoin(keyProperty, primaryResult, joinResult);
        if (offset == null && limit == null) {
            return result;
        }
        return new SlicingIterable<Entity>(offset == null ? 0 : offset, limit, this.mergeJoin(keyProperty, primaryResult, joinResult));
    }

    private FetchOptions getFetchOptionsWithoutOffsetAndLimit(FetchOptions opts, Integer chunkSize, Integer prefetchSize) {
        FetchOptions optsWithoutOffsetAndLimit = null;
        if (chunkSize != null) {
            optsWithoutOffsetAndLimit = FetchOptions.Builder.withChunkSize((int)opts.getChunkSize());
            if (prefetchSize != null) {
                optsWithoutOffsetAndLimit.prefetchSize(opts.getPrefetchSize().intValue());
            }
        } else if (prefetchSize != null) {
            optsWithoutOffsetAndLimit = FetchOptions.Builder.withPrefetchSize((int)prefetchSize);
        }
        return optsWithoutOffsetAndLimit;
    }

    private void validateJoinQuery(QueryData qd, DatastoreQuery query, String joinSortProp) {
        for (Query.FilterPredicate fp : qd.primaryDatastoreQuery.getFilterPredicates()) {
            if (fp.getOperator() == Query.FilterOperator.EQUAL) continue;
            DatastoreQuery datastoreQuery = query;
            datastoreQuery.getClass();
            throw datastoreQuery.new DatastoreQuery.UnsupportedDatastoreFeatureException("Filter on property '" + fp.getPropertyName() + "' uses operator '" + fp.getOperator() + "'.  Joins are only supported when all filters are 'equals' filters.");
        }
        for (Query.FilterPredicate fp : qd.joinQuery.getFilterPredicates()) {
            if (fp.getOperator() == Query.FilterOperator.EQUAL) continue;
            DatastoreQuery datastoreQuery = query;
            datastoreQuery.getClass();
            throw datastoreQuery.new DatastoreQuery.UnsupportedDatastoreFeatureException("Filter on property '" + fp.getPropertyName() + "' uses operator '" + fp.getOperator() + "'.  Joins are only supported when all filters are 'equals' filters.");
        }
        List primarySorts = qd.primaryDatastoreQuery.getSortPredicates();
        if (!(primarySorts.size() <= 1 && qd.joinQuery.getSortPredicates().isEmpty() && (primarySorts.isEmpty() || ((Query.SortPredicate)primarySorts.get(0)).getPropertyName().equals(joinSortProp) && ((Query.SortPredicate)primarySorts.get(0)).getDirection() == Query.SortDirection.ASCENDING))) {
            DatastoreQuery datastoreQuery = query;
            datastoreQuery.getClass();
            throw datastoreQuery.new DatastoreQuery.UnsupportedDatastoreFeatureException("Joins can only be sorted by the join column in ascending order (in this case '" + joinSortProp + "')");
        }
    }

    Iterable<Entity> mergeJoin(String joinProperty, Iterable<Entity> parents, Iterator<Entity> childIter) {
        return new StreamingMergeJoinResult(new MergeJoinIterable(joinProperty, parents, childIter));
    }

    Set<Key> getMaterializedChildKeys() {
        return this.materializedChildKeys;
    }

    private static boolean sortAlreadyExists(String prop, Query.SortDirection dir, Query datastoreQuery) {
        for (Query.SortPredicate sp : datastoreQuery.getSortPredicates()) {
            if (!sp.getPropertyName().equals(prop) || sp.getDirection() != dir) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergeJoinIterable
    implements Iterable<Entity> {
        private final String joinProperty;
        private final Iterable<Entity> parents;
        private final Iterator<Entity> childIter;

        private MergeJoinIterable(String joinProperty, Iterable<Entity> parents, Iterator<Entity> childIter) {
            this.joinProperty = joinProperty;
            this.parents = parents;
            this.childIter = childIter;
        }

        @Override
        public Iterator<Entity> iterator() {
            return new AbstractIterator<Entity>(){
                private final Iterator<Entity> parentEntityIter;
                private Key curChildKey;
                {
                    this.parentEntityIter = MergeJoinIterable.this.parents.iterator();
                    this.curChildKey = null;
                }

                @Override
                protected Entity computeNext() {
                    while (this.parentEntityIter.hasNext()) {
                        ArrayList<Object> curJoinKeyList;
                        Entity curParentEntity = this.parentEntityIter.next();
                        Object propertyValue = curParentEntity.getProperty(MergeJoinIterable.this.joinProperty);
                        if (propertyValue == null) continue;
                        if (propertyValue instanceof Key) {
                            curJoinKeyList = Utils.newArrayList(propertyValue);
                        } else {
                            if (!(propertyValue instanceof List)) continue;
                            curJoinKeyList = (ArrayList<Object>)propertyValue;
                        }
                        for (Object e : curJoinKeyList) {
                            if (!(e instanceof Key)) continue;
                            Key joinKey = (Key)e;
                            while ((this.curChildKey == null || joinKey.compareTo(this.curChildKey) > 0) && MergeJoinIterable.this.childIter.hasNext()) {
                                this.curChildKey = ((Entity)MergeJoinIterable.this.childIter.next()).getKey();
                                JoinHelper.this.materializedChildKeys.add(this.curChildKey);
                            }
                            if (!JoinHelper.this.materializedChildKeys.contains(joinKey)) continue;
                            return curParentEntity;
                        }
                    }
                    this.endOfData();
                    return null;
                }
            };
        }
    }
}

