/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.SocketServicePb;
import java.net.InetAddress;

class AppEngineSocketUtils {
    private static final int IPV6_LEN = 16;
    private static final int IPV4_LEN = 4;

    static SocketServicePb.AddressPort toAddressPort(InetAddress address, int port) {
        return new SocketServicePb.AddressPort().setPort(port).setPackedAddressAsBytes(AppEngineSocketUtils.addrAsIpv6Bytes(address));
    }

    static byte[] addrAsIpv6Bytes(InetAddress address) {
        byte[] bytes = address.getAddress();
        if (bytes.length == 16) {
            return bytes;
        }
        if (bytes.length == 4) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, bytes[0], bytes[1], bytes[2], bytes[3]};
        }
        int n = bytes.length;
        throw new IllegalArgumentException(new StringBuilder(56).append("address must be IPV4 or IPV6 - unknown size: ").append(n).toString());
    }

    private AppEngineSocketUtils() {
    }
}

