/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigDecimals {
    public static final int MAX_PRECISION = 100;
    private static final int RADIX = 16;
    private static final int STORED_VALUE_SIZE = 84;
    static final int STRING_SIZE = 95;
    private static final BigInteger MAX_VALUE = BigDecimals.maxValue();
    private static final BigDecimal ZERO = new BigDecimal(0);

    private BigDecimals() {
    }

    private static BigInteger maxValue() {
        StringBuffer sb = new StringBuffer(85);
        sb.append('1');
        for (int i = 0; i < 84; ++i) {
            sb.append('0');
        }
        return new BigInteger(sb.toString(), 16);
    }

    public static BigDecimal fromSortableString(String sortFormattedString) {
        BigInteger value;
        if (sortFormattedString.length() != 95) {
            throw new IllegalArgumentException("Expected string of length: 95 but received one of " + sortFormattedString.length());
        }
        char sign = sortFormattedString.charAt(0);
        long scale = Long.parseLong(sortFormattedString.substring(2, 10), 16);
        if ('-' == sign) {
            value = MAX_VALUE.subtract(new BigInteger(sortFormattedString.substring(11), 16));
            value = value.negate();
        } else if ('_' == sign) {
            value = new BigInteger(sortFormattedString.substring(11), 16);
            scale = -scale;
        } else {
            throw new IllegalArgumentException("Corrupt BigDecimal string: " + sortFormattedString);
        }
        BigDecimal result = new BigDecimal(value, (int)scale);
        return result.stripTrailingZeros();
    }

    public static String toSortableString(BigDecimal number) {
        String value;
        StringBuffer sb = new StringBuffer(95);
        BigDecimals.checkScale(number);
        BigDecimal num = BigDecimals.canonicalize(number);
        int scale = num.scale();
        if (num.signum() == -1) {
            sb.append('-');
            if (scale > 0) {
                sb.append('-');
            } else {
                sb.append('+');
            }
            value = MAX_VALUE.subtract(num.unscaledValue().abs()).toString(16);
        } else {
            sb.append('_');
            if (scale > 0) {
                sb.append('-');
            } else {
                sb.append('_');
            }
            scale = -scale;
            value = num.unscaledValue().abs().toString(16);
        }
        sb.append(BigDecimals.getScaleString(scale));
        sb.append(',');
        for (int i = 0; i < 84 - value.length(); ++i) {
            sb.append('0');
        }
        sb.append(value);
        assert (sb.length() == 95);
        return sb.toString();
    }

    private static void checkScale(BigDecimal number) {
        if (number.precision() > 100) {
            throw new IllegalArgumentException("Requested to store number with: " + number.precision() + " decimals of precision which is more than the max of: " + 100);
        }
    }

    private static String getScaleString(int scale) {
        return String.format("%08x", scale);
    }

    private static BigDecimal canonicalize(BigDecimal number) {
        if (number.compareTo(ZERO) == 0) {
            return ZERO;
        }
        BigDecimal result = number.stripTrailingZeros();
        int addedPrecision = 100 - result.precision();
        if (addedPrecision > 0) {
            long newScale = (long)result.scale() + (long)addedPrecision;
            if (newScale > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Attempted to serialize an number with a scale of: " + number.scale() + " this is too close to Integer.MAX_VALUE to connicalized.");
            }
            return result.setScale((int)newScale);
        }
        return result;
    }
}

