/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.br;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.br.BrazilianStemmer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;
import java.util.Set;

public final class BrazilianStemFilter
extends TokenFilter {
    private BrazilianStemmer stemmer = new BrazilianStemmer();
    private Set exclusions = null;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);

    public BrazilianStemFilter(TokenStream in) {
        super(in);
    }

    public BrazilianStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.term();
            if (!(this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }
}

