/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ValueInterval;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.ValueOrder;
import javax.annotation.Nullable;

@AutoValue
public abstract class ValueInterval {
    public abstract ValueOrder valueOrder();

    public abstract Value startValue();

    public abstract boolean includeStart();

    @Nullable
    public abstract Value endValue();

    public abstract boolean includeEnd();

    public static ValueInterval create(ValueOrder valueOrder, Value startValue, boolean includeStart, @Nullable Value endValue, boolean includeEnd) {
        Preconditions.checkArgument((boolean)startValue.equals(valueOrder.canonicalizeValue(startValue)));
        Preconditions.checkArgument((endValue == null || endValue.equals(valueOrder.canonicalizeValue(endValue)) ? 1 : 0) != 0);
        int comparison = valueOrder.compare(startValue, endValue);
        Preconditions.checkArgument((comparison < 0 || comparison == 0 && includeStart && includeEnd ? 1 : 0) != 0);
        Preconditions.checkArgument((endValue != null || !includeEnd ? 1 : 0) != 0);
        return new AutoValue_ValueInterval(valueOrder, startValue, includeStart, endValue, includeEnd);
    }

    public boolean startsAtMin() {
        ValueOrder order = this.valueOrder();
        return this.includeStart() && order.compare(this.startValue(), order.minValue()) == 0;
    }

    @Nullable
    public Value uniqueValue() {
        if (!this.includeStart() || !this.includeEnd()) {
            return null;
        }
        Value startValue = this.startValue();
        if (this.valueOrder().compare(startValue, this.endValue()) != 0) {
            return null;
        }
        return startValue;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.includeStart() ? "[" : "(");
        stringBuilder.append(this.startValue());
        stringBuilder.append(", ");
        Value endValue = this.endValue();
        stringBuilder.append(endValue == null ? "<unbounded>" : this.endValue().toString());
        stringBuilder.append(this.includeEnd() ? "]" : ")");
        return stringBuilder.toString();
    }
}

