/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FacetRange;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FacetChecker;
import com.google.appengine.api.search.checkers.FacetQueryChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class FacetRequest {
    private final String name;
    private final ImmutableList<String> constraints;
    private final ImmutableList<FacetRange> ranges;
    private Integer valueLimit;

    private FacetRequest(Builder builder) {
        this.name = builder.name;
        this.constraints = ImmutableList.copyOf(builder.constraints);
        this.ranges = ImmutableList.copyOf(builder.ranges);
        this.valueLimit = builder.valueLimit;
        this.checkValid();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(FacetRequest request) {
        return new Builder(request);
    }

    public String getName() {
        return this.name;
    }

    public Integer getValueLimit() {
        return this.valueLimit;
    }

    public List<FacetRange> getRanges() {
        return this.ranges;
    }

    public List<String> getValueConstraints() {
        return this.constraints;
    }

    private void checkValid() {
        FacetChecker.checkFacetName(this.getName());
        Preconditions.checkState(this.constraints.size() < 50, "More than %s constraints.", 50);
        Preconditions.checkState(this.ranges.size() < 50, "More than %s ranges.", 50);
        Preconditions.checkState(this.constraints.isEmpty() || this.ranges.isEmpty(), "Constraints and ranges set for the same request.");
        for (String constraint : this.getValueConstraints()) {
            FacetQueryChecker.checkFacetValue(constraint);
        }
    }

    SearchServicePb.FacetRequest copyToProtocolBuffer() {
        if (this.constraints.isEmpty() && this.ranges.isEmpty() && this.valueLimit == null) {
            return SearchServicePb.FacetRequest.newBuilder().setName(this.name).build();
        }
        SearchServicePb.FacetRequestParam.Builder param = SearchServicePb.FacetRequestParam.newBuilder();
        for (String constraint : this.constraints) {
            param.addValueConstraint(constraint);
        }
        for (FacetRange range : this.ranges) {
            SearchServicePb.FacetRange.Builder rangePb = param.addRangeBuilder();
            if (range.getStart() != null) {
                rangePb.setStart(range.getStart());
            }
            if (range.getEnd() == null) continue;
            rangePb.setEnd(range.getEnd());
        }
        if (this.valueLimit != null) {
            param.setValueLimit(this.valueLimit);
        }
        return SearchServicePb.FacetRequest.newBuilder().setName(this.name).setParams(param.build()).build();
    }

    public String toString() {
        return new Util.ToStringHelper("FacetRequest").addField("name", this.name).addIterableField("valueConstraints", this.constraints).addIterableField("ranges", this.ranges).finish();
    }

    public static final class Builder {
        private String name;
        private List<String> constraints = new ArrayList<String>();
        private List<FacetRange> ranges = new ArrayList<FacetRange>();
        private Integer valueLimit;

        private Builder(FacetRequest request) {
            this.name = request.name;
            this.constraints = new ArrayList<String>(request.getValueConstraints());
            this.ranges = new ArrayList<FacetRange>(request.getRanges());
            this.valueLimit = request.getValueLimit();
        }

        private Builder() {
        }

        public Builder setValueLimit(int valueLimit) {
            this.valueLimit = FacetQueryChecker.checkValueLimit(valueLimit);
            return this;
        }

        public Builder setName(String name) {
            this.name = FacetChecker.checkFacetName(name);
            return this;
        }

        public Builder addValueConstraint(String constraint) {
            FacetQueryChecker.checkFacetValue(constraint);
            Preconditions.checkState(this.ranges.isEmpty(), "Ranges list should be empty.");
            Preconditions.checkState(this.constraints.size() < 50, "More than %s constraints.", 50);
            this.constraints.add(constraint);
            return this;
        }

        public Builder addRange(FacetRange range) {
            Preconditions.checkNotNull(range, "range should not be null.");
            Preconditions.checkState(this.constraints.isEmpty(), "Constraints list should be empty.");
            Preconditions.checkState(this.ranges.size() < 50, "More than %s ranges.", 50);
            this.ranges.add(range);
            return this;
        }

        public FacetRequest build() {
            return new FacetRequest(this);
        }
    }
}

