/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.mapping.NullMapping;

/**
 * Representation of a unknown literal in a Query.
 * This is a special literal with the sole purpose of representing a parameter where we don't currently
 * have the value and want to pre-compile the query to check for other errors. Simply provides
 * wrappers for operations that we would perform on a parameter value, and returns a valid expression.
 **/
public class UnknownLiteral extends NullLiteral
{
    /**
     * Creates an unknown literal.
     * @param qs the QueryExpression
     */
    public UnknownLiteral(QueryExpression qs)
    {
        super(qs);
        this.mapping = new NullMapping(qs.getStoreManager().getDatastoreAdapter());
        st.append("NULL");
    }

    public Object getValue()
    {
        return null;
    }

    public ScalarExpression add(ScalarExpression expr)
    {
        return expr;
    }

    public BooleanExpression eq(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression noteq(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression and(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public ScalarExpression div(ScalarExpression expr)
    {
        return expr;
    }

    public BooleanExpression gt(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression gteq(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression in(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression lt(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public BooleanExpression lteq(ScalarExpression expr)
    {
        return new BooleanLiteral(qs, mapping, true);
    }

    public ScalarExpression mod(ScalarExpression expr)
    {
        return expr;
    }

    public ScalarExpression mul(ScalarExpression expr)
    {
        return expr;
    }

    public ScalarExpression sub(ScalarExpression expr)
    {
        return expr;
    }
}