/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import javax.swing.Box;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Reflect;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;

final class DialogVisualPrefs
extends BaseXBack {
    private final GUI gui;
    private final BaseXCheckBox scrollTabs;
    private final BaseXTextField labels;
    private final BaseXCheckBox treeSlims;
    private final BaseXCheckBox treeAtts;
    private final BaseXCombo mapAlgo;
    private final BaseXSlider mapWeight;
    private final BaseXCheckBox mapAtts;
    private final BaseXCheckBox mousefocus;
    private final BaseXCombo mapOffsets;
    private final BaseXCombo lookfeel;
    private final StringList classes = new StringList();
    private static final String[] LOOKANDFEELS = new String[]{"com.jtattoo.plaf.acryl.AcrylLookAndFeel", "com.jtattoo.plaf.aero.AeroLookAndFeel", "com.jtattoo.plaf.aluminium.AluminiumLookAndFeel", "com.jtattoo.plaf.bernstein.BernsteinLookAndFeel", "com.jtattoo.plaf.fast.FastLookAndFeel", "com.jtattoo.plaf.graphite.GraphiteLookAndFeel", "com.jtattoo.plaf.hifi.HiFiLookAndFeel", "com.jtattoo.plaf.luna.LunaLookAndFeel", "com.jtattoo.plaf.mcwin.McWinLookAndFeel", "com.jtattoo.plaf.mint.MintLookAndFeel", "com.jtattoo.plaf.noire.NoireLookAndFeel", "com.jtattoo.plaf.smart.SmartLookAndFeel", "com.jtattoo.plaf.texture.TextureLookAndFeel"};

    DialogVisualPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new ColumnLayout(40));
        this.gui = dialog.gui();
        GUIOptions gopts = this.gui.gopts;
        this.scrollTabs = new BaseXCheckBox(dialog, Text.SCROLL_TABS, GUIOptions.SCROLLTABS, gopts);
        this.labels = new BaseXTextField(dialog, GUIOptions.LABELS, (Options)gopts);
        this.mousefocus = new BaseXCheckBox(dialog, Text.RT_FOCUS, GUIOptions.MOUSEFOCUS, gopts);
        this.treeSlims = new BaseXCheckBox(dialog, Text.ADJUST_NODES, GUIOptions.TREESLIMS, gopts);
        this.treeAtts = new BaseXCheckBox(dialog, Text.SHOW_ATTS, GUIOptions.TREEATTS, gopts);
        this.mapAlgo = new BaseXCombo((BaseXWindow)dialog, GUIOptions.MAPALGO, (Options)gopts, Text.MAP_LAYOUTS);
        this.mapOffsets = new BaseXCombo((BaseXWindow)dialog, GUIOptions.MAPOFFSETS, (Options)gopts, Text.MAP_CHOICES);
        this.mapWeight = new BaseXSlider(dialog, 0, 100, GUIOptions.MAPWEIGHT, gopts);
        this.mapAtts = new BaseXCheckBox(dialog, Text.SHOW_ATTS, GUIOptions.MAPATTS, gopts);
        this.mapAlgo.setSize(200, 100);
        this.labels.setColumns(18);
        BaseXLayout.setWidth(this.mapWeight, 150);
        StringList lafs = new StringList("(default)");
        this.classes.add("");
        int i = 0;
        int c = 0;
        String laf = gopts.get(GUIOptions.LOOKANDFEEL);
        for (String clzz : DialogVisualPrefs.lf()) {
            lafs.add(clzz.replaceAll("^.*\\.|LookAndFeel$", ""));
            this.classes.add(clzz);
            ++c;
            if (!clzz.equals(laf)) continue;
            i = c;
        }
        this.lookfeel = new BaseXCombo((BaseXWindow)dialog, (String[])lafs.finish());
        this.lookfeel.setSelectedIndex(i);
        BaseXBack p = new BaseXBack().layout(new RowLayout(8));
        BaseXBack pp = new BaseXBack(new RowLayout());
        pp.add(new BaseXLabel(Text.JAVA_LF + ":", true, true));
        pp.add(this.lookfeel);
        pp.add(Box.createVerticalStrut(8));
        pp.add(this.scrollTabs);
        p.add(pp);
        pp = new BaseXBack(new RowLayout());
        pp.add(new BaseXLabel(Text.GENERAL + ":", true, true));
        pp.add(this.mousefocus);
        p.add(pp);
        pp = new BaseXBack(new RowLayout());
        pp.add(new BaseXLabel(Text.LABEL_ATTS + ":", true, true));
        pp.add(this.labels);
        p.add(pp);
        this.add(p);
        p = new BaseXBack(new RowLayout());
        p.add(new BaseXLabel(Text.MAP + ":", true, true));
        pp = new BaseXBack(new TableLayout(2, 2, 8, 8));
        pp.add(new BaseXLabel(Text.ALGORITHM + ":"));
        pp.add(this.mapAlgo);
        pp.add(new BaseXLabel(Text.OFFSETS + ":"));
        pp.add(this.mapOffsets);
        p.add(pp);
        pp = new BaseXBack(new RowLayout(8));
        pp.add(new BaseXLabel(Text.RATIO + ": "));
        pp.add(this.mapWeight);
        pp.add(this.mapAtts);
        p.add(pp);
        pp = new BaseXBack(new RowLayout());
        pp.add(new BaseXLabel(Text.TREE + ":", true, true));
        pp.add(this.treeSlims);
        pp.add(this.treeAtts);
        p.add(pp);
        this.add(p);
    }

    boolean action() {
        this.mousefocus.assign();
        this.treeSlims.assign();
        this.treeAtts.assign();
        this.mapAtts.assign();
        this.scrollTabs.assign();
        this.labels.assign();
        this.mapWeight.assign();
        this.mapAlgo.assign();
        this.mapOffsets.assign();
        this.gui.gopts.set(GUIOptions.LOOKANDFEEL, (String)this.classes.get(this.lookfeel.getSelectedIndex()));
        return true;
    }

    private static StringList lf() {
        StringList sl = new StringList();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            sl.add(lookAndFeelInfo.getClassName());
        }
        for (String string : LOOKANDFEELS) {
            if (Reflect.find(string) == null) continue;
            sl.add(string);
        }
        return sl;
    }
}

