/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QuerySupplier;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.AFunction;
import org.basex.query.func.Function;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.Scope;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Checks;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjectMap;

public final class CompileContext {
    private static final int MAX_PREEVAL = 262144;
    public final QueryContext qc;
    public final boolean dynamic;
    public final ArrayDeque<XQFunctionExpr> inlined = new ArrayDeque();
    private final ArrayDeque<VarScope> scopes = new ArrayDeque();
    private final ArrayDeque<QueryFocus> focuses = new ArrayDeque();

    public CompileContext(QueryContext qc, boolean dynamic) {
        this.qc = qc;
        this.dynamic = dynamic;
    }

    public void info(String string, Object ... ext) {
        if (this.qc.parent == null) {
            this.qc.info.compInfo(this.dynamic, string, ext);
        }
    }

    public void pushScope(VarScope vs) {
        this.scopes.add(vs);
    }

    public VarScope removeScope() {
        return this.scopes.removeLast();
    }

    public void removeScope(Scope scope) {
        this.removeScope().cleanUp(scope);
    }

    public void pushFocus(Expr expr, boolean item) {
        this.focuses.add(this.qc.focus);
        QueryFocus qf = new QueryFocus();
        if (expr != null) {
            qf.value = new Dummy(expr, item);
        }
        this.qc.focus = qf;
    }

    public void updateFocus(Expr expr, boolean item) {
        this.qc.focus.value = new Dummy(expr, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr get(Expr expr, boolean item, QuerySupplier<Expr> func) throws QueryException {
        this.pushFocus(expr, item);
        try {
            Expr expr2 = func.get();
            return expr2;
        }
        finally {
            this.removeFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ok(Expr expr, boolean item, QuerySupplier<Boolean> func) throws QueryException {
        this.pushFocus(expr, item);
        try {
            boolean bl = func.get();
            return bl;
        }
        finally {
            this.removeFocus();
        }
    }

    public void removeFocus() {
        this.qc.focus = this.focuses.pollLast();
    }

    public boolean nestedFocus() {
        return !this.focuses.isEmpty();
    }

    public VarScope vs() {
        return this.scopes.getLast();
    }

    public Var copy(Var var, IntObjectMap<Var> vm) {
        if (var == null) {
            return null;
        }
        VarScope vs = this.vs();
        Var vr = vs.add(new Var(var, this.qc));
        if (vm != null) {
            vm.put(var.id, vr);
        }
        return vr;
    }

    public Value preEval(Expr expr) throws QueryException {
        return (Value)this.replaceWith(expr, expr.value(this.qc));
    }

    public Expr emptySeq(Expr expr) {
        return this.replaceWith(expr, Empty.VALUE, false);
    }

    public Expr simplify(Expr expr, Expr result, Simplify mode) throws QueryException {
        return result != expr ? this.replaceWith(expr, result, false).simplifyFor(mode, this) : result.simplify(mode, this);
    }

    public Expr replaceWith(Expr expr, Expr result) {
        return this.replaceWith(expr, result, true);
    }

    private Expr replaceWith(Expr expr, Expr result, boolean refine) {
        if (result != expr) {
            this.info("%", () -> {
                String exprDesc = expr.description();
                String resDesc = result.description();
                byte[] exprString = QueryError.normalize(expr, null);
                byte[] resString = QueryError.normalize(result, null);
                boolean eqDesc = exprDesc.equals(resDesc);
                boolean eqString = Token.eq(exprString, resString);
                TokenBuilder tb = new TokenBuilder();
                tb.add("rewrite").add(32).add(exprDesc);
                if (eqString && !eqDesc) {
                    tb.add(" to ").add(resDesc);
                }
                tb.add(": ").add(exprString);
                if (!eqString) {
                    tb.add(" -> ").add(resString);
                }
                return tb.toString();
            });
            if (refine) {
                result.refineType(expr);
            }
        }
        return result;
    }

    public Expr compileOrError(Expr expr, boolean error) throws QueryException {
        try {
            return expr.compile(this);
        }
        catch (QueryException ex) {
            if (error) {
                throw ex;
            }
            return FnError.get(ex, expr);
        }
    }

    public Expr function(AFunction function, InputInfo info, Expr ... exprs) throws QueryException {
        return function.get(info, exprs).optimize(this);
    }

    public Expr voidAndReturn(Expr expr, Expr result, InputInfo info) throws QueryException {
        return List.get(this, info, this.function(Function.VOID, info, expr, Bln.TRUE), result);
    }

    public Expr replicate(Expr expr, Expr count, InputInfo info) throws QueryException {
        ExprList args = (ExprList)((Object)((ExprList)((Object)new ExprList().add(expr))).add(count));
        if (expr.has(Flag.NDT, Flag.CNS)) {
            args.add(Bln.TRUE);
        }
        return this.function(Function.REPLICATE, info, (Expr[])args.finish());
    }

    /*
     * Unable to fully structure code
     */
    public ExprList unroll(Expr expr, boolean single) {
        block5: {
            block4: {
                size = expr.size();
                limit = this.qc.context.options.get(MainOptions.UNROLLLIMIT).intValue();
                if (!single || size != 1L) break block4;
                add = (Consumer<ExprList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$unroll$1(org.basex.query.expr.Expr org.basex.query.util.list.ExprList ), (Lorg/basex/query/util/list/ExprList;)V)((Expr)expr);
                break block5;
            }
            if (!(expr instanceof Seq)) ** GOTO lbl-1000
            seq = (Seq)expr;
            if (size <= limit) {
                add = (Consumer<ExprList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$unroll$2(org.basex.query.value.seq.Seq org.basex.query.util.list.ExprList ), (Lorg/basex/query/util/list/ExprList;)V)((Seq)seq);
            } else if (expr instanceof List && (single != false ? size <= limit && (Checks<Expr>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$unroll$3(org.basex.query.expr.Expr ), (Lorg/basex/query/expr/Expr;)Z)().all((Expr[])expr.args()) != false : (long)expr.args().length <= limit)) {
                add = (Consumer<ExprList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$unroll$4(org.basex.query.expr.Expr org.basex.query.util.list.ExprList ), (Lorg/basex/query/util/list/ExprList;)V)((Expr)expr);
            } else {
                return null;
            }
        }
        this.info("unroll: %", new Object[]{expr});
        exprs = new ExprList();
        add.accept(exprs);
        return exprs;
    }

    public boolean values(boolean limit, Expr ... exprs) {
        for (Expr expr : exprs) {
            if (expr instanceof Value && (!limit || !this.largeResult(expr))) continue;
            return false;
        }
        return true;
    }

    public boolean largeResult(Expr expr) {
        return expr.size() > 262144L;
    }

    private static /* synthetic */ void lambda$unroll$4(Expr expr, ExprList exprs) {
        for (Expr ex : expr.args()) {
            exprs.add(ex);
        }
    }

    private static /* synthetic */ boolean lambda$unroll$3(Expr ex) {
        return ex.seqType().one();
    }

    private static /* synthetic */ void lambda$unroll$2(Seq seq, ExprList exprs) {
        for (Item item : seq) {
            exprs.add(item);
        }
    }

    private static /* synthetic */ void lambda$unroll$1(Expr expr, ExprList exprs) {
        exprs.add(expr);
    }

    public static enum Simplify {
        EBV,
        DATA,
        STRING,
        NUMBER,
        PREDICATE,
        DISTINCT,
        COUNT;


        public boolean oneOf(Simplify ... candidates) {
            return Enums.oneOf((Enum)this, (Enum[])candidates);
        }
    }
}

