/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ConstructorCallExpression
extends Expression {
    private String type;
    private Expression arguments;

    public ConstructorCallExpression(String type, Expression arguments) {
        this.type = type;
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstructorCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ConstructorCallExpression(this.type, transformer.transform(this.arguments));
    }

    public String getType() {
        if (this.type == null) {
            return "java.lang.Object";
        }
        return this.type;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getText() {
        return "new " + this.type + "(" + this.arguments.getText() + ")";
    }

    public String toString() {
        return super.toString() + "[type: " + this.type + " arguments: " + this.arguments + "]";
    }
}

