/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.Range;
import groovy.lang.Tuple;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.MethodClosure;

public class Invoker {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final Class[] EMPTY_TYPES = new Class[0];
    private MetaClassRegistry metaRegistry = new MetaClassRegistry();

    public MetaClass getMetaClass(Object object) {
        return this.metaRegistry.getMetaClass(object.getClass());
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject groovy = (GroovyObject)object;
            return groovy.invokeMethod(methodName, arguments);
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, this.asArray(arguments));
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
        return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeStaticMethod(String type, String method, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(this.loadClass(type));
        List argumentList = this.asList(arguments);
        return metaClass.invokeStaticMethod(null, method, this.asArray(arguments));
    }

    public Object invokeConstructor(String type, Object arguments) {
        return this.invokeConstructorOf(this.loadClass(type), arguments);
    }

    public Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(this.asArray(arguments));
    }

    public Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public List asList(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof Enumeration) {
            ArrayList answer = new ArrayList();
            Enumeration e = (Enumeration)value;
            while (e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value);
    }

    public Collection asCollection(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet();
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return InvokerHelper.primitiveArrayToList(value);
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof MethodClosure) {
            MethodClosure method = (MethodClosure)value;
            IteratorClosureAdapter adapter = new IteratorClosureAdapter(method.getDelegate());
            method.call(adapter);
            return adapter.asList();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.toList((String)value);
        }
        if (value instanceof File) {
            try {
                return DefaultGroovyMethods.readLines((File)value);
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Error reading file: " + value, e);
            }
        }
        return Collections.singletonList(value);
    }

    public Iterator asIterator(Object value) {
        if (value == null) {
            Collections.EMPTY_LIST.iterator();
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Enumeration) {
            final Enumeration enumeration = (Enumeration)value;
            return new Iterator(){
                private Object last;

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    this.last = enumeration.nextElement();
                    return this.last;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove() from an Enumeration");
                }
            };
        }
        if (value instanceof Matcher) {
            final Matcher matcher = (Matcher)value;
            return new Iterator(){
                private boolean found = false;
                private boolean done = false;

                public boolean hasNext() {
                    if (this.done) {
                        return false;
                    }
                    if (!this.found) {
                        this.found = matcher.find();
                        if (!this.found) {
                            this.done = true;
                        }
                    }
                    return this.found;
                }

                public Object next() {
                    if (!this.found && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.found = false;
                    return matcher.group();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        try {
            Method method = value.getClass().getMethod("iterator", EMPTY_TYPES);
            if (method != null) {
                return (Iterator)method.invoke(value, EMPTY_ARGUMENTS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.asCollection(value).iterator();
    }

    public boolean objectsEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left != null) {
            if (right == null) {
                return false;
            }
            if (left instanceof Comparable) {
                return this.compareTo(left, right) == 0;
            }
            return left.equals(right);
        }
        return false;
    }

    public String inspect(Object self) {
        return this.format(self, true);
    }

    public int compareTo(Object left, Object right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof Comparable) {
            if (left instanceof Number) {
                if (this.isValidCharacterString(right)) {
                    return this.asCharacter((Number)left).compareTo(this.asCharacter((String)right));
                }
                return DefaultGroovyMethods.compareTo((Number)left, this.asNumber(right));
            }
            if (left instanceof Character) {
                if (this.isValidCharacterString(right)) {
                    return ((Character)left).compareTo(this.asCharacter((String)right));
                }
                if (right instanceof Number) {
                    return ((Character)left).compareTo(this.asCharacter((Number)right));
                }
            } else {
                if (right instanceof Number) {
                    if (this.isValidCharacterString(left)) {
                        return this.asCharacter((String)left).compareTo(this.asCharacter((Number)right));
                    }
                    return DefaultGroovyMethods.compareTo(this.asNumber(left), (Number)right);
                }
                if (left instanceof String && right instanceof Character) {
                    return ((String)left).compareTo(right.toString());
                }
            }
            Comparable comparable = (Comparable)left;
            return comparable.compareTo(right);
        }
        if (left.getClass().isArray()) {
            Collection leftList = this.asCollection(left);
            if (right.getClass().isArray()) {
                right = this.asCollection(right);
            }
            return ((Comparable)((Object)leftList)).compareTo(right);
        }
        throw new GroovyRuntimeException("Cannot compare values: " + left + " and " + right);
    }

    public String toString(Object arguments) {
        return this.format(arguments, false);
    }

    protected String format(Object arguments, boolean verbose) {
        if (arguments == null) {
            return "null";
        }
        if (arguments.getClass().isArray()) {
            return this.format(this.asCollection(arguments), verbose);
        }
        if (arguments instanceof Range) {
            Range range = (Range)arguments;
            if (verbose) {
                return range.inspect();
            }
            return range.toString();
        }
        if (arguments instanceof List) {
            List list = (List)arguments;
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(this.format(iter.next(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Map) {
            Map map = (Map)arguments;
            if (map.isEmpty()) {
                return "[:]";
            }
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                Map.Entry entry = iter.next();
                buffer.append(this.format(entry.getKey(), verbose));
                buffer.append(":");
                buffer.append(this.format(entry.getValue(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof String) {
            if (verbose) {
                return "\"" + arguments + "\"";
            }
            return (String)arguments;
        }
        return arguments.toString();
    }

    public void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            throw new GroovyRuntimeException("Cannot set property on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.put(property, newValue);
        } else {
            this.metaRegistry.getMetaClass(object.getClass()).setProperty(object, property, newValue);
        }
    }

    public Object getProperty(Object object, String property) {
        if (object == null) {
            throw new NullPointerException("Cannot get property: " + property + " on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(property);
        }
        return this.metaRegistry.getMetaClass(object.getClass()).getProperty(object, property);
    }

    public int asInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        throw new GroovyRuntimeException("Could not convert object: " + value + " into an int");
    }

    public Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() == 1) {
                return new Integer(s.charAt(0));
            }
            return Double.valueOf(s);
        }
        if (value instanceof Character) {
            return new Integer(((Character)value).charValue());
        }
        throw new GroovyRuntimeException("Could not convert object: " + value + " into a Number");
    }

    protected Class loadClass(String type) {
        try {
            return this.getClass().getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return Class.forName(type);
                }
                catch (ClassNotFoundException e3) {
                    throw new GroovyRuntimeException("Could not load type: " + type, e);
                }
            }
        }
    }

    public Matcher objectFindRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : this.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = this.toString(right);
        }
        Matcher matcher = Pattern.compile(regexToCompareTo).matcher(stringToCompare);
        return matcher;
    }

    public boolean objectMatchRegex(Object left, Object right) {
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(this.toString(right));
        String stringToCompare = this.toString(left);
        return pattern.matcher(stringToCompare).matches();
    }

    public Pattern regexPattern(String regex) {
        return Pattern.compile(regex);
    }

    public Object asType(Object object, Class type) {
        if (object == null) {
            return null;
        }
        if (type.isInstance(object)) {
            return object;
        }
        if (type.equals(String.class)) {
            return object.toString();
        }
        if (type.equals(Character.class)) {
            if (object instanceof Number) {
                return this.asCharacter((Number)object);
            }
            String text = object.toString();
            if (text.length() == 1) {
                return new Character(text.charAt(0));
            }
            throw new ClassCastException("Cannot cast: " + text + " to a Character");
        }
        if (Number.class.isAssignableFrom(type)) {
            if (object instanceof Character) {
                return new Integer(((Character)object).charValue());
            }
            if (object instanceof String) {
                String c = (String)object;
                if (c.length() == 1) {
                    return new Integer(c.charAt(0));
                }
                throw new ClassCastException("Cannot cast: '" + c + "' to an Integer");
            }
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            if (type.isPrimitive()) {
                if (type == Byte.TYPE) {
                    return new Byte(n.byteValue());
                }
                if (type == Character.TYPE) {
                    return new Character((char)n.intValue());
                }
                if (type == Short.TYPE) {
                    return new Short(n.shortValue());
                }
                if (type == Integer.TYPE) {
                    return new Integer(n.intValue());
                }
                if (type == Long.TYPE) {
                    return new Long(n.longValue());
                }
                if (type == Float.TYPE) {
                    return new Float(n.floatValue());
                }
                if (type == Double.TYPE) {
                    return new Double(n.doubleValue());
                }
            } else if (Number.class.isAssignableFrom(type)) {
                if (type == Byte.class) {
                    return new Byte(n.byteValue());
                }
                if (type == Character.class) {
                    return new Character((char)n.intValue());
                }
                if (type == Short.class) {
                    return new Short(n.shortValue());
                }
                if (type == Integer.class) {
                    return new Integer(n.intValue());
                }
                if (type == Long.class) {
                    return new Long(n.longValue());
                }
                if (type == Float.class) {
                    return new Float(n.floatValue());
                }
                if (type == Double.class) {
                    return new Double(n.doubleValue());
                }
            }
        }
        if (type == Boolean.class) {
            return this.asBool(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        return object;
    }

    public boolean asBool(Object object) {
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        if (object instanceof Matcher) {
            Matcher matcher = (Matcher)object;
            return matcher.find();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return !collection.isEmpty();
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.intValue() != 0;
        }
        return object != null;
    }

    protected Character asCharacter(Number value) {
        return new Character((char)value.intValue());
    }

    protected Character asCharacter(String text) {
        return new Character(text.charAt(0));
    }

    protected boolean isValidCharacterString(Object value) {
        String s;
        return value instanceof String && (s = (String)value).length() == 1;
    }
}

