/*
     File:       TreeNode.h
 
     Contains:   Generic Tree node and data structures (TreeNode, and TreeNodeData).
 
                 TreeNode is a node in a doubly linked tree data structure. 
                 TreeNode's have weak references to their parent (to avoid retain
                 cycles since parents retain their children).  Each node has 0 or
                 more children and a reference to a piece of TreeNodeData data.  
                 The TreeNode provides method to manipulate and extract structural
                 information about a tree.  For instance, TreeNode implements:
                 insertChild:atIndex:, removeChild:, isDescendantOfNode:, and other
                 useful operations on tree nodes. TreeNode and TreeNodeData provide
                 the structure and KWCommonMethods functionality of trees, and are expected
                 to be subclassed.
                 
     Version:    Technology: Mac OS X
                 Release:    Mac OS X
 
     Copyright:  (c) 2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://developer.apple.com/bugreporter/
*/

/*
 IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc. ("Apple") in
 consideration of your agreement to the following terms, and your use, installation, 
 modification or redistribution of this Apple software constitutes acceptance of these 
 terms.  If you do not agree with these terms, please do not use, install, modify or 
 redistribute this Apple software.
 
 In consideration of your agreement to abide by the following terms, and subject to these 
 terms, Apple grants you a personal, non-exclusive license, under Apple’s copyrights in 
 this original Apple software (the "Apple Software"), to use, reproduce, modify and 
 redistribute the Apple Software, with or without modifications, in source and/or binary 
 forms; provided that if you redistribute the Apple Software in its entirety and without 
 modifications, you must retain this notice and the following text and disclaimers in all 
 such redistributions of the Apple Software.  Neither the name, trademarks, service marks 
 or logos of Apple Computer, Inc. may be used to endorse or promote products derived from 
 the Apple Software without specific prior written permission from Apple. Except as expressly
 stated in this notice, no other rights or licenses, express or implied, are granted by Apple
 herein, including but not limited to any patent rights that may be infringed by your 
 derivative works or by other works in which the Apple Software may be incorporated.
 
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO WARRANTIES, 
 EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS 
 USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL 
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
 OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, 
 REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND 
 WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR 
 OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import "KWCommonMethods.h"

@interface TreeNodeData : NSObject 

- (NSComparisonResult)compare:(TreeNodeData*)other;
- (void)setName:(NSString*)name;
- (NSString*) name;
- (NSImage*) icon;
- (NSString*) kind;
- (BOOL) isExpandable;

@end

typedef enum _TNSortOrder
{
	TNSortOrderNormal,
	TNSortOrderReverse
} TNSortOrder;

@interface TreeNode : NSObject 
{
    TreeNode		*nodeParent;
    TreeNodeData	*nodeData;
    NSMutableArray	*nodeChildren;
	TNSortOrder		sortOrder;
}

+ (id) treeNodeWithData:(TreeNodeData*)data;
- (id) initWithData:(TreeNodeData*)data parent:(TreeNode*)parent;

- (void)setNodeData:(TreeNodeData*)data;
- (TreeNodeData*) nodeData;

- (TreeNode*) nodeParent;

- (void)addChild:(TreeNode*)child;
- (void)addChildren:(NSArray*)children;
- (void)removeChild:(TreeNode*)child;
- (void)removeFromParent;

- (NSInteger) indexOfChild:(TreeNode*)child;
- (NSInteger) indexOfChildIdenticalTo:(TreeNode*)child;

- (NSInteger) numberOfChildren;
- (NSArray*) children;
- (TreeNode*) firstChild;
- (TreeNode*) lastChild;
- (TreeNode*) childAtIndex:(NSInteger)index;

- (BOOL) isDescendantOfNode:(TreeNode*)node;
    // returns YES if 'node' is an ancestor.

- (BOOL) isDescendantOfNodeInArray:(NSArray*)nodes;
    // returns YES if any 'node' in the array 'nodes' is an ancestor of ours.

- (void)setSortOrder:(TNSortOrder)order;
- (TNSortOrder) sortOrder;

- (void)recursiveSortChildren;
    // sort children using the compare: method in TreeNodeData

// Returns the minimum nodes from 'allNodes' required to cover the nodes in 'allNodes'.
// This methods returns an array containing nodes from 'allNodes' such that no node in
// the returned array has an ancestor in the returned array.
+ (NSArray *) minimumNodeCoverFromNodesInArray:(NSArray *)allNodes;

@end