! Copyright (C) 2005, 2006 Doug Coleman.
! See http://factorcode.org/license.txt for BSD license.
USING: alien alien.c-types alien.syntax parser namespaces
kernel math windows.types generalizations math.bitwise
classes.struct literals windows.kernel32 system accessors ;
IN: windows.user32

! HKL for ActivateKeyboardLayout
CONSTANT: HKL_PREV 0
CONSTANT: HKL_NEXT 1

CONSTANT: CW_USEDEFAULT 0x80000000

CONSTANT: WS_OVERLAPPED       0x00000000
CONSTANT: WS_POPUP            0x80000000
CONSTANT: WS_CHILD            0x40000000
CONSTANT: WS_MINIMIZE         0x20000000
CONSTANT: WS_VISIBLE          0x10000000
CONSTANT: WS_DISABLED         0x08000000
CONSTANT: WS_CLIPSIBLINGS     0x04000000
CONSTANT: WS_CLIPCHILDREN     0x02000000
CONSTANT: WS_MAXIMIZE         0x01000000
CONSTANT: WS_CAPTION          0x00C00000
CONSTANT: WS_BORDER           0x00800000
CONSTANT: WS_DLGFRAME         0x00400000
CONSTANT: WS_VSCROLL          0x00200000
CONSTANT: WS_HSCROLL          0x00100000
CONSTANT: WS_SYSMENU          0x00080000
CONSTANT: WS_THICKFRAME       0x00040000
CONSTANT: WS_GROUP            0x00020000
CONSTANT: WS_TABSTOP          0x00010000
CONSTANT: WS_MINIMIZEBOX      0x00020000
CONSTANT: WS_MAXIMIZEBOX      0x00010000

! Common window styles
CONSTANT: WS_OVERLAPPEDWINDOW
    flags{
        WS_OVERLAPPED
        WS_CAPTION
        WS_SYSMENU
        WS_THICKFRAME
        WS_MINIMIZEBOX
        WS_MAXIMIZEBOX
    }

CONSTANT: WS_POPUPWINDOW flags{ WS_POPUP WS_BORDER WS_SYSMENU }

ALIAS: WS_CHILDWINDOW      WS_CHILD

ALIAS: WS_TILED            WS_OVERLAPPED
ALIAS: WS_ICONIC           WS_MINIMIZE
ALIAS: WS_SIZEBOX          WS_THICKFRAME
ALIAS: WS_TILEDWINDOW WS_OVERLAPPEDWINDOW

! Extended window styles

CONSTANT: WS_EX_DLGMODALFRAME     0x00000001
CONSTANT: WS_EX_NOPARENTNOTIFY    0x00000004
CONSTANT: WS_EX_TOPMOST           0x00000008
CONSTANT: WS_EX_ACCEPTFILES       0x00000010
CONSTANT: WS_EX_TRANSPARENT       0x00000020
CONSTANT: WS_EX_MDICHILD          0x00000040
CONSTANT: WS_EX_TOOLWINDOW        0x00000080
CONSTANT: WS_EX_WINDOWEDGE        0x00000100
CONSTANT: WS_EX_CLIENTEDGE        0x00000200
CONSTANT: WS_EX_CONTEXTHELP       0x00000400

CONSTANT: WS_EX_RIGHT             0x00001000
CONSTANT: WS_EX_LEFT              0x00000000
CONSTANT: WS_EX_RTLREADING        0x00002000
CONSTANT: WS_EX_LTRREADING        0x00000000
CONSTANT: WS_EX_LEFTSCROLLBAR     0x00004000
CONSTANT: WS_EX_RIGHTSCROLLBAR    0x00000000
CONSTANT: WS_EX_CONTROLPARENT     0x00010000
CONSTANT: WS_EX_STATICEDGE        0x00020000
CONSTANT: WS_EX_APPWINDOW         0x00040000

CONSTANT: WS_EX_OVERLAPPEDWINDOW
    flags{ WS_EX_WINDOWEDGE WS_EX_CLIENTEDGE }

CONSTANT: WS_EX_PALETTEWINDOW 
    flags{ WS_EX_WINDOWEDGE WS_EX_TOOLWINDOW WS_EX_TOPMOST }

CONSTANT: CS_VREDRAW          0x0001
CONSTANT: CS_HREDRAW          0x0002
CONSTANT: CS_DBLCLKS          0x0008
CONSTANT: CS_OWNDC            0x0020
CONSTANT: CS_CLASSDC          0x0040
CONSTANT: CS_PARENTDC         0x0080
CONSTANT: CS_NOCLOSE          0x0200
CONSTANT: CS_SAVEBITS         0x0800
CONSTANT: CS_BYTEALIGNCLIENT  0x1000
CONSTANT: CS_BYTEALIGNWINDOW  0x2000
CONSTANT: CS_GLOBALCLASS      0x4000

CONSTANT: COLOR_SCROLLBAR         0
CONSTANT: COLOR_BACKGROUND        1
CONSTANT: COLOR_ACTIVECAPTION     2
CONSTANT: COLOR_INACTIVECAPTION   3
CONSTANT: COLOR_MENU              4
CONSTANT: COLOR_WINDOW            5
CONSTANT: COLOR_WINDOWFRAME       6
CONSTANT: COLOR_MENUTEXT          7
CONSTANT: COLOR_WINDOWTEXT        8
CONSTANT: COLOR_CAPTIONTEXT       9
CONSTANT: COLOR_ACTIVEBORDER      10
CONSTANT: COLOR_INACTIVEBORDER    11
CONSTANT: COLOR_APPWORKSPACE      12
CONSTANT: COLOR_HIGHLIGHT         13
CONSTANT: COLOR_HIGHLIGHTTEXT     14
CONSTANT: COLOR_BTNFACE           15
CONSTANT: COLOR_BTNSHADOW         16
CONSTANT: COLOR_GRAYTEXT          17
CONSTANT: COLOR_BTNTEXT           18
CONSTANT: COLOR_INACTIVECAPTIONTEXT 19
CONSTANT: COLOR_BTNHIGHLIGHT      20

CONSTANT: IDI_APPLICATION     32512
CONSTANT: IDI_HAND            32513
CONSTANT: IDI_QUESTION        32514
CONSTANT: IDI_EXCLAMATION     32515
CONSTANT: IDI_ASTERISK        32516
CONSTANT: IDI_WINLOGO         32517

! ShowWindow() Commands
CONSTANT: SW_HIDE             0
CONSTANT: SW_SHOWNORMAL       1
CONSTANT: SW_NORMAL           1
CONSTANT: SW_SHOWMINIMIZED    2
CONSTANT: SW_SHOWMAXIMIZED    3
CONSTANT: SW_MAXIMIZE         3
CONSTANT: SW_SHOWNOACTIVATE   4
CONSTANT: SW_SHOW             5
CONSTANT: SW_MINIMIZE         6
CONSTANT: SW_SHOWMINNOACTIVE  7
CONSTANT: SW_SHOWNA           8
CONSTANT: SW_RESTORE          9
CONSTANT: SW_SHOWDEFAULT      10
CONSTANT: SW_FORCEMINIMIZE    11
CONSTANT: SW_MAX              11

! PeekMessage
CONSTANT: PM_NOREMOVE   0
CONSTANT: PM_REMOVE     1
CONSTANT: PM_NOYIELD    2
! : PM_QS_INPUT         (QS_INPUT << 16) ;
! : PM_QS_POSTMESSAGE   ((QS_POSTMESSAGE | QS_HOTKEY | QS_TIMER) << 16) ;
! : PM_QS_PAINT         (QS_PAINT << 16) ;
! : PM_QS_SENDMESSAGE   (QS_SENDMESSAGE << 16) ;


! 
! Standard Cursor IDs
!
CONSTANT: IDC_ARROW           32512
CONSTANT: IDC_IBEAM           32513
CONSTANT: IDC_WAIT            32514
CONSTANT: IDC_CROSS           32515
CONSTANT: IDC_UPARROW         32516
CONSTANT: IDC_SIZE            32640 ! OBSOLETE: use IDC_SIZEALL
CONSTANT: IDC_ICON            32641 ! OBSOLETE: use IDC_ARROW
CONSTANT: IDC_SIZENWSE        32642
CONSTANT: IDC_SIZENESW        32643
CONSTANT: IDC_SIZEWE          32644
CONSTANT: IDC_SIZENS          32645
CONSTANT: IDC_SIZEALL         32646
CONSTANT: IDC_NO              32648 ! not in win3.1
CONSTANT: IDC_HAND            32649
CONSTANT: IDC_APPSTARTING     32650 ! not in win3.1
CONSTANT: IDC_HELP            32651

! Predefined Clipboard Formats
CONSTANT: CF_TEXT             1
CONSTANT: CF_BITMAP           2
CONSTANT: CF_METAFILEPICT     3
CONSTANT: CF_SYLK             4
CONSTANT: CF_DIF              5
CONSTANT: CF_TIFF             6
CONSTANT: CF_OEMTEXT          7
CONSTANT: CF_DIB              8
CONSTANT: CF_PALETTE          9
CONSTANT: CF_PENDATA          10
CONSTANT: CF_RIFF             11
CONSTANT: CF_WAVE             12
CONSTANT: CF_UNICODETEXT      13
CONSTANT: CF_ENHMETAFILE      14
CONSTANT: CF_HDROP            15
CONSTANT: CF_LOCALE           16
CONSTANT: CF_DIBV5            17
CONSTANT: CF_MAX              18

CONSTANT: CF_OWNERDISPLAY 0x0080
CONSTANT: CF_DSPTEXT 0x0081
CONSTANT: CF_DSPBITMAP 0x0082
CONSTANT: CF_DSPMETAFILEPICT 0x0083
CONSTANT: CF_DSPENHMETAFILE 0x008E

! "Private" formats don't get GlobalFree()'d
CONSTANT: CF_PRIVATEFIRST 0x200
CONSTANT: CF_PRIVATELAST 0x2FF

! "GDIOBJ" formats do get DeleteObject()'d
CONSTANT: CF_GDIOBJFIRST 0x300
CONSTANT: CF_GDIOBJLAST 0x3FF

! Virtual Keys, Standard Set
CONSTANT: VK_LBUTTON        0x01
CONSTANT: VK_RBUTTON        0x02
CONSTANT: VK_CANCEL         0x03
CONSTANT: VK_MBUTTON        0x04  ! NOT contiguous with L & RBUTTON
CONSTANT: VK_XBUTTON1       0x05  ! NOT contiguous with L & RBUTTON
CONSTANT: VK_XBUTTON2       0x06  ! NOT contiguous with L & RBUTTON
! 0x07 : unassigned
CONSTANT: VK_BACK           0x08
CONSTANT: VK_TAB            0x09
! 0x0A - 0x0B : reserved

CONSTANT: VK_CLEAR          0x0C
CONSTANT: VK_RETURN         0x0D

CONSTANT: VK_SHIFT          0x10
CONSTANT: VK_CONTROL        0x11
CONSTANT: VK_MENU           0x12
CONSTANT: VK_PAUSE          0x13
CONSTANT: VK_CAPITAL        0x14

CONSTANT: VK_KANA           0x15
CONSTANT: VK_HANGEUL        0x15 ! old name - here for compatibility
CONSTANT: VK_HANGUL         0x15
CONSTANT: VK_JUNJA          0x17
CONSTANT: VK_FINAL          0x18
CONSTANT: VK_HANJA          0x19
CONSTANT: VK_KANJI          0x19

CONSTANT: VK_ESCAPE         0x1B

CONSTANT: VK_CONVERT        0x1C
CONSTANT: VK_NONCONVERT     0x1D
CONSTANT: VK_ACCEPT         0x1E
CONSTANT: VK_MODECHANGE     0x1F

CONSTANT: VK_SPACE          0x20
CONSTANT: VK_PRIOR          0x21
CONSTANT: VK_NEXT           0x22
CONSTANT: VK_END            0x23
CONSTANT: VK_HOME           0x24
CONSTANT: VK_LEFT           0x25
CONSTANT: VK_UP             0x26
CONSTANT: VK_RIGHT          0x27
CONSTANT: VK_DOWN           0x28
CONSTANT: VK_SELECT         0x29
CONSTANT: VK_PRINT          0x2A
CONSTANT: VK_EXECUTE        0x2B
CONSTANT: VK_SNAPSHOT       0x2C
CONSTANT: VK_INSERT         0x2D
CONSTANT: VK_DELETE         0x2E
CONSTANT: VK_HELP           0x2F

CONSTANT: VK_0 CHAR: 0
CONSTANT: VK_1 CHAR: 1
CONSTANT: VK_2 CHAR: 2
CONSTANT: VK_3 CHAR: 3
CONSTANT: VK_4 CHAR: 4
CONSTANT: VK_5 CHAR: 5
CONSTANT: VK_6 CHAR: 6
CONSTANT: VK_7 CHAR: 7
CONSTANT: VK_8 CHAR: 8
CONSTANT: VK_9 CHAR: 9

CONSTANT: VK_A CHAR: A
CONSTANT: VK_B CHAR: B
CONSTANT: VK_C CHAR: C
CONSTANT: VK_D CHAR: D
CONSTANT: VK_E CHAR: E
CONSTANT: VK_F CHAR: F
CONSTANT: VK_G CHAR: G
CONSTANT: VK_H CHAR: H
CONSTANT: VK_I CHAR: I
CONSTANT: VK_J CHAR: J
CONSTANT: VK_K CHAR: K
CONSTANT: VK_L CHAR: L
CONSTANT: VK_M CHAR: M
CONSTANT: VK_N CHAR: N
CONSTANT: VK_O CHAR: O
CONSTANT: VK_P CHAR: P
CONSTANT: VK_Q CHAR: Q
CONSTANT: VK_R CHAR: R
CONSTANT: VK_S CHAR: S
CONSTANT: VK_T CHAR: T
CONSTANT: VK_U CHAR: U
CONSTANT: VK_V CHAR: V
CONSTANT: VK_W CHAR: W
CONSTANT: VK_X CHAR: X
CONSTANT: VK_Y CHAR: Y
CONSTANT: VK_Z CHAR: Z

CONSTANT: VK_LWIN           0x5B
CONSTANT: VK_RWIN           0x5C
CONSTANT: VK_APPS           0x5D

! 0x5E : reserved

CONSTANT: VK_SLEEP          0x5F

CONSTANT: VK_NUMPAD0        0x60
CONSTANT: VK_NUMPAD1        0x61
CONSTANT: VK_NUMPAD2        0x62
CONSTANT: VK_NUMPAD3        0x63
CONSTANT: VK_NUMPAD4        0x64
CONSTANT: VK_NUMPAD5        0x65
CONSTANT: VK_NUMPAD6        0x66
CONSTANT: VK_NUMPAD7        0x67
CONSTANT: VK_NUMPAD8        0x68
CONSTANT: VK_NUMPAD9        0x69
CONSTANT: VK_MULTIPLY       0x6A
CONSTANT: VK_ADD            0x6B
CONSTANT: VK_SEPARATOR      0x6C
CONSTANT: VK_SUBTRACT       0x6D
CONSTANT: VK_DECIMAL        0x6E
CONSTANT: VK_DIVIDE         0x6F
CONSTANT: VK_F1             0x70
CONSTANT: VK_F2             0x71
CONSTANT: VK_F3             0x72
CONSTANT: VK_F4             0x73
CONSTANT: VK_F5             0x74
CONSTANT: VK_F6             0x75
CONSTANT: VK_F7             0x76
CONSTANT: VK_F8             0x77
CONSTANT: VK_F9             0x78
CONSTANT: VK_F10            0x79
CONSTANT: VK_F11            0x7A
CONSTANT: VK_F12            0x7B
CONSTANT: VK_F13            0x7C
CONSTANT: VK_F14            0x7D
CONSTANT: VK_F15            0x7E
CONSTANT: VK_F16            0x7F
CONSTANT: VK_F17            0x80
CONSTANT: VK_F18            0x81
CONSTANT: VK_F19            0x82
CONSTANT: VK_F20            0x83
CONSTANT: VK_F21            0x84
CONSTANT: VK_F22            0x85
CONSTANT: VK_F23            0x86
CONSTANT: VK_F24            0x87

! 0x88 - 0x8F : unassigned

CONSTANT: VK_NUMLOCK        0x90
CONSTANT: VK_SCROLL         0x91

! NEC PC-9800 kbd definitions
CONSTANT: VK_OEM_NEC_EQUAL  0x92  ! '=' key on numpad

! Fujitsu/OASYS kbd definitions
CONSTANT: VK_OEM_FJ_JISHO   0x92  ! 'Dictionary' key
CONSTANT: VK_OEM_FJ_MASSHOU 0x93  ! 'Unregister word' key
CONSTANT: VK_OEM_FJ_TOUROKU 0x94  ! 'Register word' key
CONSTANT: VK_OEM_FJ_LOYA    0x95  ! 'Left OYAYUBI' key
CONSTANT: VK_OEM_FJ_ROYA    0x96  ! 'Right OYAYUBI' key

! 0x97 - 0x9F : unassigned

! VK_L* & VK_R* - left and right Alt, Ctrl and Shift virtual keys.
! Used only as parameters to GetAsyncKeyState() and GetKeyState().
! No other API or message will distinguish left and right keys in this way.
CONSTANT: VK_LSHIFT         0xA0
CONSTANT: VK_RSHIFT         0xA1
CONSTANT: VK_LCONTROL       0xA2
CONSTANT: VK_RCONTROL       0xA3
CONSTANT: VK_LMENU          0xA4
CONSTANT: VK_RMENU          0xA5

CONSTANT: VK_BROWSER_BACK        0xA6
CONSTANT: VK_BROWSER_FORWARD     0xA7
CONSTANT: VK_BROWSER_REFRESH     0xA8
CONSTANT: VK_BROWSER_STOP        0xA9
CONSTANT: VK_BROWSER_SEARCH      0xAA
CONSTANT: VK_BROWSER_FAVORITES   0xAB
CONSTANT: VK_BROWSER_HOME        0xAC

CONSTANT: VK_VOLUME_MUTE         0xAD
CONSTANT: VK_VOLUME_DOWN         0xAE
CONSTANT: VK_VOLUME_UP           0xAF
CONSTANT: VK_MEDIA_NEXT_TRACK    0xB0
CONSTANT: VK_MEDIA_PREV_TRACK    0xB1
CONSTANT: VK_MEDIA_STOP          0xB2
CONSTANT: VK_MEDIA_PLAY_PAUSE    0xB3
CONSTANT: VK_LAUNCH_MAIL         0xB4
CONSTANT: VK_LAUNCH_MEDIA_SELECT 0xB5
CONSTANT: VK_LAUNCH_APP1         0xB6
CONSTANT: VK_LAUNCH_APP2         0xB7

! 0xB8 - 0xB9 : reserved

CONSTANT: VK_OEM_1          0xBA  ! ';:' for US
CONSTANT: VK_OEM_PLUS       0xBB  ! '+' any country
CONSTANT: VK_OEM_COMMA      0xBC  ! ',' any country
CONSTANT: VK_OEM_MINUS      0xBD  ! '-' any country
CONSTANT: VK_OEM_PERIOD     0xBE  ! '.' any country
CONSTANT: VK_OEM_2          0xBF  ! '/?' for US
CONSTANT: VK_OEM_3          0xC0  ! '`~' for US

! 0xC1 - 0xD7 : reserved

! 0xD8 - 0xDA : unassigned

CONSTANT: VK_OEM_4          0xDB !  '[{' for US
CONSTANT: VK_OEM_5          0xDC !  '\|' for US
CONSTANT: VK_OEM_6          0xDD !  ']}' for US
CONSTANT: VK_OEM_7          0xDE !  ''"' for US
CONSTANT: VK_OEM_8          0xDF

! 0xE0 : reserved

! Various extended or enhanced keyboards
CONSTANT: VK_OEM_AX         0xE1 !  'AX' key on Japanese AX kbd
CONSTANT: VK_OEM_102        0xE2 !  "<>" or "\|" on RT 102-key kbd.
CONSTANT: VK_ICO_HELP       0xE3 !  Help key on ICO
CONSTANT: VK_ICO_00         0xE4 !  00 key on ICO

CONSTANT: VK_PROCESSKEY     0xE5

CONSTANT: VK_ICO_CLEAR      0xE6

CONSTANT: VK_PACKET         0xE7

! 0xE8 : unassigned

! Nokia/Ericsson definitions
CONSTANT: VK_OEM_RESET      0xE9
CONSTANT: VK_OEM_JUMP       0xEA
CONSTANT: VK_OEM_PA1        0xEB
CONSTANT: VK_OEM_PA2        0xEC
CONSTANT: VK_OEM_PA3        0xED
CONSTANT: VK_OEM_WSCTRL     0xEE
CONSTANT: VK_OEM_CUSEL      0xEF
CONSTANT: VK_OEM_ATTN       0xF0
CONSTANT: VK_OEM_FINISH     0xF1
CONSTANT: VK_OEM_COPY       0xF2
CONSTANT: VK_OEM_AUTO       0xF3
CONSTANT: VK_OEM_ENLW       0xF4
CONSTANT: VK_OEM_BACKTAB    0xF5

CONSTANT: VK_ATTN           0xF6
CONSTANT: VK_CRSEL          0xF7
CONSTANT: VK_EXSEL          0xF8
CONSTANT: VK_EREOF          0xF9
CONSTANT: VK_PLAY           0xFA
CONSTANT: VK_ZOOM           0xFB
CONSTANT: VK_NONAME         0xFC
CONSTANT: VK_PA1            0xFD
CONSTANT: VK_OEM_CLEAR      0xFE
! 0xFF : reserved

! Key State Masks for Mouse Messages
CONSTANT: MK_LBUTTON          0x0001
CONSTANT: MK_RBUTTON          0x0002
CONSTANT: MK_SHIFT            0x0004
CONSTANT: MK_CONTROL          0x0008
CONSTANT: MK_MBUTTON          0x0010
CONSTANT: MK_XBUTTON1         0x0020
CONSTANT: MK_XBUTTON2         0x0040

! Some fields are not defined for win64
! Window field offsets for GetWindowLong()
CONSTANT: GWL_WNDPROC         -4
CONSTANT: GWL_HINSTANCE       -6
CONSTANT: GWL_HWNDPARENT      -8
CONSTANT: GWL_USERDATA        -21
CONSTANT: GWL_ID              -12

CONSTANT: GWL_STYLE           -16
CONSTANT: GWL_EXSTYLE         -20

CONSTANT: GWLP_WNDPROC        -4
CONSTANT: GWLP_HINSTANCE      -6
CONSTANT: GWLP_HWNDPARENT     -8
CONSTANT: GWLP_USERDATA       -21
CONSTANT: GWLP_ID             -12

! Class field offsets for GetClassLong()
CONSTANT: GCL_MENUNAME        -8
CONSTANT: GCL_HBRBACKGROUND   -10
CONSTANT: GCL_HCURSOR         -12
CONSTANT: GCL_HICON           -14
CONSTANT: GCL_HMODULE         -16
CONSTANT: GCL_WNDPROC         -24
CONSTANT: GCL_HICONSM         -34
CONSTANT: GCL_CBWNDEXTRA      -18
CONSTANT: GCL_CBCLSEXTRA      -20
CONSTANT: GCL_STYLE           -26
CONSTANT: GCW_ATOM            -32

CONSTANT: GCLP_MENUNAME       -8
CONSTANT: GCLP_HBRBACKGROUND  -10
CONSTANT: GCLP_HCURSOR        -12
CONSTANT: GCLP_HICON          -14
CONSTANT: GCLP_HMODULE        -16
CONSTANT: GCLP_WNDPROC        -24
CONSTANT: GCLP_HICONSM        -34

CONSTANT: MB_ICONASTERISK    0x00000040
CONSTANT: MB_ICONEXCLAMATION 0x00000030
CONSTANT: MB_ICONHAND        0x00000010
CONSTANT: MB_ICONQUESTION    0x00000020
CONSTANT: MB_OK              0x00000000

ALIAS: FVIRTKEY TRUE
CONSTANT: FNOINVERT 2
CONSTANT: FSHIFT 4
CONSTANT: FCONTROL 8
CONSTANT: FALT 16

CONSTANT: MAPVK_VK_TO_VSC 0
CONSTANT: MAPVK_VSC_TO_VK 1
CONSTANT: MAPVK_VK_TO_CHAR 2
CONSTANT: MAPVK_VSC_TO_VK_EX 3
CONSTANT: MAPVK_VK_TO_VSC_EX 3

CONSTANT: TME_HOVER 1
CONSTANT: TME_LEAVE 2
CONSTANT: TME_NONCLIENT 16
CONSTANT: TME_QUERY 0x40000000
CONSTANT: TME_CANCEL 0x80000000
CONSTANT: HOVER_DEFAULT 0xffffffff
STRUCT: TRACKMOUSEEVENT
    { cbSize DWORD }
    { dwFlags DWORD }
    { hwndTrack HWND }
    { dwHoverTime DWORD } ;
TYPEDEF: TRACKMOUSEEVENT* LPTRACKMOUSEEVENT

CONSTANT: DBT_DEVICEARRIVAL 0x8000
CONSTANT: DBT_DEVICEREMOVECOMPLETE 0x8004

CONSTANT: DBT_DEVTYP_DEVICEINTERFACE 5

CONSTANT: DEVICE_NOTIFY_WINDOW_HANDLE 0
CONSTANT: DEVICE_NOTIFY_SERVICE_HANDLE 1

CONSTANT: DEVICE_NOTIFY_ALL_INTERFACE_CLASSES 4

STRUCT: DEV_BROADCAST_HDR
    { dbch_size DWORD }
    { dbch_devicetype DWORD }
    { dbch_reserved DWORD } ;

STRUCT: DEV_BROADCAST_DEVICEW
    { dbcc_size DWORD }
    { dbcc_devicetype DWORD }
    { dbcc_reserved DWORD }
    { dbcc_classguid GUID }
    { dbcc_name WCHAR[1] } ;

CONSTANT: CCHDEVICENAME 32

STRUCT: MONITORINFOEX
    { cbSize DWORD }
    { rcMonitor RECT }
    { rcWork RECT }
    { dwFlags DWORD }
    { szDevice { TCHAR CCHDEVICENAME } } ;

TYPEDEF: MONITORINFOEX* LPMONITORINFOEX
TYPEDEF: MONITORINFOEX* LPMONITORINFO

CONSTANT: MONITOR_DEFAULTTONULL 0
CONSTANT: MONITOR_DEFAULTTOPRIMARY 1
CONSTANT: MONITOR_DEFAULTTONEAREST 2
CONSTANT: MONITORINFOF_PRIMARY 1
CONSTANT: SWP_NOSIZE 1
CONSTANT: SWP_NOMOVE 2
CONSTANT: SWP_NOZORDER 4
CONSTANT: SWP_NOREDRAW 8
CONSTANT: SWP_NOACTIVATE 16
CONSTANT: SWP_FRAMECHANGED 32
CONSTANT: SWP_SHOWWINDOW 64
CONSTANT: SWP_HIDEWINDOW 128
CONSTANT: SWP_NOCOPYBITS 256
CONSTANT: SWP_NOOWNERZORDER 512
CONSTANT: SWP_NOSENDCHANGING 1024
ALIAS: SWP_DRAWFRAME SWP_FRAMECHANGED
ALIAS: SWP_NOREPOSITION SWP_NOOWNERZORDER
CONSTANT: SWP_DEFERERASE 8192
CONSTANT: SWP_ASYNCWINDOWPOS 16384

CONSTANT: MF_ENABLED         0x0000
CONSTANT: MF_GRAYED          0x0001
CONSTANT: MF_DISABLED        0x0002
CONSTANT: MF_STRING          0x0000
CONSTANT: MF_BITMAP          0x0004
CONSTANT: MF_UNCHECKED       0x0000
CONSTANT: MF_CHECKED         0x0008
CONSTANT: MF_POPUP           0x0010
CONSTANT: MF_MENUBARBREAK    0x0020
CONSTANT: MF_MENUBREAK       0x0040
CONSTANT: MF_UNHILITE        0x0000
CONSTANT: MF_HILITE          0x0080
CONSTANT: MF_OWNERDRAW       0x0100
CONSTANT: MF_USECHECKBITMAPS 0x0200
CONSTANT: MF_BYCOMMAND       0x0000
CONSTANT: MF_BYPOSITION      0x0400
CONSTANT: MF_SEPARATOR       0x0800
CONSTANT: MF_DEFAULT         0x1000
CONSTANT: MF_SYSMENU         0x2000
CONSTANT: MF_HELP            0x4000
CONSTANT: MF_RIGHTJUSTIFY    0x4000
CONSTANT: MF_MOUSESELECT     0x8000

CONSTANT: SPI_GETBEEP               1
CONSTANT: SPI_SETBEEP               2
CONSTANT: SPI_GETMOUSE              3
CONSTANT: SPI_SETMOUSE              4
CONSTANT: SPI_GETBORDER             5
CONSTANT: SPI_SETBORDER             6
CONSTANT: SPI_GETKEYBOARDSPEED      10
CONSTANT: SPI_SETKEYBOARDSPEED      11
CONSTANT: SPI_LANGDRIVER            12
CONSTANT: SPI_ICONHORIZONTALSPACING 13
CONSTANT: SPI_GETSCREENSAVETIMEOUT  14
CONSTANT: SPI_SETSCREENSAVETIMEOUT  15
CONSTANT: SPI_GETSCREENSAVEACTIVE   16
CONSTANT: SPI_SETSCREENSAVEACTIVE   17
CONSTANT: SPI_GETGRIDGRANULARITY    18
CONSTANT: SPI_SETGRIDGRANULARITY    19
CONSTANT: SPI_SETDESKWALLPAPER      20
CONSTANT: SPI_SETDESKPATTERN        21
CONSTANT: SPI_GETKEYBOARDDELAY      22
CONSTANT: SPI_SETKEYBOARDDELAY      23
CONSTANT: SPI_ICONVERTICALSPACING   24
CONSTANT: SPI_GETICONTITLEWRAP      25
CONSTANT: SPI_SETICONTITLEWRAP      26
CONSTANT: SPI_GETMENUDROPALIGNMENT  27
CONSTANT: SPI_SETMENUDROPALIGNMENT  28
CONSTANT: SPI_SETDOUBLECLKWIDTH     29
CONSTANT: SPI_SETDOUBLECLKHEIGHT    30
CONSTANT: SPI_GETICONTITLELOGFONT   31
CONSTANT: SPI_SETDOUBLECLICKTIME    32
CONSTANT: SPI_SETMOUSEBUTTONSWAP    33
CONSTANT: SPI_SETICONTITLELOGFONT   34
CONSTANT: SPI_GETFASTTASKSWITCH     35
CONSTANT: SPI_SETFASTTASKSWITCH     36
CONSTANT: SPI_SETDRAGFULLWINDOWS    37
CONSTANT: SPI_GETDRAGFULLWINDOWS    38

CONSTANT: SPI_GETFILTERKEYS         50
CONSTANT: SPI_SETFILTERKEYS         51
CONSTANT: SPI_GETTOGGLEKEYS         52
CONSTANT: SPI_SETTOGGLEKEYS         53
CONSTANT: SPI_GETMOUSEKEYS          54
CONSTANT: SPI_SETMOUSEKEYS          55
CONSTANT: SPI_GETSHOWSOUNDS         56
CONSTANT: SPI_SETSHOWSOUNDS         57
CONSTANT: SPI_GETSTICKYKEYS         58
CONSTANT: SPI_SETSTICKYKEYS         59
CONSTANT: SPI_GETACCESSTIMEOUT      60
CONSTANT: SPI_SETACCESSTIMEOUT      61

CONSTANT: SPI_GETSOUNDSENTRY        64
CONSTANT: SPI_SETSOUNDSENTRY        65

! WINVER >= 0x0400
CONSTANT: SPI_GETNONCLIENTMETRICS   41
CONSTANT: SPI_SETNONCLIENTMETRICS   42
CONSTANT: SPI_GETMINIMIZEDMETRICS   43
CONSTANT: SPI_SETMINIMIZEDMETRICS   44
CONSTANT: SPI_GETICONMETRICS        45
CONSTANT: SPI_SETICONMETRICS        46
CONSTANT: SPI_SETWORKAREA           47
CONSTANT: SPI_GETWORKAREA           48
CONSTANT: SPI_SETPENWINDOWS         49

CONSTANT: SPI_GETSERIALKEYS         62
CONSTANT: SPI_SETSERIALKEYS         63
CONSTANT: SPI_GETHIGHCONTRAST       66
CONSTANT: SPI_SETHIGHCONTRAST       67
CONSTANT: SPI_GETKEYBOARDPREF       68
CONSTANT: SPI_SETKEYBOARDPREF       69
CONSTANT: SPI_GETSCREENREADER       70
CONSTANT: SPI_SETSCREENREADER       71
CONSTANT: SPI_GETANIMATION          72
CONSTANT: SPI_SETANIMATION          73
CONSTANT: SPI_GETFONTSMOOTHING      74
CONSTANT: SPI_SETFONTSMOOTHING      75
CONSTANT: SPI_SETDRAGWIDTH          76
CONSTANT: SPI_SETDRAGHEIGHT         77
CONSTANT: SPI_SETHANDHELD           78
CONSTANT: SPI_GETLOWPOWERTIMEOUT    79
CONSTANT: SPI_GETPOWEROFFTIMEOUT    80
CONSTANT: SPI_SETLOWPOWERTIMEOUT    81
CONSTANT: SPI_SETPOWEROFFTIMEOUT    82
CONSTANT: SPI_GETLOWPOWERACTIVE     83
CONSTANT: SPI_GETPOWEROFFACTIVE     84
CONSTANT: SPI_SETLOWPOWERACTIVE     85
CONSTANT: SPI_SETPOWEROFFACTIVE     86
CONSTANT: SPI_SETCURSORS            87
CONSTANT: SPI_SETICONS              88
CONSTANT: SPI_GETDEFAULTINPUTLANG   89
CONSTANT: SPI_SETDEFAULTINPUTLANG   90
CONSTANT: SPI_SETLANGTOGGLE         91
CONSTANT: SPI_GETWINDOWSEXTENSION   92
CONSTANT: SPI_SETMOUSETRAILS        93
CONSTANT: SPI_GETMOUSETRAILS        94
CONSTANT: SPI_SETSCREENSAVERRUNNING 97
ALIAS: SPI_SCREENSAVERRUNNING    SPI_SETSCREENSAVERRUNNING

! WIN32_WINNT >= 0x0400 || WIN32_WINDOWS > 0x0400
CONSTANT: SPI_GETMOUSEHOVERWIDTH    98
CONSTANT: SPI_SETMOUSEHOVERWIDTH    99
CONSTANT: SPI_GETMOUSEHOVERHEIGHT   100
CONSTANT: SPI_SETMOUSEHOVERHEIGHT   101
CONSTANT: SPI_GETMOUSEHOVERTIME     102
CONSTANT: SPI_SETMOUSEHOVERTIME     103
CONSTANT: SPI_GETWHEELSCROLLLINES   104
CONSTANT: SPI_SETWHEELSCROLLLINES   105

CONSTANT: SPI_GETSHOWIMEUI          110
CONSTANT: SPI_SETSHOWIMEUI          111

! WINVER >= 0x0500
CONSTANT: SPI_GETMOUSESPEED         112
CONSTANT: SPI_SETMOUSESPEED         113
CONSTANT: SPI_GETSCREENSAVERRUNNING 114

CONSTANT: SPI_GETACTIVEWINDOWTRACKING    0x1000
CONSTANT: SPI_SETACTIVEWINDOWTRACKING    0x1001
CONSTANT: SPI_GETMENUANIMATION           0x1002
CONSTANT: SPI_SETMENUANIMATION           0x1003
CONSTANT: SPI_GETCOMBOBOXANIMATION       0x1004
CONSTANT: SPI_SETCOMBOBOXANIMATION       0x1005
CONSTANT: SPI_GETLISTBOXSMOOTHSCROLLING  0x1006
CONSTANT: SPI_SETLISTBOXSMOOTHSCROLLING  0x1007
CONSTANT: SPI_GETGRADIENTCAPTIONS        0x1008
CONSTANT: SPI_SETGRADIENTCAPTIONS        0x1009
CONSTANT: SPI_GETMENUUNDERLINES          0x100A
CONSTANT: SPI_SETMENUUNDERLINES          0x100B
CONSTANT: SPI_GETACTIVEWNDTRKZORDER      0x100C
CONSTANT: SPI_SETACTIVEWNDTRKZORDER      0x100D
CONSTANT: SPI_GETHOTTRACKING             0x100E
CONSTANT: SPI_SETHOTTRACKING             0x100F
CONSTANT: SPI_GETFOREGROUNDLOCKTIMEOUT   0x2000
CONSTANT: SPI_SETFOREGROUNDLOCKTIMEOUT   0x2001
CONSTANT: SPI_GETACTIVEWNDTRKTIMEOUT     0x2002
CONSTANT: SPI_SETACTIVEWNDTRKTIMEOUT     0x2003
CONSTANT: SPI_GETFOREGROUNDFLASHCOUNT    0x2004
CONSTANT: SPI_SETFOREGROUNDFLASHCOUNT    0x2005

! SystemParamInfo Flags
CONSTANT: SPIF_UPDATEINIFILE              1
CONSTANT: SPIF_SENDWININICHANGE           2
ALIAS: SPIF_SENDCHANGE                 SPIF_SENDWININICHANGE


TYPEDEF: HANDLE HRAWINPUT
: GET_RAWINPUT_CODE_WPARAM ( wParam -- n ) 0xff bitand ; inline

CONSTANT: RIM_INPUT        0
CONSTANT: RIM_INPUTSINK    1

CONSTANT: RIM_TYPEMOUSE    0
CONSTANT: RIM_TYPEKEYBOARD 1
CONSTANT: RIM_TYPEHID      2

STRUCT: RAWINPUTHEADER
    { dwType  DWORD  }
    { dwSize  DWORD  }
    { hDevice HANDLE }
    { wParam  WPARAM } ;
TYPEDEF: RAWINPUTHEADER* PRAWINPUTHEADER
TYPEDEF: RAWINPUTHEADER* LPRAWINPUTHEADER
STRUCT: RAWMOUSE_BUTTONS_USBUTTONS
    { usButtonFlags USHORT }
    { usButtonData  USHORT } ;

UNION-STRUCT: RAWMOUSE_BUTTONS
    { ulButtons ULONG                      }
    { usButtons RAWMOUSE_BUTTONS_USBUTTONS } ;
STRUCT: RAWMOUSE
    { usFlags            USHORT            }
    { uButtons           RAWMOUSE_BUTTONS  }
    { ulRawButtons       ULONG             }
    { lLastX             LONG              }
    { lLastY             LONG              }
    { ulExtraInformation ULONG             } ;
TYPEDEF: RAWMOUSE* PRAWMOUSE
TYPEDEF: RAWMOUSE* LPRAWMOUSE

CONSTANT: RI_MOUSE_LEFT_BUTTON_DOWN   0x0001
CONSTANT: RI_MOUSE_LEFT_BUTTON_UP     0x0002
CONSTANT: RI_MOUSE_RIGHT_BUTTON_DOWN  0x0004
CONSTANT: RI_MOUSE_RIGHT_BUTTON_UP    0x0008
CONSTANT: RI_MOUSE_MIDDLE_BUTTON_DOWN 0x0010
CONSTANT: RI_MOUSE_MIDDLE_BUTTON_UP   0x0020

: RI_MOUSE_BUTTON_1_DOWN      ( -- n ) RI_MOUSE_LEFT_BUTTON_DOWN ; inline
: RI_MOUSE_BUTTON_1_UP        ( -- n ) RI_MOUSE_LEFT_BUTTON_UP ; inline
: RI_MOUSE_BUTTON_2_DOWN      ( -- n ) RI_MOUSE_RIGHT_BUTTON_DOWN ; inline
: RI_MOUSE_BUTTON_2_UP        ( -- n ) RI_MOUSE_RIGHT_BUTTON_UP ; inline
: RI_MOUSE_BUTTON_3_DOWN      ( -- n ) RI_MOUSE_MIDDLE_BUTTON_DOWN ; inline
: RI_MOUSE_BUTTON_3_UP        ( -- n ) RI_MOUSE_MIDDLE_BUTTON_UP ; inline

CONSTANT: RI_MOUSE_BUTTON_4_DOWN      0x0040
CONSTANT: RI_MOUSE_BUTTON_4_UP        0x0080
CONSTANT: RI_MOUSE_BUTTON_5_DOWN      0x0100
CONSTANT: RI_MOUSE_BUTTON_5_UP        0x0200
CONSTANT: RI_MOUSE_WHEEL              0x0400

CONSTANT: MOUSE_MOVE_RELATIVE      0
CONSTANT: MOUSE_MOVE_ABSOLUTE      1
CONSTANT: MOUSE_VIRTUAL_DESKTOP    0x02
CONSTANT: MOUSE_ATTRIBUTES_CHANGED 0x04
CONSTANT: MOUSE_MOVE_NOCOALESCE    0x08

STRUCT: RAWKEYBOARD
    { MakeCode         USHORT }
    { Flags            USHORT }
    { Reserved         USHORT }
    { VKey             USHORT }
    { Message          UINT   }
    { ExtraInformation ULONG  } ;
TYPEDEF: RAWKEYBOARD* PRAWKEYBOARD
TYPEDEF: RAWKEYBOARD* LPRAWKEYBOARD

CONSTANT: KEYBOARD_OVERRUN_MAKE_CODE    0xFF

CONSTANT: RI_KEY_MAKE             0
CONSTANT: RI_KEY_BREAK            1
CONSTANT: RI_KEY_E0               2
CONSTANT: RI_KEY_E1               4
CONSTANT: RI_KEY_TERMSRV_SET_LED  8
CONSTANT: RI_KEY_TERMSRV_SHADOW   0x10

STRUCT: RAWHID
    { dwSizeHid DWORD   }
    { dwCount   DWORD   }
    { bRawData  BYTE[1] } ;
TYPEDEF: RAWHID* PRAWHID
TYPEDEF: RAWHID* LPRAWHID

UNION-STRUCT: RAWINPUT_UNION
    { mouse    RAWMOUSE }
    { keyboard RAWKEYBOARD }
    { hid      RAWHID } ;
STRUCT: RAWINPUT
    { header RAWINPUTHEADER }
    { data   RAWINPUT_UNION } ;
TYPEDEF: RAWINPUT* PRAWINPUT
TYPEDEF: RAWINPUT* LPRAWINPUT

: RAWINPUT_ALIGN ( x -- y )
    cpu x86.32 = [ 4 ] [ 8 ] if align ; inline
: NEXTRAWINPUTBLOCK ( struct -- next-struct )
    dup header>> dwSize>> swap <displaced-alien> RAWINPUT_ALIGN RAWINPUT memory>struct ; inline

CONSTANT: RID_INPUT               0x10000003
CONSTANT: RID_HEADER              0x10000005
CONSTANT: RIDI_PREPARSEDDATA      0x20000005
CONSTANT: RIDI_DEVICENAME         0x20000007
CONSTANT: RIDI_DEVICEINFO         0x2000000b

STRUCT: RID_DEVICE_INFO_MOUSE
    { dwId                 DWORD }
    { dwNumberOfButtons    DWORD }
    { dwSampleRate         DWORD }
    { fHasHorizontalWheel  BOOL  } ;
TYPEDEF: RID_DEVICE_INFO_MOUSE* PRID_DEVICE_INFO_MOUSE

STRUCT: RID_DEVICE_INFO_KEYBOARD
    { dwType                 DWORD }
    { dwSubType              DWORD }
    { dwKeyboardMode         DWORD }
    { dwNumberOfFunctionKeys DWORD }
    { dwNumberOfIndicators   DWORD }
    { dwNumberOfKeysTotal    DWORD } ;
TYPEDEF: RID_DEVICE_INFO_KEYBOARD* PRID_DEVICE_INFO_KEYBOARD

STRUCT: RID_DEVICE_INFO_HID
    { dwVendorId      DWORD  }
    { dwProductId     DWORD  }
    { dwVersionNumber DWORD  }
    { usUsagePage     USHORT }
    { usUsage         USHORT } ;
TYPEDEF: RID_DEVICE_INFO_HID* PRID_DEVICE_INFO_HID

UNION-STRUCT: RID_DEVICE_INFO_UNION
    { mouse    RID_DEVICE_INFO_MOUSE    }
    { keyboard RID_DEVICE_INFO_KEYBOARD }
    { hid      RID_DEVICE_INFO_HID      } ;
STRUCT: RID_DEVICE_INFO
    { cbSize DWORD                 }
    { dwType DWORD                 }
    { data   RID_DEVICE_INFO_UNION } ;
TYPEDEF: RID_DEVICE_INFO* PRID_DEVICE_INFO
TYPEDEF: RID_DEVICE_INFO* LPRID_DEVICE_INFO

STRUCT: RAWINPUTDEVICE
    { usUsagePage USHORT }
    { usUsage     USHORT }
    { dwFlags     DWORD  }
    { hwndTarget  HWND   } ;
TYPEDEF: RAWINPUTDEVICE* PRAWINPUTDEVICE
TYPEDEF: RAWINPUTDEVICE* LPRAWINPUTDEVICE
TYPEDEF: RAWINPUTDEVICE* PCRAWINPUTDEVICE

CONSTANT: RIDEV_REMOVE            0x00000001
CONSTANT: RIDEV_EXCLUDE           0x00000010
CONSTANT: RIDEV_PAGEONLY          0x00000020
CONSTANT: RIDEV_NOLEGACY          0x00000030
CONSTANT: RIDEV_INPUTSINK         0x00000100
CONSTANT: RIDEV_CAPTUREMOUSE      0x00000200
CONSTANT: RIDEV_NOHOTKEYS         0x00000200
CONSTANT: RIDEV_APPKEYS           0x00000400
CONSTANT: RIDEV_EXINPUTSINK       0x00001000
CONSTANT: RIDEV_DEVNOTIFY         0x00002000
CONSTANT: RIDEV_EXMODEMASK        0x000000F0

: RIDEV_EXMODE ( mode -- x ) RIDEV_EXMODEMASK bitand ; inline

CONSTANT: GIDC_ARRIVAL             1
CONSTANT: GIDC_REMOVAL             2

: GET_DEVICE_CHANGE_WPARAM ( wParam -- x ) 0xffff bitand ; inline

STRUCT: RAWINPUTDEVICELIST
    { hDevice HANDLE }
    { dwType  DWORD  } ;
TYPEDEF: RAWINPUTDEVICELIST* PRAWINPUTDEVICELIST

CONSTANT: CCHFORMNAME 32

CONSTANT: CDS_UPDATEREGISTRY      0x00000001
CONSTANT: CDS_TEST                0x00000002
CONSTANT: CDS_FULLSCREEN          0x00000004
CONSTANT: CDS_GLOBAL              0x00000008
CONSTANT: CDS_SET_PRIMARY         0x00000010
CONSTANT: CDS_RESET               0x40000000
CONSTANT: CDS_SETRECT             0x20000000
CONSTANT: CDS_NORESET             0x10000000

CONSTANT: DISP_CHANGE_SUCCESSFUL 0
CONSTANT: DISP_CHANGE_RESTART 1
CONSTANT: DISP_CHANGE_FAILED     -1
CONSTANT: DISP_CHANGE_BADMODE    -2
CONSTANT: DISP_CHANGE_NOTUPDATED -3
CONSTANT: DISP_CHANGE_BADFLAGS   -4
CONSTANT: DISP_CHANGE_BADPARAM   -5



STRUCT: DEVMODE
    { dmDeviceName TCHAR[CCHDEVICENAME] }
    { dmSpecVersion WORD }
    { dmDriverVersion WORD }
    { dmSize WORD }
    { dmDriverExtra WORD }
    { dmFields DWORD }

    { dmOrientation short }
    { dmPaperSize short }
    { dmPaperLength short }
    { dmPaperWidth short }
    { dmScale short }
    { dmCopies short }
    { dmDefaultSource short }
    { dmPrintQuality short }

    { dmColor short }
    { dmDuplex short }
    { dmYResolution short }
    { dmTTOption short }
    { dmCollate short }
    { dmFormName TCHAR[CCHFORMNAME] }
    { dmLogPixels WORD }
    { dmBitsPerPel DWORD }
    { dmPelsWidth DWORD }
    { dmPelsHeight DWORD }
    { dmDisplayFlags DWORD }
    { dmDisplayFrequency DWORD }
    { dmiCMMethod DWORD }
    { dmICMIntent DWORD }

    { dmMediaType DWORD }
    { dmDitherType DWORD }
    { dmReserved1 DWORD }
    { dmReserved2 DWORD }
    { dmPanningWidth DWORD } ;

! union { DWORD dmDisplayFlags; DWORD dmNup; } ;
  ! union {
    ! struct {
      ! short dmOrientation;
      ! short dmPaperSize;
      ! short dmPaperLength;
      ! short dmPaperWidth;
      ! short dmScale;
      ! short dmCopies;
      ! short dmDefaultSource;
      ! short dmPrintQuality;
    ! } ;
    ! struct {
      ! POINTL dmPosition;
      ! DWORD dmDisplayOrientation;
      ! DWORD dmDisplayFixedOutput;
    ! } ;
  ! } ;

TYPEDEF: DEVMODE* PDEVMODE
TYPEDEF: DEVMODE* LPDEVMODE

LIBRARY: user32

FUNCTION: HKL ActivateKeyboardLayout ( HKL hkl, UINT Flags ) ;
FUNCTION: BOOL AdjustWindowRect ( LPRECT lpRect, DWORD dwStyle, BOOL bMenu ) ;
FUNCTION: BOOL AdjustWindowRectEx ( LPRECT lpRect, DWORD dwStyle, BOOL bMenu, DWORD dwExStyle ) ;
! FUNCTION: AlignRects
! FUNCTION: AllowForegroundActivation
! FUNCTION: AllowSetForegroundWindow
! FUNCTION: AnimateWindow

FUNCTION: BOOL AnyPopup ( ) ;

! FUNCTION: AppendMenuA
! FUNCTION: AppendMenuW
! FUNCTION: ArrangeIconicWindows
! FUNCTION: AttachThreadInput
! FUNCTION: BeginDeferWindowPos

FUNCTION: HDC BeginPaint ( HWND hwnd, LPPAINTSTRUCT lpPaint ) ;

! FUNCTION: BlockInput
! FUNCTION: BringWindowToTop
! FUNCTION: BroadcastSystemMessage
! FUNCTION: BroadcastSystemMessageA
! FUNCTION: BroadcastSystemMessageExA
! FUNCTION: BroadcastSystemMessageExW
! FUNCTION: BroadcastSystemMessageW
! FUNCTION: BuildReasonArray
! FUNCTION: CalcMenuBar
! FUNCTION: CallMsgFilter
! FUNCTION: CallMsgFilterA
! FUNCTION: CallMsgFilterW
! FUNCTION: CallNextHookEx
! FUNCTION: CallWindowProcA
! FUNCTION: CallWindowProcW
! FUNCTION: CascadeChildWindows
! FUNCTION: CascadeWindows
! FUNCTION: ChangeClipboardChain
FUNCTION: LONG ChangeDisplaySettingsExW ( LPCTSTR lpszDeviceName, DEVMODE *lpDevMode, HWND hwnd, DWORD dwFlags, LPVOID lParam ) ;
FUNCTION: LONG ChangeDisplaySettingsW ( DEVMODE *lpDevMode, DWORD dwFlags ) ;
ALIAS: ChangeDisplaySettingsEx ChangeDisplaySettingsExW
ALIAS: ChangeDisplaySettings ChangeDisplaySettingsW
! FUNCTION: ChangeMenuA
! FUNCTION: ChangeMenuW
! FUNCTION: CharLowerA
! FUNCTION: CharLowerBuffA
! FUNCTION: CharLowerBuffW
! FUNCTION: CharLowerW
! FUNCTION: CharNextA
! FUNCTION: CharNextExA
! FUNCTION: CharNextW
! FUNCTION: CharPrevA
! FUNCTION: CharPrevExA
! FUNCTION: CharPrevW
! FUNCTION: CharToOemA
! FUNCTION: CharToOemBuffA
! FUNCTION: CharToOemBuffW
! FUNCTION: CharToOemW
! FUNCTION: CharUpperA
! FUNCTION: CharUpperBuffA
! FUNCTION: CharUpperBuffW
! FUNCTION: CharUpperW
! FUNCTION: CheckDlgButton
! FUNCTION: CheckMenuItem
! FUNCTION: CheckMenuRadioItem
! FUNCTION: CheckRadioButton
FUNCTION: HWND ChildWindowFromPoint ( HWND hWndParent, POINT point ) ;
! FUNCTION: ChildWindowFromPointEx
! FUNCTION: ClientThreadSetup
FUNCTION: BOOL ClientToScreen ( HWND hWnd, POINT* point ) ;
! FUNCTION: CliImmSetHotKey
FUNCTION: int ClipCursor ( RECT* clipRect ) ;
FUNCTION: BOOL CloseClipboard ( ) ;
! FUNCTION: CloseDesktop
! FUNCTION: CloseWindow
! FUNCTION: CloseWindowStation
! FUNCTION: CopyAcceleratorTableA
FUNCTION: int CopyAcceleratorTableW ( HACCEL hAccelSrc, LPACCEL lpAccelDst, int cAccelEntries ) ;
ALIAS: CopyAcceleratorTable CopyAcceleratorTableW
! FUNCTION: CopyIcon
! FUNCTION: CopyImage
! FUNCTION: CopyRect
! FUNCTION: CountClipboardFormats
! FUNCTION: CreateAcceleratorTableA
FUNCTION: HACCEL CreateAcceleratorTableW ( LPACCEL lpaccl, int cEntries ) ;
ALIAS: CreateAcceleratorTable CreateAcceleratorTableW
! FUNCTION: CreateCaret
! FUNCTION: CreateCursor
! FUNCTION: CreateDesktopA
! FUNCTION: CreateDesktopW
! FUNCTION: CreateDialogIndirectParamA
! FUNCTION: CreateDialogIndirectParamAorW
! FUNCTION: CreateDialogIndirectParamW
! FUNCTION: CreateDialogParamA
! FUNCTION: CreateDialogParamW
! FUNCTION: CreateIcon
! FUNCTION: CreateIconFromResource
! FUNCTION: CreateIconFromResourceEx
! FUNCTION: CreateIconIndirect
! FUNCTION: CreateMDIWindowA
! FUNCTION: CreateMDIWindowW
! FUNCTION: CreateMenu
! FUNCTION: CreatePopupMenu
! FUNCTION: CreateSystemThreads

FUNCTION: HWND CreateWindowExW (
                DWORD dwExStyle,
                LPCTSTR lpClassName,
                LPCTSTR lpWindowName,
                DWORD dwStyle,
                uint X,
                uint Y,
                uint nWidth,
                uint nHeight,
                HWND hWndParent,
                HMENU hMenu,
                HINSTANCE hInstance,
                LPVOID lpParam ) ;

ALIAS: CreateWindowEx CreateWindowExW

: CreateWindow ( a b c d e f g h i j k -- hwnd ) 0 12 -nrot CreateWindowEx ; inline

! FUNCTION: CreateWindowStationA
! FUNCTION: CreateWindowStationW
! FUNCTION: CsrBroadcastSystemMessageExW
! FUNCTION: CtxInitUser32
! FUNCTION: DdeAbandonTransaction
! FUNCTION: DdeAccessData
! FUNCTION: DdeAddData
! FUNCTION: DdeClientTransaction
! FUNCTION: DdeCmpStringHandles
! FUNCTION: DdeConnect
! FUNCTION: DdeConnectList
! FUNCTION: DdeCreateDataHandle
! FUNCTION: DdeCreateStringHandleA
! FUNCTION: DdeCreateStringHandleW
! FUNCTION: DdeDisconnect
! FUNCTION: DdeDisconnectList
! FUNCTION: DdeEnableCallback
! FUNCTION: DdeFreeDataHandle
! FUNCTION: DdeFreeStringHandle
! FUNCTION: DdeGetData
! FUNCTION: DdeGetLastError
! FUNCTION: DdeGetQualityOfService
! FUNCTION: DdeImpersonateClient
! FUNCTION: DdeInitializeA
! FUNCTION: DdeInitializeW
! FUNCTION: DdeKeepStringHandle
! FUNCTION: DdeNameService
! FUNCTION: DdePostAdvise
! FUNCTION: DdeQueryConvInfo
! FUNCTION: DdeQueryNextServer
! FUNCTION: DdeQueryStringA
! FUNCTION: DdeQueryStringW
! FUNCTION: DdeReconnect
! FUNCTION: DdeSetQualityOfService
! FUNCTION: DdeSetUserHandle
! FUNCTION: DdeUnaccessData
! FUNCTION: DdeUninitialize
! FUNCTION: DefDlgProcA
! FUNCTION: DefDlgProcW
! FUNCTION: DeferWindowPos
! FUNCTION: DefFrameProcA
! FUNCTION: DefFrameProcW
! FUNCTION: DefMDIChildProcA
! FUNCTION: DefMDIChildProcW
FUNCTION: LRESULT DefRawInputProc ( PRAWINPUT* paRawInput, INT nInput, UINT cbSizeHeader ) ;
FUNCTION: LRESULT DefWindowProcW ( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam ) ;
ALIAS: DefWindowProc DefWindowProcW
! FUNCTION: DeleteMenu
! FUNCTION: DeregisterShellHookWindow
FUNCTION: BOOL DestroyAcceleratorTable ( HACCEL hAccel ) ;
! FUNCTION: DestroyCaret
! FUNCTION: DestroyCursor
! FUNCTION: DestroyIcon
! FUNCTION: DestroyMenu
! FUNCTION: DestroyReasons
FUNCTION: BOOL DestroyWindow ( HWND hWnd ) ;
! FUNCTION: DeviceEventWorker
! FUNCTION: DialogBoxIndirectParamA
! FUNCTION: DialogBoxIndirectParamAorW
! FUNCTION: DialogBoxIndirectParamW
! FUNCTION: DialogBoxParamA
! FUNCTION: DialogBoxParamW
! FUNCTION: DisableProcessWindowsGhosting

FUNCTION: LONG DispatchMessageW ( MSG* lpMsg ) ;
ALIAS: DispatchMessage DispatchMessageW

! FUNCTION: DisplayExitWindowsWarnings
! FUNCTION: DlgDirListA
! FUNCTION: DlgDirListComboBoxA
! FUNCTION: DlgDirListComboBoxW
! FUNCTION: DlgDirListW
! FUNCTION: DlgDirSelectComboBoxExA
! FUNCTION: DlgDirSelectComboBoxExW
! FUNCTION: DlgDirSelectExA
! FUNCTION: DlgDirSelectExW
! FUNCTION: DragDetect
! FUNCTION: DragObject


FUNCTION: BOOL DrawAnimatedRects ( HWND hWnd, int idAni, RECT* lprcFrom, RECT* lprcTo ) ;
! FUNCTION: BOOL DrawCaption ( HWND hWnd, HDC hdc, LPRECT lprc, UINT uFlags ) ;

! FUNCTION: DrawEdge
! FUNCTION: DrawFocusRect
! FUNCTION: DrawFrame
! FUNCTION: DrawFrameControl

FUNCTION: BOOL DrawIcon ( HDC hDC, int X, int Y, HICON hIcon ) ;

! FUNCTION: DrawIconEx
! FUNCTION: DrawMenuBar
! FUNCTION: DrawMenuBarTemp
! FUNCTION: DrawStateA
! FUNCTION: DrawStateW
! FUNCTION: DrawTextA
! FUNCTION: DrawTextExA
! FUNCTION: DrawTextExW
! FUNCTION: DrawTextW
! FUNCTION: EditWndProc
FUNCTION: BOOL EmptyClipboard ( ) ;
FUNCTION: BOOL EnableMenuItem ( HMENU hMenu, UINT uIDEnableItem, UINT uEnable ) ;
! FUNCTION: EnableScrollBar
! FUNCTION: EnableWindow
! FUNCTION: EndDeferWindowPos
! FUNCTION: EndDialog
! FUNCTION: EndMenu

FUNCTION: BOOL EndPaint ( HWND hWnd, PAINTSTRUCT* lpPaint) ;

! FUNCTION: EndTask
! FUNCTION: EnterReaderModeHelper
! FUNCTION: EnumChildWindows
FUNCTION: UINT EnumClipboardFormats ( UINT format ) ;
! FUNCTION: EnumDesktopsA
! FUNCTION: EnumDesktopsW
! FUNCTION: EnumDesktopWindows
! FUNCTION: EnumDisplayDevicesA
! FUNCTION: EnumDisplayDevicesW
! FUNCTION: BOOL EnumDisplayMonitors ( HDC hdc, LPCRECT lprcClip, MONITORENUMPROC lpfnEnum, LPARAM dwData ) ;
! FUNCTION: EnumDisplaySettingsA
! FUNCTION: EnumDisplaySettingsExA
! FUNCTION: EnumDisplaySettingsExW
FUNCTION: BOOL EnumDisplaySettingsW ( LPCTSTR lpszDeviceName, DWORD iModeNum, DEVMODE *lpDevMode ) ;
ALIAS: EnumDisplaySettings EnumDisplaySettingsW
! FUNCTION: EnumPropsA
! FUNCTION: EnumPropsExA
! FUNCTION: EnumPropsExW
! FUNCTION: EnumPropsW
! FUNCTION: EnumThreadWindows
! FUNCTION: EnumWindows
! FUNCTION: EnumWindowStationsA
! FUNCTION: EnumWindowStationsW
! FUNCTION: EqualRect
! FUNCTION: ExcludeUpdateRgn
! FUNCTION: ExitWindowsEx
FUNCTION: int FillRect ( HDC hDC, RECT* lprc, HBRUSH hbr ) ;
FUNCTION: HWND FindWindowA ( c-string lpClassName, c-string lpWindowName ) ;
FUNCTION: HWND FindWindowExA ( HWND hwndParent, HWND childAfter, c-string lpClassName, c-string lpWindowName ) ;
! FUNCTION: FindWindowExW
! FUNCTION: FindWindowW
! FUNCTION: FlashWindow
! FUNCTION: FlashWindowEx
! FUNCTION: FrameRect
! FUNCTION: FreeDDElParam
! FUNCTION: GetActiveWindow
! FUNCTION: GetAltTabInfo
! FUNCTION: GetAltTabInfoA
! FUNCTION: GetAltTabInfoW
! FUNCTION: GetAncestor
! FUNCTION: GetAppCompatFlags
! FUNCTION: GetAppCompatFlags2
! FUNCTION: GetAsyncKeyState
FUNCTION: HWND GetCapture ( ) ;
! FUNCTION: GetCaretBlinkTime
! FUNCTION: GetCaretPos
FUNCTION: BOOL GetClassInfoW ( HINSTANCE hInst, LPCWSTR lpszClass, LPWNDCLASS lpwcx ) ;
ALIAS: GetClassInfo GetClassInfoW

FUNCTION: BOOL GetClassInfoExW ( HINSTANCE hInst, LPCWSTR lpszClass, LPWNDCLASSEX lpwcx ) ;
ALIAS: GetClassInfoEx GetClassInfoExW

FUNCTION: ULONG_PTR GetClassLongW ( HWND hWnd, int nIndex ) ;
ALIAS: GetClassLong GetClassLongW
ALIAS: GetClassLongPtr GetClassLongW


! FUNCTION: GetClassNameA
! FUNCTION: GetClassNameW
! FUNCTION: GetClassWord
FUNCTION: BOOL GetClientRect ( HWND hWnd, LPRECT lpRect ) ;

FUNCTION: HANDLE GetClipboardData ( UINT uFormat ) ;

! FUNCTION: GetClipboardFormatNameA
! FUNCTION: GetClipboardFormatNameW
FUNCTION: HWND GetClipboardOwner ( ) ;
FUNCTION: DWORD GetClipboardSequenceNumber ( ) ;
! FUNCTION: GetClipboardViewer
! FUNCTION: GetClipCursor
! FUNCTION: GetComboBoxInfo
! FUNCTION: GetCursor
! FUNCTION: GetCursorFrameInfo
! FUNCTION: GetCursorInfo
! FUNCTION: GetCursorPos
FUNCTION: HDC GetDC ( HWND hWnd ) ;
FUNCTION: HDC GetDCEx ( HWND hWnd, HRGN hrgnClip, DWORD flags ) ;
FUNCTION: HWND GetDesktopWindow ( ) ;
! FUNCTION: GetDialogBaseUnits
! FUNCTION: GetDlgCtrlID
! FUNCTION: GetDlgItem
! FUNCTION: GetDlgItemInt
! FUNCTION: GetDlgItemTextA
! FUNCTION: GetDlgItemTextW
FUNCTION: uint GetDoubleClickTime ( ) ;
FUNCTION: HWND GetFocus ( ) ;
FUNCTION: HWND GetForegroundWindow ( ) ;
! FUNCTION: GetGuiResources
! FUNCTION: GetGUIThreadInfo
! FUNCTION: GetIconInfo
! FUNCTION: GetInputDesktop
! FUNCTION: GetInputState
! FUNCTION: GetInternalWindowPos
! FUNCTION: GetKBCodePage
! FUNCTION: GetKeyboardLayout
! FUNCTION: GetKeyboardLayoutList
! FUNCTION: GetKeyboardLayoutNameA
! FUNCTION: GetKeyboardLayoutNameW
! FUNCTION: GetKeyboardState
! FUNCTION: GetKeyboardType
! FUNCTION: GetKeyNameTextA
! FUNCTION: GetKeyNameTextW
FUNCTION: SHORT GetKeyState ( int nVirtKey ) ;
! FUNCTION: GetLastActivePopup
! FUNCTION: GetLastInputInfo
! FUNCTION: GetLayeredWindowAttributes
! FUNCTION: GetListBoxInfo
! FUNCTION: GetMenu
! FUNCTION: GetMenuBarInfo
! FUNCTION: GetMenuCheckMarkDimensions
! FUNCTION: GetMenuContextHelpId
! FUNCTION: GetMenuDefaultItem
! FUNCTION: GetMenuInfo
! FUNCTION: GetMenuItemCount
! FUNCTION: GetMenuItemID
! FUNCTION: GetMenuItemInfoA
! FUNCTION: GetMenuItemInfoW
! FUNCTION: GetMenuItemRect
! FUNCTION: GetMenuState
! FUNCTION: GetMenuStringA
! FUNCTION: GetMenuStringW

FUNCTION: BOOL GetMessageW ( LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax ) ;
ALIAS: GetMessage GetMessageW

! FUNCTION: GetMessageExtraInfo
! FUNCTION: GetMessagePos
! FUNCTION: GetMessageTime
! FUNCTION: GetMonitorInfoA

FUNCTION: BOOL GetMonitorInfoW ( HMONITOR hMonitor, LPMONITORINFO lpmi ) ;
ALIAS: GetMonitorInfo GetMonitorInfoW

! FUNCTION: GetMouseMovePointsEx
! FUNCTION: GetNextDlgGroupItem
! FUNCTION: GetNextDlgTabItem
! FUNCTION: GetOpenClipboardWindow
FUNCTION: HWND GetParent ( HWND hWnd ) ;
FUNCTION: int GetPriorityClipboardFormat ( UINT* paFormatPriorityList, int cFormats ) ;
! FUNCTION: GetProcessDefaultLayout
! FUNCTION: GetProcessWindowStation
! FUNCTION: GetProgmanWindow
! FUNCTION: GetPropA
! FUNCTION: GetPropW
! FUNCTION: GetQueueStatus
FUNCTION: UINT GetRawInputBuffer ( PRAWINPUT pData, PUINT pcbSize, UINT cbSizeHeader ) ;
FUNCTION: UINT GetRawInputData ( HRAWINPUT hRawInput, UINT uiCommand, LPVOID pData, PUINT pcbSize, UINT cbSizeHeader ) ;
FUNCTION: UINT GetRawInputDeviceInfoA ( HANDLE hDevice, UINT uiCommand, LPVOID pData, PUINT pcbSize ) ;
FUNCTION: UINT GetRawInputDeviceInfoW ( HANDLE hDevice, UINT uiCommand, LPVOID pData, PUINT pcbSize ) ;
ALIAS: GetRawInputDeviceInfo GetRawInputDeviceInfoW
FUNCTION: UINT GetRawInputDeviceList ( PRAWINPUTDEVICELIST pRawInputDeviceList, PUINT puiNumDevices, UINT cbSize ) ;
FUNCTION: UINT GetRegisteredRawInputDevices ( PRAWINPUTDEVICE pRawInputDevices, PUINT puiNumDevices, UINT cbSize ) ;
! FUNCTION: GetReasonTitleFromReasonCode
! FUNCTION: GetScrollBarInfo
! FUNCTION: GetScrollInfo
! FUNCTION: GetScrollPos
! FUNCTION: GetScrollRange
! FUNCTION: GetShellWindow
! FUNCTION: GetSubMenu
FUNCTION: COLORREF GetSysColor ( int nIndex ) ;
FUNCTION: HBRUSH GetSysColorBrush ( int nIndex ) ;
FUNCTION: HMENU GetSystemMenu ( HWND hWnd, BOOL bRevert ) ;
! FUNCTION: GetSystemMetrics
! FUNCTION: GetTabbedTextExtentA
! FUNCTION: GetTabbedTextExtentW
! FUNCTION: GetTaskmanWindow
! FUNCTION: GetThreadDesktop
! FUNCTION: GetTitleBarInfo


FUNCTION: HWND GetTopWindow ( HWND hWnd ) ;
! FUNCTION: BOOL GetUpdateRect ( HWND hWnd, LPRECT lpRect, BOOL bErase ) ;
FUNCTION: int GetUpdateRgn ( HWND hWnd, HRGN hRgn, BOOL bErase ) ;


! FUNCTION: GetUserObjectInformationA
! FUNCTION: GetUserObjectInformationW
! FUNCTION: GetUserObjectSecurity
FUNCTION: HWND GetWindow ( HWND hWnd, UINT uCmd ) ;
! FUNCTION: GetWindowContextHelpId
! FUNCTION: GetWindowDC
! FUNCTION: GetWindowInfo
! FUNCTION: GetWindowLongA
! FUNCTION: GetWindowLongW
FUNCTION: LONG_PTR GetWindowLongW ( HANDLE hWnd, int index ) ;
ALIAS: GetWindowLong GetWindowLongW

FUNCTION: LONG_PTR GetWindowLongPtrW ( HWND hWnd, int nIndex ) ;
ALIAS: GetWindowLongPtr GetWindowLongPtrW
! FUNCTION: GetWindowModuleFileName
! FUNCTION: GetWindowModuleFileNameA
! FUNCTION: GetWindowModuleFileNameW
! FUNCTION: GetWindowPlacement
FUNCTION: BOOL GetWindowRect ( HWND hWnd, LPRECT lpRect ) ;
! FUNCTION: GetWindowRgn
! FUNCTION: GetWindowRgnBox
FUNCTION: int GetWindowTextA ( HWND hWnd, char* lpString, int nMaxCount ) ;
! FUNCTION: GetWindowTextLengthA
! FUNCTION: GetWindowTextLengthW
! FUNCTION: GetWindowTextW
FUNCTION: DWORD GetWindowThreadProcessId ( HWND hWnd, void* lpdwProcessId ) ;
! FUNCTION: GetWindowWord
! FUNCTION: GetWinStationInfo
! FUNCTION: GrayStringA
! FUNCTION: GrayStringW
! FUNCTION: HideCaret
! FUNCTION: HiliteMenuItem
! FUNCTION: ImpersonateDdeClientWindow
! FUNCTION: IMPGetIMEA
! FUNCTION: IMPGetIMEW
! FUNCTION: IMPQueryIMEA
! FUNCTION: IMPQueryIMEW
! FUNCTION: IMPSetIMEA
! FUNCTION: IMPSetIMEW
! FUNCTION: InflateRect
! FUNCTION: InitializeLpkHooks
! FUNCTION: InitializeWin32EntryTable
! FUNCTION: InSendMessage
! FUNCTION: InSendMessageEx
! FUNCTION: InsertMenuA
! FUNCTION: InsertMenuItemA
! FUNCTION: InsertMenuItemW
! FUNCTION: InsertMenuW
! FUNCTION: InternalGetWindowText
! FUNCTION: IntersectRect
! FUNCTION: InvalidateRect
! FUNCTION: InvalidateRgn
! FUNCTION: InvertRect
! FUNCTION: IsCharAlphaA
! FUNCTION: IsCharAlphaNumericA
! FUNCTION: IsCharAlphaNumericW
! FUNCTION: IsCharAlphaW
! FUNCTION: IsCharLowerA
! FUNCTION: IsCharLowerW
! FUNCTION: IsCharUpperA
! FUNCTION: IsCharUpperW
FUNCTION: BOOL IsChild ( HWND hWndParent, HWND hWnd ) ;
FUNCTION: BOOL IsClipboardFormatAvailable ( UINT format ) ;
! FUNCTION: IsDialogMessage
! FUNCTION: IsDialogMessageA
! FUNCTION: IsDialogMessageW
! FUNCTION: IsDlgButtonChecked
FUNCTION: BOOL IsGUIThread ( BOOL bConvert ) ;
FUNCTION: BOOL IsHungAppWindow ( HWND hWnd ) ;
FUNCTION: BOOL IsIconic ( HWND hWnd ) ;
FUNCTION: BOOL IsMenu ( HMENU hMenu ) ;
! FUNCTION: BOOL IsRectEmpty
! FUNCTION: BOOL IsServerSideWindow
FUNCTION: BOOL IsWindow ( HWND hWnd ) ;
! FUNCTION: BOOL IsWindowEnabled
! FUNCTION: BOOL IsWindowInDestroy
FUNCTION: BOOL IsWindowUnicode ( HWND hWnd ) ;
FUNCTION: BOOL IsWindowVisible ( HWND hWnd ) ;
! FUNCTION: BOOL IsWinEventHookInstalled
FUNCTION: BOOL IsZoomed ( HWND hWnd ) ;
! FUNCTION: keybd_event
! FUNCTION: KillSystemTimer
! FUNCTION: KillTimer
! FUNCTION: LoadAcceleratorsA
FUNCTION: HACCEL LoadAcceleratorsW ( HINSTANCE hInstance, LPCTSTR lpTableName ) ;
! FUNCTION: LoadBitmapA
! FUNCTION: LoadBitmapW
! FUNCTION: LoadCursorFromFileA
! FUNCTION: LoadCursorFromFileW


! FUNCTION: HCURSOR LoadCursorW ( HINSTANCE hInstance, LPCWSTR lpCursorName ) ;
FUNCTION: HCURSOR LoadCursorW ( HINSTANCE hInstance, ushort lpCursorName ) ;
ALIAS: LoadCursor LoadCursorW

! FUNCTION: HICON LoadIconA ( HINSTANCE hInstance, LPCTSTR lpIconName ) ;
FUNCTION: HICON LoadIconW ( HINSTANCE hInstance, LPCTSTR lpIconName ) ;
ALIAS: LoadIcon LoadIconW

! FUNCTION: LoadImageA
! FUNCTION: LoadImageW
! FUNCTION: LoadKeyboardLayoutA
! FUNCTION: LoadKeyboardLayoutEx
! FUNCTION: LoadKeyboardLayoutW
! FUNCTION: LoadLocalFonts
! FUNCTION: LoadMenuA
! FUNCTION: LoadMenuIndirectA
! FUNCTION: LoadMenuIndirectW
! FUNCTION: LoadMenuW
! FUNCTION: LoadRemoteFonts
! FUNCTION: LoadStringA
! FUNCTION: LoadStringW
! FUNCTION: LockSetForegroundWindow
! FUNCTION: LockWindowStation
! FUNCTION: LockWindowUpdate
! FUNCTION: LockWorkStation
! FUNCTION: LookupIconIdFromDirectory
! FUNCTION: LookupIconIdFromDirectoryEx
! FUNCTION: MapDialogRect

FUNCTION: UINT MapVirtualKeyW ( UINT uCode, UINT uMapType ) ;
ALIAS: MapVirtualKey MapVirtualKeyW

FUNCTION: UINT MapVirtualKeyExW ( UINT uCode, UINT uMapType, HKL dwhkl ) ;
ALIAS: MapVirtualKeyEx MapVirtualKeyExW

! FUNCTION: MapWindowPoints
! FUNCTION: MB_GetString
! FUNCTION: MBToWCSEx
! FUNCTION: MenuItemFromPoint
! FUNCTION: MenuWindowProcA
! FUNCTION: MenuWindowProcW

! -1 is Simple beep
FUNCTION: BOOL MessageBeep ( UINT uType ) ;

FUNCTION: int MessageBoxA ( 
                HWND hWnd,
                LPCSTR lpText,
                LPCSTR lpCaption,
                UINT uType ) ;

FUNCTION: int MessageBoxW (
                HWND hWnd,
                LPCWSTR lpText,
                LPCWSTR lpCaption,
                UINT uType) ;

FUNCTION: int MessageBoxExA ( HWND hWnd,
                LPCSTR lpText,
                LPCSTR lpCaption,
                UINT uType,
                WORD wLanguageId
                ) ;

FUNCTION: int MessageBoxExW (
                HWND hWnd,
                LPCWSTR lpText,
                LPCWSTR lpCaption,
                UINT uType,
                WORD wLanguageId ) ;

! FUNCTION: int MessageBoxIndirectA ( MSGBOXPARAMSA* params ) ;
! FUNCTION: int MessageBoxIndirectW ( MSGBOXPARAMSW* params ) ;


ALIAS: MessageBox MessageBoxW

ALIAS: MessageBoxEx MessageBoxExW

! : MessageBoxIndirect
    ! \ MessageBoxIndirectW \ MessageBoxIndirectA unicode-exec ;

! FUNCTION: MessageBoxTimeoutA ! dllexported, not in header
! FUNCTION: MessageBoxTimeoutW ! dllexported, not in header

! FUNCTION: ModifyMenuA
! FUNCTION: ModifyMenuW
! FUNCTION: MonitorFromPoint
! FUNCTION: MonitorFromRect
FUNCTION: HMONITOR MonitorFromWindow ( HWND hWnd, DWORD dwFlags ) ;
! FUNCTION: mouse_event


FUNCTION: BOOL MoveWindow (
    HWND hWnd,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    BOOL bRepaint ) ;

! FUNCTION: MsgWaitForMultipleObjects
! FUNCTION: MsgWaitForMultipleObjectsEx
! FUNCTION: NotifyWinEvent
! FUNCTION: OemKeyScan
! FUNCTION: OemToCharA
! FUNCTION: OemToCharBuffA
! FUNCTION: OemToCharBuffW
! FUNCTION: OemToCharW
! FUNCTION: OffsetRect
FUNCTION: BOOL OpenClipboard ( HWND hWndNewOwner ) ;
! FUNCTION: OpenDesktopA
! FUNCTION: OpenDesktopW
! FUNCTION: OpenIcon
! FUNCTION: OpenInputDesktop
! FUNCTION: OpenWindowStationA
! FUNCTION: OpenWindowStationW
! FUNCTION: PackDDElParam
! FUNCTION: PaintDesktop
! FUNCTION: PaintMenuBar
FUNCTION: BOOL PeekMessageA ( LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg ) ;
FUNCTION: BOOL PeekMessageW ( LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg ) ;
ALIAS: PeekMessage PeekMessageW

! FUNCTION: PostMessageA
! FUNCTION: PostMessageW
FUNCTION: void PostQuitMessage ( int nExitCode ) ;
! FUNCTION: PostThreadMessageA
! FUNCTION: PostThreadMessageW
! FUNCTION: PrintWindow
! FUNCTION: PrivateExtractIconExA
! FUNCTION: PrivateExtractIconExW
! FUNCTION: PrivateExtractIconsA
! FUNCTION: PrivateExtractIconsW
! FUNCTION: PrivateSetDbgTag
! FUNCTION: PrivateSetRipFlags
! FUNCTION: PtInRect
! FUNCTION: QuerySendMessage
! FUNCTION: QueryUserCounters
! FUNCTION: RealChildWindowFromPoint
! FUNCTION: RealGetWindowClass
! FUNCTION: RealGetWindowClassA
! FUNCTION: RealGetWindowClassW
! FUNCTION: ReasonCodeNeedsBugID
! FUNCTION: ReasonCodeNeedsComment
! FUNCTION: RecordShutdownReason
! FUNCTION: RedrawWindow

FUNCTION: ATOM RegisterClassA ( WNDCLASS* lpWndClass ) ;
FUNCTION: ATOM RegisterClassW ( WNDCLASS* lpWndClass ) ;
FUNCTION: ATOM RegisterClassExA ( WNDCLASSEX* lpwcx ) ;
FUNCTION: ATOM RegisterClassExW ( WNDCLASSEX* lpwcx ) ;

ALIAS: RegisterClass RegisterClassW
ALIAS: RegisterClassEx RegisterClassExW

! FUNCTION: RegisterClipboardFormatA
! FUNCTION: RegisterClipboardFormatW
FUNCTION: HANDLE RegisterDeviceNotificationA ( HANDLE hRecipient, LPVOID NotificationFilter, DWORD Flags ) ;
FUNCTION: HANDLE RegisterDeviceNotificationW ( HANDLE hRecipient, LPVOID NotificationFilter, DWORD Flags ) ;
ALIAS: RegisterDeviceNotification RegisterDeviceNotificationW
! FUNCTION: RegisterHotKey
! FUNCTION: RegisterLogonProcess
! FUNCTION: RegisterMessagePumpHook
FUNCTION: BOOL RegisterRawInputDevices ( PCRAWINPUTDEVICE pRawInputDevices, UINT uiNumDevices, UINT cbSize ) ;
! FUNCTION: RegisterServicesProcess
! FUNCTION: RegisterShellHookWindow
! FUNCTION: RegisterSystemThread
! FUNCTION: RegisterTasklist
! FUNCTION: RegisterUserApiHook
! FUNCTION: RegisterWindowMessageA
! FUNCTION: RegisterWindowMessageW
FUNCTION: BOOL ReleaseCapture ( ) ;
FUNCTION: int ReleaseDC ( HWND hWnd, HDC hDC ) ;
! FUNCTION: RemoveMenu
! FUNCTION: RemovePropA
! FUNCTION: RemovePropW
! FUNCTION: ReplyMessage
! FUNCTION: ResolveDesktopForWOW
! FUNCTION: ReuseDDElParam
! FUNCTION: ScreenToClient
! FUNCTION: ScrollChildren
! FUNCTION: ScrollDC
! FUNCTION: ScrollWindow
! FUNCTION: ScrollWindowEx
! FUNCTION: SendDlgItemMessageA
! FUNCTION: SendDlgItemMessageW
! FUNCTION: SendIMEMessageExA
! FUNCTION: SendIMEMessageExW
! FUNCTION: UINT SendInput ( UINT nInputs, LPINPUT pInputs, int cbSize ) ;
FUNCTION: LRESULT SendMessageW ( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam ) ;
ALIAS: SendMessage SendMessageW
! FUNCTION: SendMessageCallbackA
! FUNCTION: SendMessageCallbackW
! FUNCTION: SendMessageTimeoutA
! FUNCTION: SendMessageTimeoutW
! FUNCTION: SendNotifyMessageA
! FUNCTION: SendNotifyMessageW
! FUNCTION: SetActiveWindow
FUNCTION: HWND SetCapture ( HWND hWnd ) ;
! FUNCTION: SetCaretBlinkTime
! FUNCTION: SetCaretPos

FUNCTION: ULONG_PTR SetClassLongW ( HWND hWnd, int nIndex, LONG_PTR dwNewLong ) ;
ALIAS: SetClassLongPtr SetClassLongW
ALIAS: SetClassLong SetClassLongW

! FUNCTION: SetClassWord
FUNCTION: HANDLE SetClipboardData ( UINT uFormat, HANDLE hMem ) ;
! FUNCTION: SetClipboardViewer
! FUNCTION: SetConsoleReserveKeys
! FUNCTION: SetCursor
! FUNCTION: SetCursorContents
! FUNCTION: SetCursorPos
! FUNCTION: SetDebugErrorLevel
! FUNCTION: SetDeskWallpaper
! FUNCTION: SetDlgItemInt
! FUNCTION: SetDlgItemTextA
! FUNCTION: SetDlgItemTextW
! FUNCTION: SetDoubleClickTime
FUNCTION: HWND SetFocus ( HWND hWnd ) ;
FUNCTION: BOOL SetForegroundWindow ( HWND hWnd ) ;
! FUNCTION: SetInternalWindowPos
! FUNCTION: SetKeyboardState
! type is ignored
FUNCTION: void SetLastErrorEx ( DWORD dwErrCode, DWORD dwType ) ; 
: SetLastError ( errcode -- ) 0 SetLastErrorEx ; inline
! FUNCTION: SetLayeredWindowAttributes
! FUNCTION: SetLogonNotifyWindow
! FUNCTION: SetMenu
! FUNCTION: SetMenuContextHelpId
! FUNCTION: SetMenuDefaultItem
! FUNCTION: SetMenuInfo
! FUNCTION: SetMenuItemBitmaps
! FUNCTION: SetMenuItemInfoA
! FUNCTION: SetMenuItemInfoW
! FUNCTION: SetMessageExtraInfo
! FUNCTION: SetMessageQueue
! FUNCTION: SetParent
! FUNCTION: SetProcessDefaultLayout
! FUNCTION: SetProcessWindowStation
! FUNCTION: SetProgmanWindow
! FUNCTION: SetPropA
! FUNCTION: SetPropW
! FUNCTION: SetRect
! FUNCTION: SetRectEmpty
! FUNCTION: SetScrollInfo
! FUNCTION: SetScrollPos
! FUNCTION: SetScrollRange
! FUNCTION: SetShellWindow
! FUNCTION: SetShellWindowEx
! FUNCTION: SetSysColors
! FUNCTION: SetSysColorsTemp
! FUNCTION: SetSystemCursor
! FUNCTION: SetSystemMenu
! FUNCTION: SetSystemTimer
! FUNCTION: SetTaskmanWindow
! FUNCTION: SetThreadDesktop
! FUNCTION: SetTimer
! FUNCTION: SetUserObjectInformationA
! FUNCTION: SetUserObjectInformationW
! FUNCTION: SetUserObjectSecurity
! FUNCTION: SetWindowContextHelpId
! FUNCTION: SetWindowLongA
! FUNCTION: SetWindowLongW
FUNCTION: LONG_PTR SetWindowLongW ( HANDLE hWnd, int index, LONG_PTR dwNewLong ) ;
ALIAS: SetWindowLong SetWindowLongW
! FUNCTION: SetWindowPlacement
FUNCTION: BOOL SetWindowPos ( HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, UINT uFlags ) ;

FUNCTION: LONG_PTR SetWindowLongPtrW ( HWND hWnd, int nIndex, LONG_PTR dwNewLong ) ;
ALIAS: SetWindowLongPtr SetWindowLongPtrW

: HWND_BOTTOM ( -- alien ) 1 <alien> ;
: HWND_NOTOPMOST ( -- alien ) -2 <alien> ;
CONSTANT: HWND_TOP f
: HWND_TOPMOST ( -- alien ) -1 <alien> ;

! FUNCTION: SetWindowRgn
! FUNCTION: SetWindowsHookA
! FUNCTION: SetWindowsHookExA
! FUNCTION: SetWindowsHookExW
! FUNCTION: SetWindowsHookW
! FUNCTION: SetWindowStationUser
! FUNCTION: SetWindowTextA
! FUNCTION: SetWindowTextW
! FUNCTION: SetWindowWord
! FUNCTION: SetWinEventHook
! FUNCTION: ShowCaret
FUNCTION: int ShowCursor ( BOOL show ) ;
! FUNCTION: ShowOwnedPopups
! FUNCTION: ShowScrollBar
! FUNCTION: ShowStartGlass

FUNCTION: BOOL ShowWindow ( HWND hWnd, int nCmdShow ) ;

! FUNCTION: ShowWindowAsync
! FUNCTION: SoftModalMessageBox
! FUNCTION: SubtractRect
! FUNCTION: SwapMouseButton
! FUNCTION: SwitchDesktop
! FUNCTION: SwitchToThisWindow
! FUNCTION: SystemParametersInfoA

FUNCTION: BOOL SystemParametersInfoW ( UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni ) ;
ALIAS: SystemParametersInfo SystemParametersInfoW

! FUNCTION: TabbedTextOutA
! FUNCTION: TabbedTextOutW
! FUNCTION: TileChildWindows
! FUNCTION: TileWindows
! FUNCTION: ToAscii
! FUNCTION: ToAsciiEx
! FUNCTION: ToUnicode
! FUNCTION: ToUnicodeEx
FUNCTION: BOOL TrackMouseEvent ( LPTRACKMOUSEEVENT lpEventTrack ) ;
! FUNCTION: TrackPopupMenu
! FUNCTION: TrackPopupMenuEx
! FUNCTION: TranslateAccelerator
! FUNCTION: TranslateAcceleratorA
FUNCTION: int TranslateAcceleratorW ( HWND hWnd, HACCEL hAccTable, LPMSG lpMsg ) ;
ALIAS: TranslateAccelerator TranslateAcceleratorW

! FUNCTION: TranslateMDISysAccel
FUNCTION: BOOL TranslateMessage ( MSG* lpMsg ) ;

! FUNCTION: UnhookWindowsHook
! FUNCTION: UnhookWindowsHookEx
! FUNCTION: UnhookWinEvent
! FUNCTION: UnionRect
! FUNCTION: UnloadKeyboardLayout
! FUNCTION: UnlockWindowStation
! FUNCTION: UnpackDDElParam
FUNCTION: BOOL UnregisterClassW ( LPCWSTR lpClassName, HINSTANCE hInstance ) ;
ALIAS: UnregisterClass UnregisterClassW
FUNCTION: BOOL UnregisterDeviceNotification ( HANDLE hDevNotify ) ;
! FUNCTION: UnregisterHotKey
! FUNCTION: UnregisterMessagePumpHook
! FUNCTION: UnregisterUserApiHook
! FUNCTION: UpdateLayeredWindow
! FUNCTION: UpdatePerUserSystemParameters

FUNCTION: BOOL UpdateWindow ( HWND hWnd ) ;

! FUNCTION: User32InitializeImmEntryTable
! FUNCTION: UserClientDllInitialize
! FUNCTION: UserHandleGrantAccess
! FUNCTION: UserLpkPSMTextOut
! FUNCTION: UserLpkTabbedTextOut
! FUNCTION: UserRealizePalette
! FUNCTION: UserRegisterWowHandlers
! FUNCTION: ValidateRect
! FUNCTION: ValidateRgn
! FUNCTION: VkKeyScanA
! FUNCTION: VkKeyScanExA
! FUNCTION: VkKeyScanExW
! FUNCTION: VkKeyScanW
! FUNCTION: VRipOutput
! FUNCTION: VTagOutput
! FUNCTION: WaitForInputIdle
! FUNCTION: WaitMessage
! FUNCTION: WCSToMBEx
! FUNCTION: Win32PoolAllocationStats
! FUNCTION: WindowFromDC
! FUNCTION: WindowFromPoint
! FUNCTION: WinHelpA
! FUNCTION: WinHelpW
! FUNCTION: WINNLSEnableIME
! FUNCTION: WINNLSGetEnableStatus
! FUNCTION: WINNLSGetIMEHotkey
! FUNCTION: wsprintfA
! FUNCTION: wsprintfW
! FUNCTION: wvsprintfA
! FUNCTION: wvsprintfW

: msgbox ( str -- )
    f swap "DebugMsg" MB_OK MessageBox drop ;
