/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.PrimType;
import gnu.bytecode.TypeVariable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import nice.tools.code.SpecialArray;

public abstract class Type {
    String signature;
    String this_name;
    int size;
    public boolean collectable;
    private static Map mapClassToType;
    static Hashtable mapNameToType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType neverReturnsType;
    public static final PrimType void_type;
    public static ClassType int_ctype;
    public static ClassType long_ctype;
    public static ClassType char_ctype;
    public static ClassType float_ctype;
    public static ClassType double_ctype;
    public static final ObjectType nullType;
    public static ClassType string_type;
    public static ClassType tostring_type;
    public static ClassType pointer_type;
    public static ClassType boolean_ctype;
    public static ClassType throwable_type;
    public static ClassType short_ctype;
    public static ClassType byte_ctype;
    public static Type[] typeArray0;
    public static Method toString_method;
    public static ClassType number_type;
    public static Method intValue_method;
    public static Method longValue_method;
    public static Method floatValue_method;
    public static Method doubleValue_method;
    public static Method booleanValue_method;
    public static ClassType character_type;
    public static Method charValue_method;
    protected Class reflectClass;

    Type() {
    }

    public Type getImplementationType() {
        return this;
    }

    public static void free(Map t) {
        Iterator e = t.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry k = e.next();
            if (!((Type)k.getValue()).collectable) continue;
            e.remove();
        }
    }

    public static void reset() {
        mapClassToType.clear();
        Type.free(mapNameToType);
    }

    static Hashtable getMapNameToType() {
        if (mapNameToType == null) {
            mapNameToType = new Hashtable();
            mapNameToType.put("byte", byte_type);
            mapNameToType.put("short", short_type);
            mapNameToType.put("int", int_type);
            mapNameToType.put("long", long_type);
            mapNameToType.put("float", float_type);
            mapNameToType.put("double", double_type);
            mapNameToType.put("boolean", boolean_type);
            mapNameToType.put("char", char_type);
            mapNameToType.put("void", void_type);
        }
        return mapNameToType;
    }

    public static Type lookupType(String name) {
        return (Type)Type.getMapNameToType().get(name);
    }

    public static Type getType(String name) {
        Type type = Type.lookupType(name);
        if (type == null) {
            if (name.endsWith("[]")) {
                type = Type.getType(name.substring(0, name.length() - 2));
                type = SpecialArray.create(type);
            } else {
                type = new ClassType(name, 4);
            }
            mapNameToType.put(name, type);
        }
        return type;
    }

    public static void registerTypeForName(String name, Type type) {
        mapNameToType.put(name, type);
    }

    public static void registerTypeForClass(Class clas, Type type) {
        if (mapClassToType == null) {
            mapClassToType = new HashMap(100);
        }
        mapClassToType.put(clas, type);
        type.reflectClass = clas;
    }

    public static void flushTypeChanges() {
        Enumeration types = mapNameToType.elements();
        while (types.hasMoreElements()) {
            Object t = types.nextElement();
            if (!(t instanceof ClassType)) continue;
            ClassType type = (ClassType)t;
            if ((type.flags & 2) == 0) continue;
            type.last_method = null;
            type.methods = null;
            type.methods_count = 0;
            type.addMethods(type.getReflectClass());
        }
    }

    public static Type make(Class reflectClass) {
        Object t;
        if (mapClassToType != null && (t = mapClassToType.get(reflectClass)) != null) {
            return (Type)t;
        }
        Type type = Type.lookupType(reflectClass.getName());
        if (type != null) {
            return type;
        }
        if (reflectClass.isArray()) {
            type = SpecialArray.create(Type.make(reflectClass.getComponentType()));
        } else {
            if (reflectClass.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            String name = reflectClass.getName();
            type = Type.lookupType(name);
            if (type == null || type.reflectClass != reflectClass && type.reflectClass != null) {
                ClassType cl = new ClassType(name);
                cl.flags |= 4;
                type = cl;
                mapNameToType.put(name, type);
            }
            if (reflectClass.isInterface()) {
                ((ClassType)type).access_flags |= 0x200;
            }
        }
        type.reflectClass = reflectClass;
        Type.registerTypeForClass(reflectClass, type);
        return type;
    }

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String sig) {
        this.signature = sig.intern();
    }

    Type(String nam, String sig) {
        this.this_name = nam;
        this.signature = sig.intern();
    }

    public Type promote() {
        return this.size < 4 ? int_type : this;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isVoid() {
        return this.size == 0;
    }

    public boolean isArray() {
        return false;
    }

    public static PrimType signatureToPrimitive(char sig) {
        switch (sig) {
            case 'B': {
                return byte_type;
            }
            case 'C': {
                return char_type;
            }
            case 'D': {
                return double_type;
            }
            case 'F': {
                return float_type;
            }
            case 'S': {
                return short_type;
            }
            case 'I': {
                return int_type;
            }
            case 'J': {
                return long_type;
            }
            case 'Z': {
                return boolean_type;
            }
            case 'V': {
                return void_type;
            }
        }
        return null;
    }

    public static Type signatureToType(String sig, int off, int len) {
        Type type;
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(off);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(sig, off + 1, len - 1);
            return type == null ? null : SpecialArray.create(type);
        }
        if (c == 'L' && len > 2 && sig.indexOf(59, off) == len - 1 + off) {
            return Type.getType(sig.substring(off + 1, len - 1 + off).replace('/', '.'));
        }
        return null;
    }

    public static Type signatureToType(String sig) {
        return Type.signatureToType(sig, 0, sig.length());
    }

    public static int signatureLength(String sig, int pos) {
        int end;
        int len = sig.length();
        if (len <= pos) {
            return -1;
        }
        char c = sig.charAt(pos);
        int arrays = 0;
        while (c == '[') {
            ++arrays;
            c = sig.charAt(++pos);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return arrays + 1;
        }
        if (c == 'L' && (end = sig.indexOf(59, pos)) > 0) {
            return arrays + end + 1 - pos;
        }
        return -1;
    }

    public static int signatureLength(String sig) {
        return Type.signatureLength(sig, 0);
    }

    public static Type fullSignatureToType(String sig, int[] offset) {
        int n = offset[0];
        offset[0] = n + 1;
        char c = sig.charAt(n);
        Type type = Type.signatureToPrimitive(c);
        if (type != null) {
            return type;
        }
        if (c == '[') {
            type = Type.fullSignatureToType(sig, offset);
            return type == null ? null : SpecialArray.create(type);
        }
        if (c == 'L') {
            int angle;
            int colon = sig.indexOf(59, offset[0]);
            int end = colon < (angle = sig.indexOf(60, offset[0])) || angle == -1 ? colon : angle;
            type = Type.getType(sig.substring(offset[0], end).replace('/', '.'));
            offset[0] = end + 1;
            if (end == colon) {
                return type;
            }
            type = new ParameterizedType((ClassType)type, Type.parseArgs(sig, offset));
            offset[0] = offset[0] + 1;
            return type;
        }
        if (c == 'T') {
            int end = sig.indexOf(59, offset[0]);
            type = TypeVariable.lookup(sig.substring(offset[0], end));
            offset[0] = end + 1;
            return type;
        }
        offset[0] = offset[0] - 1;
        return null;
    }

    private static Type[] parseArgs(String sig, int[] offset) {
        Stack<Type> args = new Stack<Type>();
        do {
            args.push(Type.fullSignatureToType(sig, offset));
        } while (sig.charAt(offset[0]) != '>');
        offset[0] = offset[0] + 1;
        Type[] res = new Type[args.size()];
        int i = args.size();
        while (--i >= 0) {
            res[i] = (Type)args.pop();
        }
        return res;
    }

    public static String signatureToName(String sig) {
        PrimType type;
        int len = sig.length();
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(0);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type.getName();
        }
        if (c == '[') {
            int arrays = 1;
            if (arrays < len && sig.charAt(arrays) == '[') {
                ++arrays;
            }
            if ((sig = Type.signatureToName(sig.substring(arrays))) == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer(50);
            buf.append(sig);
            while (--arrays >= 0) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (c == 'L' && len > 2 && sig.indexOf(59) == len - 1) {
            return sig.substring(1, len - 1).replace('/', '.');
        }
        return null;
    }

    public String getName() {
        return this.this_name;
    }

    public static boolean isValidJavaTypeName(String name) {
        int i;
        int len;
        boolean in_name = false;
        for (len = name.length(); len > 2 && name.charAt(len - 1) == ']' && name.charAt(len - 2) == '['; len -= 2) {
        }
        for (i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '.') {
                if (in_name) {
                    in_name = false;
                    continue;
                }
                return false;
            }
            if (in_name ? Character.isJavaIdentifierPart(ch) : Character.isJavaIdentifierStart(ch)) {
                in_name = true;
                continue;
            }
            return false;
        }
        return i == len;
    }

    public boolean isInstance(Object obj) {
        return this.getReflectClass().isInstance(obj);
    }

    public boolean isSubtype(Type other) {
        int comp = this.compare(other);
        return comp == -1 || comp == 0;
    }

    public abstract boolean isAssignableTo(Type var1);

    public static Type lowestCommonSuperType(Type t1, Type t2) {
        if (t1 == neverReturnsType) {
            return t2;
        }
        if (t2 == neverReturnsType) {
            return t1;
        }
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1 == t2) {
            return t1;
        }
        if (t1.isSubtype(t2)) {
            return t2;
        }
        if (t2.isSubtype(t1)) {
            return t1;
        }
        if (t1 == char_type && t2.isSubtype(int_type)) {
            return int_type;
        }
        if (t2 == char_type && t1.isSubtype(int_type)) {
            return int_type;
        }
        if (!(t1 instanceof ClassType) || !(t2 instanceof ClassType)) {
            return null;
        }
        ClassType c1 = (ClassType)t1;
        ClassType c2 = (ClassType)t2;
        if (c1.isInterface()) {
            return pointer_type;
        }
        if (c2.isInterface()) {
            return pointer_type;
        }
        return Type.lowestCommonSuperType(c1.getSuperclass(), c2.getSuperclass());
    }

    public abstract int compare(Type var1);

    protected static int swappedCompareResult(int code) {
        return code == 1 ? -1 : (code == -1 ? 1 : code);
    }

    public static boolean isMoreSpecific(Type[] t1, Type[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        int i = t1.length;
        while (--i >= 0) {
            if (t1[i].isSubtype(t2[i])) continue;
            return false;
        }
        return true;
    }

    public void emitIsInstance(CodeAttr code) {
        code.emitInstanceof(this);
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object obj) {
        return obj;
    }

    public void emitCoerceToObject(CodeAttr code) {
    }

    public void emitCoerceTo(Type toType, CodeAttr code) {
        this.emitCoerceToObject(code);
    }

    public void emitCoerceFrom(Type fromType, CodeAttr code) {
    }

    public void emitCoerceFromObject(CodeAttr code) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    Method refineMethod(Method method) {
        return null;
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public String toString() {
        return "Type " + this.getName();
    }

    static {
        byte_type = new PrimType("byte", "B", 1, Byte.TYPE);
        short_type = new PrimType("short", "S", 2, Short.TYPE);
        int_type = new PrimType("int", "I", 4, Integer.TYPE);
        long_type = new PrimType("long", "J", 8, Long.TYPE);
        float_type = new PrimType("float", "F", 4, Float.TYPE);
        double_type = new PrimType("double", "D", 8, Double.TYPE);
        boolean_type = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        char_type = new PrimType("char", "C", 2, Character.TYPE);
        neverReturnsType = new PrimType("(never-returns)", "V", 0, Void.TYPE);
        void_type = new PrimType("void", "V", 0, Void.TYPE);
        int_ctype = ClassType.make("java.lang.Integer");
        long_ctype = ClassType.make("java.lang.Long");
        char_ctype = ClassType.make("java.lang.Character");
        float_ctype = ClassType.make("java.lang.Float");
        double_ctype = ClassType.make("java.lang.Double");
        nullType = new ObjectType("(type of null)");
        string_type = ClassType.make("java.lang.String");
        tostring_type = new ClassType("java.lang.String");
        pointer_type = ClassType.make("java.lang.Object");
        boolean_ctype = ClassType.make("java.lang.Boolean");
        throwable_type = ClassType.make("java.lang.Throwable");
        short_ctype = ClassType.make("java.lang.Short");
        byte_ctype = ClassType.make("java.lang.Byte");
        typeArray0 = new Type[0];
        toString_method = pointer_type.getDeclaredMethod("toString", 0);
        number_type = ClassType.make("java.lang.Number");
        intValue_method = number_type.addMethod("intValue", typeArray0, int_type, 1);
        longValue_method = number_type.addMethod("longValue", typeArray0, long_type, 1);
        floatValue_method = number_type.addMethod("floatValue", typeArray0, float_type, 1);
        doubleValue_method = number_type.addMethod("doubleValue", typeArray0, double_type, 1);
        booleanValue_method = boolean_ctype.addMethod("booleanValue", typeArray0, boolean_type, 1);
        character_type = ClassType.make("java.lang.Character");
        charValue_method = character_type.addMethod("charValue", typeArray0, char_type, 1);
    }
}

