/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.Consumer;
import gnu.lists.Sequence;
import gnu.lists.TreeList;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import gnu.mapping.SFormat;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class Values
extends TreeList
implements Printable,
Externalizable {
    public static final Object[] noArgs = new Object[0];
    public static final Values empty = new Values(noArgs);

    public Values() {
    }

    public Values(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.writeObject(values[i]);
        }
    }

    public Object[] getValues() {
        return this.isEmpty() ? noArgs : this.toArray();
    }

    public static Object values$V(Object[] vals) {
        return Values.make(vals);
    }

    public static Object make() {
        return new Values();
    }

    public static Object make(Object[] vals) {
        if (vals.length == 1) {
            return vals[0];
        }
        if (vals.length == 0) {
            return empty;
        }
        return new Values(vals);
    }

    public static Object make(Sequence seq) {
        int count = seq.size();
        if (count == 0) {
            return empty;
        }
        if (count == 1) {
            return seq.get(0);
        }
        Values vals = new Values();
        Enumeration it = seq.elements();
        while (it.hasMoreElements()) {
            vals.writeObject(it.nextElement());
        }
        return vals;
    }

    public static Object make(TreeList list) {
        return Values.make(list, 0, list.data.length);
    }

    public static Object make(TreeList list, int startPosition, int endPosition) {
        int next;
        if (startPosition == endPosition || (next = list.nextDataIndex(startPosition)) <= 0) {
            return empty;
        }
        if (next == endPosition || list.nextDataIndex(next) < 0) {
            return list.getNext(startPosition, null);
        }
        Values vals = new Values();
        list.consumeRange(startPosition, endPosition, vals);
        return vals;
    }

    public Object call_with(Procedure proc) throws Throwable {
        return proc.applyN(this.toArray());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Values) {
            return super.equals(obj);
        }
        if (this.size() != 0) {
            return false;
        }
        Object x = this.getNext(0, null);
        return x != null && x.equals(obj);
    }

    public void print(PrintWriter ps) {
        if (this == empty) {
            ps.print("#!void");
            return;
        }
        Object[] vals = this.toArray();
        int size = vals.length;
        ps.print("#<values");
        for (int i = 0; i < size; ++i) {
            ps.print(" ");
            SFormat.print(vals[i], ps);
        }
        ps.print(">");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object[] vals = this.toArray();
        int len = vals.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeObject(vals[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.writeObject(in.readObject());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return this.isEmpty() ? empty : this;
    }

    public static int nextIndex(Object values, int curIndex) {
        if (values instanceof Values) {
            return ((Values)values).nextDataIndex(curIndex);
        }
        return curIndex == 0 ? 1 : -1;
    }

    public static Object nextValue(Object values, int curIndex) {
        if (values instanceof Values) {
            return ((Values)values).getNext(curIndex << 1, null);
        }
        return values;
    }

    public static void writeValues(Object value, Consumer out) {
        if (value instanceof Values) {
            ((Values)value).consume(out);
        } else {
            out.writeObject(value);
        }
    }
}

