/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceError;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceMessages {
    private int errorCount = 0;
    SourceError firstError;
    SourceError lastError;
    SourceError lastPrevFilename = null;

    public SourceError getErrors() {
        return this.firstError;
    }

    public boolean seenErrors() {
        return this.errorCount > 0;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void clearErrors() {
        this.errorCount = 0;
    }

    public void clear() {
        this.lastError = null;
        this.firstError = null;
        this.errorCount = 0;
    }

    public void error(SourceError error) {
        SourceError next;
        if (error.severity == 'f') {
            this.errorCount = 1000;
        } else if (error.severity != 'w') {
            ++this.errorCount;
        }
        if (this.lastError != null && this.lastError.filename != null && !this.lastError.filename.equals(error.filename)) {
            this.lastPrevFilename = this.lastError;
        }
        SourceError prev = this.lastPrevFilename;
        while ((next = prev == null ? this.firstError : prev.next) != null && (error.line == 0 || next.line == 0 || error.line >= next.line && (error.line != next.line || error.column == 0 || next.column == 0 || error.column >= next.column))) {
            prev = next;
        }
        if (prev == null) {
            error.next = this.firstError;
            this.firstError = error;
        } else {
            error.next = prev.next;
            prev.next = error;
        }
        if (prev == this.lastError) {
            this.lastError = error;
        }
    }

    public void error(char severity, String filename, int line, int column, String message) {
        this.error(new SourceError(severity, filename, line, column, message));
    }

    public void printAll(PrintStream out, int max) {
        SourceError err = this.firstError;
        while (err != null && --max >= 0) {
            out.println(err);
            err = err.next;
        }
    }

    public void printAll(PrintWriter out, int max) {
        SourceError err = this.firstError;
        while (err != null && --max >= 0) {
            out.println(err);
            err = err.next;
        }
    }

    public String toString(int max) {
        if (this.firstError == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        SourceError err = this.firstError;
        while (err != null && --max >= 0) {
            buffer.append(err);
            buffer.append('\n');
            err = err.next;
        }
        return buffer.toString();
    }

    public boolean checkErrors(PrintWriter out, int max) {
        if (this.firstError != null) {
            this.printAll(out, max);
            this.lastError = null;
            this.firstError = null;
            int saveCount = this.errorCount;
            this.errorCount = 0;
            return saveCount > 0;
        }
        return false;
    }

    public boolean checkErrors(PrintStream out, int max) {
        if (this.firstError != null) {
            this.printAll(out, max);
            this.lastError = null;
            this.firstError = null;
            int saveCount = this.errorCount;
            this.errorCount = 0;
            return saveCount > 0;
        }
        return false;
    }
}

