/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import bossa.util.Internal;
import mlsub.typing.AtomicKind;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Unsatisfiable;

public class NullnessKind
implements AtomicKind {
    public static NullnessKind instance = new NullnessKind();
    static TypeConstructor maybe;
    static TypeConstructor sure;

    public static void setMaybe(TypeConstructor tc) {
        maybe = tc;
    }

    public static void setSure(TypeConstructor tc) {
        sure = tc;
    }

    public int arity() {
        return 1;
    }

    public Monotype freshMonotype(boolean existential) {
        TypeConstructor tc = new TypeConstructor(instance);
        NullnessKind.introduce(tc);
        MonotypeVar raw = new MonotypeVar(existential);
        Typing.introduce(raw);
        return new MonotypeConstructor(tc, new MonotypeVar[]{raw});
    }

    public Monotype persistentFreshMonotype(MonotypeVar base) {
        TypeConstructor tc = new TypeConstructor(instance);
        MonotypeVar raw = new MonotypeVar(base.getName());
        return new MonotypeConstructor(tc, new MonotypeVar[]{raw});
    }

    static void introduce(TypeConstructor tc) {
        tc.getKind().register(tc);
        try {
            Typing.leq(tc, maybe);
            Typing.leq(sure, tc);
        }
        catch (TypingEx ex) {
            Internal.error("Nullness creation error");
        }
    }

    public void register(Element e) {
    }

    public void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (initial) {
            throw new InternalError("initial leq in Nullness");
        }
        this.leq(e1, e2);
    }

    public void leq(Element e1, Element e2) throws Unsatisfiable {
        Monotype m1 = (Monotype)e1;
        Monotype m2 = (Monotype)e2;
        if (m1.isUnknown()) {
            m2.setUnknown(false, true);
            return;
        }
        if (m2.isUnknown()) {
            m1.setUnknown(true, false);
            return;
        }
        MonotypeConstructor mc1 = this.mc(m1);
        MonotypeConstructor mc2 = this.mc(m2);
        Engine.leq(mc1.getTC(), mc2.getTC());
        Engine.leq(mc1.getTP()[0], mc2.getTP()[0]);
    }

    private MonotypeConstructor mc(Monotype m) {
        try {
            return (MonotypeConstructor)m.equivalent();
        }
        catch (ClassCastException ex) {
            throw new InternalError(m + " was expected to be a monotype constructor, " + " it's a " + m.getClass());
        }
    }

    public Engine.Constraint getConstraint() {
        return Engine.getConstraint(this);
    }

    public String toString() {
        return "Nullness kind";
    }
}

