/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.util.Internal;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.TypeVariable;
import java.util.HashSet;
import mlsub.typing.Constraint;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TypeSymbol;
import nice.tools.code.Types;

public class Import {
    private static HashSet strictPackages = new HashSet();

    public static Polytype type(Method m) {
        boolean constructor = m.isConstructor();
        ClassType declaringClass = m.getDeclaringClass();
        Type[] paramTypes = m.getFullParameterTypes();
        TypeVariable[] methodTypeParameters = m.getTypeParameters();
        TypeVariable[] typeParameters = null;
        TypeSymbol[] niceTP = null;
        if (m.getStaticFlag()) {
            if (methodTypeParameters != null) {
                typeParameters = new TypeVariable[methodTypeParameters.length];
                int i = methodTypeParameters.length;
                while (--i >= 0) {
                    typeParameters[i] = methodTypeParameters[i];
                }
                niceTP = Import.makeTP(typeParameters);
            }
        } else {
            TypeVariable[] classTypeParameters = declaringClass.getParameters();
            int nParams = classTypeParameters == null ? 0 : classTypeParameters.length;
            if ((nParams += methodTypeParameters == null ? 0 : methodTypeParameters.length) > 0) {
                int i;
                typeParameters = new TypeVariable[nParams];
                if (methodTypeParameters != null) {
                    i = methodTypeParameters.length;
                    while (--i >= 0) {
                        typeParameters[--nParams] = methodTypeParameters[i];
                    }
                }
                if (classTypeParameters != null) {
                    i = classTypeParameters.length;
                    while (--i >= 0) {
                        typeParameters[--nParams] = classTypeParameters[i];
                    }
                }
                niceTP = Import.makeTP(typeParameters);
            }
        }
        int n = 0;
        try {
            Monotype[] params;
            if (m.getStaticFlag() || constructor) {
                params = new Monotype[paramTypes.length];
            } else {
                params = new Monotype[paramTypes.length + 1];
                params[n++] = Types.monotype(declaringClass.thisType(), true, typeParameters, niceTP);
            }
            boolean nonNullArgs = strictPackages.contains(m.getDeclaringClass().getPackageName());
            for (int i = 0; i < paramTypes.length; ++i) {
                params[n++] = Types.monotype(paramTypes[i], nonNullArgs, typeParameters, niceTP);
            }
            Type javaRetType = constructor ? declaringClass.thisType() : m.getFullReturnType();
            Monotype retType = Types.monotype(javaRetType, true, typeParameters, niceTP);
            Constraint cst = niceTP == null ? null : new Constraint(niceTP, null);
            return new Polytype(cst, new FunType(params, retType));
        }
        catch (Types.ParametricClassException e) {
            Internal.warning("Java method " + m + " was ignored.\nReason: " + e);
            return null;
        }
        catch (Types.NotIntroducedClassException e) {
            Internal.warning("Java method " + m + " was ignored.\nReason: " + e);
            return null;
        }
    }

    private static TypeSymbol[] makeTP(TypeVariable[] vars) {
        TypeSymbol[] res = new TypeSymbol[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            res[i] = new MonotypeVar(vars[i].getName());
        }
        return res;
    }

    static void reset() {
        strictPackages.clear();
    }

    public static void addStrictPackage(String name) {
        strictPackages.add(name);
    }

    public static boolean isStrictPackage(String name) {
        return strictPackages.contains(name);
    }
}

