/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.ClassResolver;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractTypeAwareCheck
extends Check {
    private Set mImports = new HashSet();
    private FullIdent mPackageFullIdent;
    private String mCurrentClass;
    private ClassResolver mClassResolver;
    private final boolean mProcessClassToken;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    protected AbstractTypeAwareCheck(boolean aProcessClassToken) {
        this.mProcessClassToken = aProcessClassToken;
    }

    protected abstract void processAST(DetailAST var1);

    public void beginTree(DetailAST aRootAST) {
        this.mPackageFullIdent = FullIdent.createFullIdent(null);
        this.mImports.clear();
        this.mClassResolver = null;
        this.mCurrentClass = "";
    }

    public final void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            this.processPackage(aAST);
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else if (aAST.getType() == 14) {
            this.processClass(aAST);
            if (this.mProcessClassToken) {
                this.processAST(aAST);
            }
        } else {
            this.processAST(aAST);
        }
    }

    public final void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            int dotIdx = this.mCurrentClass.lastIndexOf(".");
            this.mCurrentClass = dotIdx == -1 ? "" : this.mCurrentClass.substring(0, dotIdx);
        }
    }

    protected boolean isShortName(String aShortName, String aFullName) {
        if (aShortName.length() >= aFullName.length()) {
            return false;
        }
        String base = Utils.baseClassname(aFullName);
        if (aShortName.length() >= aFullName.length() || !base.equals(aShortName)) {
            return false;
        }
        if (this.mImports.contains(aFullName)) {
            return true;
        }
        int endIndex = aFullName.length() - base.length() - 1;
        String packageName = aFullName.substring(0, endIndex);
        String starImport = packageName + ".*";
        if (this.mImports.contains(starImport)) {
            return true;
        }
        return packageName.equals(this.mPackageFullIdent.getText());
    }

    protected boolean isUnchecked(Class aException) {
        return this.isSubclass(aException, class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = AbstractTypeAwareCheck.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException) || this.isSubclass(aException, class$java$lang$Error == null ? (class$java$lang$Error = AbstractTypeAwareCheck.class$("java.lang.Error")) : class$java$lang$Error);
    }

    protected boolean isSubclass(Class aChild, Class aParent) {
        return aParent != null && aChild != null && aParent.isAssignableFrom(aChild);
    }

    protected boolean isSameType(String aFirst, String aSecond) {
        return aFirst.equals(aSecond) || this.isShortName(aFirst, aSecond) || this.isShortName(aSecond, aFirst);
    }

    private ClassResolver getClassResolver() {
        if (this.mClassResolver == null) {
            this.mClassResolver = new ClassResolver(this.getClassLoader(), this.mPackageFullIdent.getText(), this.mImports);
        }
        return this.mClassResolver;
    }

    protected final Class resolveClass(String aClassName, String aCurrentClass) {
        try {
            return this.getClassResolver().resolve(aClassName, aCurrentClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected final Class tryLoadClass(FullIdent aIdent, String aCurrentClass) {
        Class clazz = this.resolveClass(aIdent.getText(), aCurrentClass);
        if (clazz == null) {
            this.logLoadError(aIdent);
        }
        return clazz;
    }

    protected abstract void logLoadError(FullIdent var1);

    private void processPackage(DetailAST aAST) {
        DetailAST nameAST = (DetailAST)aAST.getFirstChild();
        this.mPackageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null) {
            this.mImports.add(name.getText());
        }
    }

    private void processClass(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        this.mCurrentClass = this.mCurrentClass + ("".equals(this.mCurrentClass) ? "" : "$") + ident.getText();
    }

    protected final String getCurrentClassName() {
        return this.mCurrentClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ClassInfo {
        private FullIdent mName;
        private Class mClass;
        private String mCurrentClass;
        private boolean mIsLoadable;

        public ClassInfo(FullIdent aName, String aCurrentClass) {
            if (aName == null) {
                throw new NullPointerException("ClassInfo's name should be non-null");
            }
            this.mName = aName;
            this.mCurrentClass = aCurrentClass;
            this.mIsLoadable = true;
        }

        public final FullIdent getName() {
            return this.mName;
        }

        public final boolean isLoadable() {
            return this.mIsLoadable;
        }

        public final Class getClazz() {
            if (this.isLoadable() && this.mClass == null) {
                this.setClazz(AbstractTypeAwareCheck.this.tryLoadClass(this.getName(), this.mCurrentClass));
            }
            return this.mClass;
        }

        public final void setClazz(Class aClass) {
            this.mClass = aClass;
            this.mIsLoadable = this.mClass != null;
        }
    }
}

