/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Stack;

public class JavaNCSSCheck
extends Check {
    private static final int FILE_MAX_NCSS = 2000;
    private static final int CLASS_MAX_NCSS = 1500;
    private static final int METHOD_MAX_NCSS = 50;
    private int mFileMax = 2000;
    private int mClassMax = 1500;
    private int mMethodMax = 50;
    private Stack mCounters;

    public int[] getDefaultTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 85, 86, 84, 90, 87, 88, 89, 91, 67, 96, 97, 28, 22, 93, 94};
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 85, 86, 84, 90, 87, 88, 89, 91, 67, 96, 97, 28, 22, 93, 94};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCounters = new Stack();
        this.mCounters.push(new Counter());
    }

    public void visitToken(DetailAST aAST) {
        int tokenType = aAST.getType();
        if (14 == tokenType || 9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            this.mCounters.push(new Counter());
        }
        if (this.isCountable(aAST)) {
            int size = this.mCounters.size();
            for (int i = 0; i < size; ++i) {
                ((Counter)this.mCounters.get(i)).increment();
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        Counter counter;
        int count;
        int tokenType = aAST.getType();
        if (9 == tokenType || 8 == tokenType || 12 == tokenType || 11 == tokenType) {
            Counter counter2 = (Counter)this.mCounters.pop();
            int count2 = counter2.getCount();
            if (count2 > this.mMethodMax) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "ncss.method", new Integer(count2), new Integer(this.mMethodMax));
            }
        } else if (14 == tokenType && (count = (counter = (Counter)this.mCounters.pop()).getCount()) > this.mClassMax) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "ncss.class", new Integer(count), new Integer(this.mClassMax));
        }
    }

    public void finishTree(DetailAST aRootAST) {
        Counter counter = (Counter)this.mCounters.pop();
        int count = counter.getCount();
        if (count > this.mFileMax) {
            this.log(aRootAST.getLineNo(), aRootAST.getColumnNo(), "ncss.file", new Integer(count), new Integer(this.mMethodMax));
        }
    }

    public void setFileMaximum(int aFileMax) {
        this.mFileMax = aFileMax;
    }

    public void setClassMaximum(int aClassMax) {
        this.mClassMax = aClassMax;
    }

    public void setMethodMaximum(int aMethodMax) {
        this.mMethodMax = aMethodMax;
    }

    private boolean isCountable(DetailAST aAST) {
        boolean countable = true;
        int tokenType = aAST.getType();
        if (28 == tokenType) {
            countable = this.isExpressionCountable(aAST);
        } else if (10 == tokenType) {
            countable = this.isVariableDefCountable(aAST);
        }
        return countable;
    }

    private boolean isVariableDefCountable(DetailAST aAST) {
        boolean countable = false;
        int parentType = aAST.getParent().getType();
        if (7 == parentType || 6 == parentType) {
            DetailAST prevSibling = aAST.getPreviousSibling();
            countable = prevSibling != null ? 74 != prevSibling.getType() : true;
        }
        return countable;
    }

    private boolean isExpressionCountable(DetailAST aAST) {
        boolean countable = true;
        int parentType = aAST.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 92: {
                DetailAST prevSibling = aAST.getPreviousSibling();
                countable = prevSibling == null || 76 != prevSibling.getType();
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }

    private class Counter {
        private int mIvCount;

        private Counter() {
        }

        public void increment() {
            ++this.mIvCount;
        }

        public int getCount() {
            return this.mIvCount;
        }
    }
}

