/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;
import net.sourceforge.pmd.util.NumericConstants;

public class Report {
    private static final RuleViolation.RuleViolationComparator COMPARATOR = new RuleViolation.RuleViolationComparator();
    private ReportTree violationTree = new ReportTree();
    private Set violations = new TreeSet(COMPARATOR);
    private Set metrics = new HashSet();
    private List listeners = new ArrayList();
    private List errors = new ArrayList();
    private Map linesToExclude = new HashMap();
    private long start;
    private long end;
    private List suppressedRuleViolations = new ArrayList();

    public void exclude(Map lines) {
        this.linesToExclude = lines;
    }

    public Map getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        Iterator iter = this.violationTree.iterator();
        while (iter.hasNext()) {
            Object o;
            IRuleViolation rv = (IRuleViolation)iter.next();
            String key = "";
            if (rv.getPackageName() != null && rv.getPackageName().length() != 0) {
                key = rv.getPackageName() + '.' + rv.getClassName();
            }
            if ((o = summary.get(key)) == null) {
                summary.put(key, NumericConstants.ONE);
                continue;
            }
            Integer value = (Integer)o;
            summary.put(key, new Integer(value + 1));
        }
        return summary;
    }

    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    public Map getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        Iterator i = this.violations.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            String name = rv.getRule().getName();
            if (!summary.containsKey(name)) {
                summary.put(name, NumericConstants.ZERO);
            }
            Integer count = (Integer)summary.get(name);
            summary.put(name, new Integer(count + 1));
        }
        return summary;
    }

    public void addListener(ReportListener listener) {
        this.listeners.add(listener);
    }

    public List getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(IRuleViolation violation) {
        Integer line = new Integer(violation.getBeginLine());
        if (this.linesToExclude.keySet().contains(line)) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true, (String)this.linesToExclude.get(line)));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false, null));
            return;
        }
        this.violations.add(violation);
        this.violationTree.addRuleViolation(violation);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.metricAdded(metric);
        }
    }

    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    public void merge(Report r) {
        Iterator i = r.errors();
        while (i.hasNext()) {
            this.addError((ProcessingError)i.next());
        }
        i = r.metrics();
        while (i.hasNext()) {
            this.addMetric((Metric)i.next());
        }
        i = r.iterator();
        while (i.hasNext()) {
            this.addRuleViolation((IRuleViolation)i.next());
        }
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && this.errors.isEmpty();
    }

    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    public Iterator treeIterator() {
        return this.violationTree.iterator();
    }

    public Iterator iterator() {
        return this.violations.iterator();
    }

    public Iterator errors() {
        return this.errors.iterator();
    }

    public int treeSize() {
        return this.violationTree.size();
    }

    public int size() {
        return this.violations.size();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    public static class SuppressedViolation {
        private IRuleViolation rv;
        private boolean isNOPMD;
        private String userMessage;

        public SuppressedViolation(IRuleViolation rv, boolean isNOPMD, String userMessage) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
            this.userMessage = userMessage;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public IRuleViolation getRuleViolation() {
            return this.rv;
        }

        public String getUserMessage() {
            return this.userMessage;
        }
    }

    public static class ProcessingError {
        private String msg;
        private String file;

        public ProcessingError(String msg, String file) {
            this.msg = msg;
            this.file = file;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class ReadableDuration {
        private long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            long seconds = 0L;
            long minutes = 0L;
            long hours = 0L;
            if (this.duration > 1000L) {
                seconds = this.duration / 1000L;
            }
            if (seconds > 60L) {
                minutes = seconds / 60L;
                seconds %= 60L;
            }
            if (minutes > 60L) {
                hours = minutes / 60L;
                minutes %= 60L;
            }
            StringBuffer res = new StringBuffer();
            if (hours > 0L) {
                res.append(hours).append("h ");
            }
            if (hours > 0L || minutes > 0L) {
                res.append(minutes).append("m ");
            }
            res.append(seconds).append('s');
            return res.toString();
        }
    }
}

