package net.sourceforge.pmd.util;

import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class Appendix {

    public static void main(String[] args) throws Exception {
        RuleSetFactory rsf = new RuleSetFactory();
        Iterator i = rsf.getRegisteredRuleSets();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            RuleSet rs = (RuleSet) i.next();
            if (rs.getName().toLowerCase().indexOf(args[0]) == -1) {
                continue;
            }
            sb.append("====================================================================" + PMD.EOL);
            sb.append(rs.getName() + PMD.EOL);
            sb.append(rs.getDescription() + PMD.EOL);
            sb.append("--------------------------------------------------------------------" + PMD.EOL);

            Collection rules = rs.getRules();
            for (Iterator j = rules.iterator(); j.hasNext();) {
                Rule r = (Rule) j.next();
                sb.append(r.getName() + ": " + trimCRs(r.getDescription()) + PMD.EOL);
                sb.append("Example: " + PMD.EOL + trimCRs(r.getExample()) + PMD.EOL);

                if (r.hasProperty("xpath")) {
                    sb.append("XPath expression:" + PMD.EOL);
                    sb.append(trimCRs(r.getProperties().getProperty("xpath")));
                }

                Set keys = r.getProperties().keySet();
                boolean header = false;
                for (Iterator k = keys.iterator(); k.hasNext();) {
                    String key = (String) k.next();
                    String value = (String) r.getProperties().getProperty(key);

                    if (key.equals("xpath")) {
                        continue;
                    }

                    if (!header) {
                        sb.append(PMD.EOL + "Properties:" + PMD.EOL);
                        header = true;
                    }

                    sb.append("Name = '" + key + "', value = '" + value + "'" + PMD.EOL);
                }
                sb.append(PMD.EOL + "Notes: " + PMD.EOL);
                sb.append(PMD.EOL + "--------------------------------------------------------------------" + PMD.EOL);
            }
        }
        System.out.println(sb.toString());
    }

    private static String trimCRs(String str) {
        while (str.startsWith(PMD.EOL)) {
            str = str.substring(1);
        }
        while (str.endsWith(PMD.EOL)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}
