/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.JacobObject;
import com.jacob.com.ROT;
import com.jacob.com.Variant;
import java.util.ArrayList;
import java.util.List;

class ROT3TestThread
extends Thread {
    private List variansCreatedInThisThread;
    private int initialRunSize = 0;

    public ROT3TestThread(String arg0, int iStartCount) {
        super(arg0);
        this.initialRunSize = iStartCount;
    }

    public void run() {
        this.variansCreatedInThisThread = new ArrayList(this.initialRunSize);
        int i = 0;
        while (i < this.initialRunSize) {
            Variant aNewVariant = new Variant(String.valueOf(this.getName()) + "_" + i);
            this.variansCreatedInThisThread.add(aNewVariant);
            ++i;
        }
        while (this.variansCreatedInThisThread.size() > 1) {
            String message = "";
            message = String.valueOf(this.getName()) + " Workingset=" + this.variansCreatedInThisThread.size() + " ROT threadObject hashCode: " + ROT.getThreadObjects(true).hashCode();
            message = String.valueOf(message) + " size before mods and gc " + ROT.getThreadObjects(true).size() + ")";
            if (this.variansCreatedInThisThread.size() > 10) {
                message = String.valueOf(message) + " (adding) ";
                int i2 = 0;
                while (i2 < this.variansCreatedInThisThread.size() / 4) {
                    Variant aNewVariant = new Variant(String.valueOf(this.getName()) + "_*" + this.variansCreatedInThisThread.size());
                    this.variansCreatedInThisThread.add(aNewVariant);
                    ++i2;
                }
            }
            message = String.valueOf(message) + " (removing)  ";
            int i3 = this.variansCreatedInThisThread.size();
            while (i3 > 0) {
                if (i3 % 2 == 0) {
                    if (!ROT.USE_AUTOMATIC_GARBAGE_COLLECTION) {
                        ROT.removeObject((JacobObject)this.variansCreatedInThisThread.get(i3 - 1));
                    }
                    this.variansCreatedInThisThread.remove(i3 - 1);
                }
                --i3;
            }
            message = String.valueOf(message) + " (after mods " + ROT.getThreadObjects(true).size() + ")";
            if (!ROT.USE_AUTOMATIC_GARBAGE_COLLECTION) {
                ROT.clearObjects();
            }
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            message = String.valueOf(message) + " (after gc " + ROT.getThreadObjects(true).size() + ")";
            message = String.valueOf(message) + " Should see GC if debug turned on...";
            System.out.println(message);
        }
    }

    public String toString() {
        return super.toString();
    }
}

