/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.user.cellview.client.Column;
import java.util.ArrayList;
import java.util.List;

public class ColumnSortList {
    private final Delegate delegate;
    private final List<ColumnSortInfo> infos = new ArrayList<ColumnSortInfo>();
    private int limit = 0;

    public ColumnSortList() {
        this(null);
    }

    public ColumnSortList(Delegate delegate) {
        this.delegate = delegate;
    }

    public void clear() {
        this.infos.clear();
        this.fireDelegate();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColumnSortList)) {
            return false;
        }
        ColumnSortList other = (ColumnSortList)obj;
        return this.infos.equals(other.infos);
    }

    public ColumnSortInfo get(int index) {
        return this.infos.get(index);
    }

    public int getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return 31 * this.infos.hashCode() + 13;
    }

    public void insert(int index, ColumnSortInfo sortInfo) {
        if (sortInfo == null) {
            throw new IllegalArgumentException("sortInfo cannot be null");
        }
        Column<?, ?> column = sortInfo.getColumn();
        for (int i = 0; i < this.infos.size(); ++i) {
            ColumnSortInfo curInfo = this.infos.get(i);
            if (curInfo.getColumn() != column) continue;
            this.infos.remove(i);
            if (i < index) {
                --index;
            }
            --i;
        }
        if (this.limit > 0) {
            if (this.limit == this.infos.size()) {
                this.infos.remove(this.infos.size() - 1);
            }
            if (index >= this.limit) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Limit: " + this.limit);
            }
        }
        this.infos.add(index, sortInfo);
        this.fireDelegate();
    }

    public ColumnSortInfo push(Column<?, ?> column) {
        boolean ascending;
        boolean bl = ascending = column == null ? true : column.isDefaultSortAscending();
        if (this.size() > 0 && this.get(0).getColumn() == column) {
            ascending = !this.get(0).isAscending();
        }
        ColumnSortInfo toRet = new ColumnSortInfo(column, ascending);
        this.push(toRet);
        return toRet;
    }

    public void push(ColumnSortInfo sortInfo) {
        this.insert(0, sortInfo);
    }

    public boolean remove(ColumnSortInfo sortInfo) {
        boolean toRet = this.infos.remove(sortInfo);
        this.fireDelegate();
        return toRet;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > 0) {
            boolean modified = false;
            while (limit < this.infos.size()) {
                this.infos.remove(this.infos.size() - 1);
                modified = true;
            }
            if (modified) {
                this.fireDelegate();
            }
        }
    }

    public int size() {
        return this.infos.size();
    }

    private void fireDelegate() {
        if (this.delegate != null) {
            this.delegate.onModification();
        }
    }

    public static interface Delegate {
        public void onModification();
    }

    public static class ColumnSortInfo {
        private final boolean ascending;
        private final Column<?, ?> column;

        public ColumnSortInfo(Column<?, ?> column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }

        ColumnSortInfo() {
            this(null, true);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ColumnSortInfo)) {
                return false;
            }
            ColumnSortInfo other = (ColumnSortInfo)obj;
            return this.equalsOrBothNull(this.getColumn(), other.getColumn()) && this.isAscending() == other.isAscending();
        }

        public Column<?, ?> getColumn() {
            return this.column;
        }

        public int hashCode() {
            return 31 * (this.column == null ? 0 : this.column.hashCode()) + (this.ascending ? 1 : 0);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        private boolean equalsOrBothNull(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

