/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.tranql.connector.jdbc.ConnectionHandle;
import org.tranql.connector.jdbc.ResultSetHandle;

public class StatementHandle<T extends Statement>
implements Statement {
    protected final ConnectionHandle c;
    protected final T s;

    public StatementHandle(ConnectionHandle c, T s) {
        this.c = c;
        this.s = s;
    }

    @Override
    public Connection getConnection() {
        return this.c;
    }

    private ResultSet wrapResultSet(ResultSet rs) {
        return rs == null ? null : new ResultSetHandle(this, rs);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.wrapResultSet(this.s.executeQuery(sql));
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.wrapResultSet(this.s.getGeneratedKeys());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.wrapResultSet(this.s.getResultSet());
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.s.addBatch(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.s.cancel();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.s.clearBatch();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.s.clearWarnings();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.s.close();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.s.execute(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.s.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.s.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.s.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.s.executeBatch();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.s.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.s.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.s.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.s.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.s.getFetchDirection();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.s.getFetchSize();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.s.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.s.getMaxRows();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.s.getMoreResults();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.s.getMoreResults(current);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.s.getQueryTimeout();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.s.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.s.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.s.isClosed();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        try {
            this.setPoolable(b);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.s.isPoolable();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.s.getResultSetType();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.s.getUpdateCount();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.s.getWarnings();
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.s.setCursorName(name);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.s.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.s.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.s.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.s.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.s.setMaxRows(max);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.s.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        try {
            return this.s.unwrap(tClass);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        try {
            return this.s.isWrapperFor(aClass);
        }
        catch (SQLException e) {
            this.c.connectionError(e);
            throw e;
        }
    }
}

