/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.log4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.DummyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StandardTests
extends TestCase {
    private void checkLoggingEvents(List logEvents, boolean thrown) {
        StandardTests.assertEquals((String)"Unexpected number of log events", (int)4, (int)logEvents.size());
        LogEvent ev = (LogEvent)logEvents.get(0);
        StandardTests.assertEquals((String)"Info message expected", (String)"info", (String)ev.msg);
        StandardTests.assertEquals((String)"Info level expected", (String)"INFO", (String)ev.level);
        StandardTests.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(1);
        StandardTests.assertEquals((String)"Warn message expected", (String)"warn", (String)ev.msg);
        StandardTests.assertEquals((String)"Warn level expected", (String)"WARN", (String)ev.level);
        StandardTests.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(2);
        StandardTests.assertEquals((String)"Error message expected", (String)"error", (String)ev.msg);
        StandardTests.assertEquals((String)"Error level expected", (String)"ERROR", (String)ev.level);
        StandardTests.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
        ev = (LogEvent)logEvents.get(3);
        StandardTests.assertEquals((String)"Fatal message expected", (String)"fatal", (String)ev.msg);
        StandardTests.assertEquals((String)"Fatal level expected", (String)"FATAL", (String)ev.level);
        StandardTests.assertEquals((String)"Exception data incorrect", (ev.throwable != null ? 1 : 0) != 0, (boolean)thrown);
    }

    private void logExceptionMessages(Log log) {
        DummyException t = new DummyException();
        log.trace((Object)"trace", (Throwable)t);
        log.debug((Object)"debug", (Throwable)t);
        log.info((Object)"info", (Throwable)t);
        log.warn((Object)"warn", (Throwable)t);
        log.error((Object)"error", (Throwable)t);
        log.fatal((Object)"fatal", (Throwable)t);
    }

    private void logPlainMessages(Log log) {
        log.trace((Object)"trace");
        log.debug((Object)"debug");
        log.info((Object)"info");
        log.warn((Object)"warn");
        log.error((Object)"error");
        log.fatal((Object)"fatal");
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public abstract void setUpTestAppender(List var1) throws Exception;

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testCreateFactory() {
        LogFactory factory = LogFactory.getFactory();
        StandardTests.assertNotNull((String)"LogFactory exists", (Object)factory);
        StandardTests.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)factory.getClass().getName());
        String[] names = factory.getAttributeNames();
        StandardTests.assertNotNull((String)"Names exists", (Object)names);
        StandardTests.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testExceptionMessages() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        this.logExceptionMessages(log);
        this.checkLoggingEvents(logEvents, true);
    }

    public void testPlainMessages() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        this.logPlainMessages(log);
        this.checkLoggingEvents(logEvents, false);
    }

    public void testSerializable() throws Exception {
        ArrayList logEvents = new ArrayList();
        this.setUpTestAppender(logEvents);
        Log log = LogFactory.getLog((String)"test-category");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Log newLog = (Log)ois.readObject();
        ois.close();
        this.logExceptionMessages(newLog);
        this.checkLoggingEvents(logEvents, true);
    }

    public static class LogEvent {
        public String msg;
        public String level;
        public Throwable throwable;
    }
}

