/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.util.Arrays;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.CorrelatedRandomVectorGenerator;
import org.apache.commons.math3.random.GaussianRandomGenerator;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.stat.correlation.StorelessCovariance;
import org.apache.commons.math3.stat.descriptive.moment.VectorialCovariance;
import org.apache.commons.math3.stat.descriptive.moment.VectorialMean;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class CorrelatedRandomVectorGeneratorTest {
    private double[] mean = new double[]{0.0, 1.0, -3.0, 2.3};
    private RealMatrix covariance;
    private CorrelatedRandomVectorGenerator generator;

    public CorrelatedRandomVectorGeneratorTest() {
        RealMatrix b = MatrixUtils.createRealMatrix((int)4, (int)3);
        int counter = 0;
        for (int i = 0; i < b.getRowDimension(); ++i) {
            for (int j = 0; j < b.getColumnDimension(); ++j) {
                b.setEntry(i, j, 1.0 + 0.1 * (double)(++counter));
            }
        }
        RealMatrix bbt = b.multiply(b.transpose());
        this.covariance = MatrixUtils.createRealMatrix((int)this.mean.length, (int)this.mean.length);
        for (int i = 0; i < this.covariance.getRowDimension(); ++i) {
            this.covariance.setEntry(i, i, bbt.getEntry(i, i));
            for (int j = 0; j < this.covariance.getColumnDimension(); ++j) {
                double s = bbt.getEntry(i, j);
                this.covariance.setEntry(i, j, s);
                this.covariance.setEntry(j, i, s);
            }
        }
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(17399225432L);
        GaussianRandomGenerator rawGenerator = new GaussianRandomGenerator((RandomGenerator)rg);
        this.generator = new CorrelatedRandomVectorGenerator(this.mean, this.covariance, 1.0E-12 * this.covariance.getNorm(), (NormalizedRandomGenerator)rawGenerator);
    }

    @Test
    public void testRank() {
        Assert.assertEquals((long)2L, (long)this.generator.getRank());
    }

    @Test
    public void testMath226() {
        double[] mean = new double[]{1.0, 1.0, 10.0, 1.0};
        double[][] cov = new double[][]{{1.0, 3.0, 2.0, 6.0}, {3.0, 13.0, 16.0, 2.0}, {2.0, 16.0, 38.0, -1.0}, {6.0, 2.0, -1.0, 197.0}};
        RealMatrix covRM = MatrixUtils.createRealMatrix((double[][])cov);
        JDKRandomGenerator jg = new JDKRandomGenerator();
        jg.setSeed(5322145245211L);
        GaussianRandomGenerator rg = new GaussianRandomGenerator((RandomGenerator)jg);
        CorrelatedRandomVectorGenerator sg = new CorrelatedRandomVectorGenerator(mean, covRM, 1.0E-5, (NormalizedRandomGenerator)rg);
        double[] min = new double[mean.length];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        double[] max = new double[mean.length];
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < 10; ++i) {
            double[] generated = sg.nextVector();
            for (int j = 0; j < generated.length; ++j) {
                min[j] = FastMath.min((double)min[j], (double)generated[j]);
                max[j] = FastMath.max((double)max[j], (double)generated[j]);
            }
        }
        for (int j = 0; j < min.length; ++j) {
            Assert.assertTrue((max[j] - min[j] > 2.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRootMatrix() {
        RealMatrix b = this.generator.getRootMatrix();
        RealMatrix bbt = b.multiply(b.transpose());
        for (int i = 0; i < this.covariance.getRowDimension(); ++i) {
            for (int j = 0; j < this.covariance.getColumnDimension(); ++j) {
                Assert.assertEquals((double)this.covariance.getEntry(i, j), (double)bbt.getEntry(i, j), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testMeanAndCovariance() {
        VectorialMean meanStat = new VectorialMean(this.mean.length);
        VectorialCovariance covStat = new VectorialCovariance(this.mean.length, true);
        for (int i = 0; i < 5000; ++i) {
            double[] v = this.generator.nextVector();
            meanStat.increment(v);
            covStat.increment(v);
        }
        double[] estimatedMean = meanStat.getResult();
        RealMatrix estimatedCovariance = covStat.getResult();
        for (int i = 0; i < estimatedMean.length; ++i) {
            Assert.assertEquals((double)this.mean[i], (double)estimatedMean[i], (double)0.07);
            for (int j = 0; j <= i; ++j) {
                Assert.assertEquals((double)this.covariance.getEntry(i, j), (double)estimatedCovariance.getEntry(i, j), (double)(0.1 * (1.0 + FastMath.abs((double)this.mean[i])) * (1.0 + FastMath.abs((double)this.mean[j]))));
            }
        }
    }

    @Test
    public void testSampleWithZeroCovariance() {
        double[][] covMatrix1 = new double[][]{{0.013445532, 0.01039469, 0.009881156, 0.010499559}, {0.01039469, 0.023006616, 0.008196856, 0.010732709}, {0.009881156, 0.008196856, 0.019023866, 0.009210099}, {0.010499559, 0.010732709, 0.009210099, 0.019107243}};
        double[][] covMatrix2 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.013445532, 0.01039469, 0.009881156, 0.010499559}, {0.0, 0.01039469, 0.023006616, 0.008196856, 0.010732709}, {0.0, 0.009881156, 0.008196856, 0.019023866, 0.009210099}, {0.0, 0.010499559, 0.010732709, 0.009210099, 0.019107243}};
        double[][] covMatrix3 = new double[][]{{0.013445532, 0.01039469, 0.0, 0.009881156, 0.010499559}, {0.01039469, 0.023006616, 0.0, 0.008196856, 0.010732709}, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.009881156, 0.008196856, 0.0, 0.019023866, 0.009210099}, {0.010499559, 0.010732709, 0.0, 0.009210099, 0.019107243}};
        this.testSampler(covMatrix1, 10000, 0.001);
        this.testSampler(covMatrix2, 10000, 0.001);
        this.testSampler(covMatrix3, 10000, 0.001);
    }

    private CorrelatedRandomVectorGenerator createSampler(double[][] cov) {
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(cov);
        double small = 1.0E-11 * matrix.getNorm();
        return new CorrelatedRandomVectorGenerator(new double[cov.length], (RealMatrix)matrix, small, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)new Well1024a(3920989002904244033L)));
    }

    private void testSampler(double[][] covMatrix, int samples, double epsilon) {
        CorrelatedRandomVectorGenerator sampler = this.createSampler(covMatrix);
        StorelessCovariance cov = new StorelessCovariance(covMatrix.length);
        for (int i = 0; i < samples; ++i) {
            cov.increment(sampler.nextVector());
        }
        double[][] sampleCov = cov.getData();
        for (int r = 0; r < covMatrix.length; ++r) {
            TestUtils.assertEquals(covMatrix[r], sampleCov[r], epsilon);
        }
    }
}

